/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings.views;

import com.minecolonies.api.configuration.Configurations;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class MobEntryView {
    private int priority;
    private ResourceLocation location;
    private boolean shouldAttack;

    public MobEntryView(ResourceLocation location, Boolean shouldAttack, Integer priority) {
        this.location = location;
        this.shouldAttack = shouldAttack;
        this.priority = priority;
    }

    public static void writeToByteBuf(@NotNull ByteBuf buf, @NotNull MobEntryView entry) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getLocation().toString());
        buf.writeBoolean(entry.shouldAttack());
        buf.writeInt(entry.getPriority());
    }

    @NotNull
    public static MobEntryView readFromByteBuf(@NotNull ByteBuf buf) {
        ResourceLocation location = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        Boolean attack = buf.readBoolean();
        Integer priority = buf.readInt();
        return new MobEntryView(location, attack, priority);
    }

    public static void writeToNBT(@NotNull NBTTagCompound compound, String name, @NotNull MobEntryView entry) {
        NBTTagCompound coordsCompound = new NBTTagCompound();
        coordsCompound.func_74778_a("location", entry.getLocation().toString());
        coordsCompound.func_74757_a("attack", entry.shouldAttack());
        coordsCompound.func_74768_a("priority", entry.getPriority());
        compound.func_74782_a(name, (NBTBase)coordsCompound);
    }

    @NotNull
    public static MobEntryView readFromNBT(@NotNull NBTTagCompound compound, String name) {
        NBTTagCompound entryCompound = compound.func_74775_l(name);
        ResourceLocation location = new ResourceLocation(entryCompound.func_74779_i("location"));
        Boolean attack = entryCompound.func_74767_n("attack");
        Integer priority = entryCompound.func_74762_e("priority");
        return new MobEntryView(location, attack, priority);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public boolean shouldAttack() {
        return this.shouldAttack;
    }

    public void setShouldAttack(boolean shouldAttack) {
        this.shouldAttack = shouldAttack;
    }

    public String getName() {
        if (Configurations.gameplay.enableInDevelopmentFeatures) {
            return EntityList.func_191302_a((ResourceLocation)this.location) + ": " + this.priority;
        }
        return EntityList.func_191302_a((ResourceLocation)this.location);
    }

    public EntityEntry getEntityEntry() {
        return (EntityEntry)ForgeRegistries.ENTITIES.getValue(this.getLocation());
    }
}

