/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.controls.TextField;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSifter;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowHutSifter
extends AbstractWindowWorkerBuilding<BuildingSifter.View> {
    private static final String BLOCK_BUTTON = "block";
    private static final String MESH_BUTTON = "buyMesh";
    private static final String BUTTON_SAVE = "save";
    private static final String QTY_INPUT = "qty";
    private static final String SIFTER_RESOURCE_SUFFIX = ":gui/windowhutsifter.xml";
    private final ScrollingList meshList;
    private ItemStorage block;
    private ItemStorage mesh;

    public WindowHutSifter(BuildingSifter.View building) {
        super(building, "minecolonies:gui/windowhutsifter.xml");
        Button crushingSettingsButton = this.findPaneOfTypeByID(BLOCK_BUTTON, Button.class);
        TextField sifterSettingsInput = this.findPaneOfTypeByID(QTY_INPUT, TextField.class);
        this.meshList = this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.registerButton(MESH_BUTTON, this::switchMesh);
        this.registerButton(BLOCK_BUTTON, this::switchSievableBlock);
        this.registerButton(BUTTON_SAVE, this::save);
        this.block = building.getSifterBlock();
        this.mesh = building.getMesh();
        sifterSettingsInput.setText(String.valueOf(building.getDailyQuantity()));
        this.setupSettings(crushingSettingsButton);
        this.updateResourceList();
    }

    private void updateResourceList() {
        this.meshList.enable();
        this.meshList.show();
        final int size = ((BuildingSifter.View)this.building).getBuildingLevel() - ((BuildingSifter.View)this.building).getMeshes().size() + 3;
        this.meshList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return Math.max(Math.min(size, ((BuildingSifter.View)WindowHutSifter.this.building).getMeshes().size()), 1);
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = ((BuildingSifter.View)WindowHutSifter.this.building).getMeshes().get(index).getItemStack();
                Label resourceLabel = rowPane.findPaneOfTypeByID("resourceName", Label.class);
                boolean isSet = false;
                if (resource.func_77969_a(WindowHutSifter.this.mesh.getItemStack())) {
                    resourceLabel.setColor(2, 2);
                    resourceLabel.setLabelText("\u00a72" + resource.func_82833_r() + "\u00a7r");
                    isSet = true;
                } else {
                    resourceLabel.setColor(7, 7);
                    resourceLabel.setLabelText(resource.func_82833_r());
                }
                rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class).setItem(resource);
                Button switchButton = rowPane.findPaneOfTypeByID(WindowHutSifter.MESH_BUTTON, Button.class);
                if (!InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by), stack -> stack.func_77969_a(resource)) || isSet) {
                    switchButton.hide();
                } else {
                    switchButton.show();
                }
            }
        });
    }

    private void switchMesh(Button button) {
        int row = this.meshList.getListElementIndexByPane(button);
        this.mesh = ((BuildingSifter.View)this.building).getMeshes().get(row);
        TextField crushingSettingsInput = this.findPaneOfTypeByID(QTY_INPUT, TextField.class);
        try {
            int qty = Integer.parseInt(crushingSettingsInput.getText());
            ((BuildingSifter.View)this.building).save(this.block, this.mesh, qty, true);
        }
        catch (NumberFormatException ex) {
            Log.getLogger().warn("Wrong input!");
        }
    }

    private void save() {
        TextField crushingSettingsInput = this.findPaneOfTypeByID(QTY_INPUT, TextField.class);
        try {
            int qty = Integer.parseInt(crushingSettingsInput.getText());
            ((BuildingSifter.View)this.building).save(this.block, this.mesh, qty, false);
        }
        catch (NumberFormatException ex) {
            Log.getLogger().warn("Wrong input!");
        }
    }

    private void switchSievableBlock(Button crushingSettingsButton) {
        List<ItemStorage> modes = ((BuildingSifter.View)this.building).getSievableBlocks();
        int index = modes.indexOf(this.block) + 1;
        if (index >= modes.size()) {
            index = 0;
        }
        this.block = modes.get(index);
        this.setupSettings(crushingSettingsButton);
    }

    private void setupSettings(Button crushingSettingsButton) {
        crushingSettingsButton.setLabel(this.block.getItemStack().func_82833_r());
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.Sifter";
    }
}

