/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import net.minecraft.client.resources.I18n;

public class WindowInfo
extends AbstractWindowSkeleton {
    private static final String WINDOW_RESOURCE = ":gui/windowinfo.xml";
    private final IBuildingView building;
    private int infoIndex;
    private final Label name;
    private final Label info;
    private final Button infoNextPage;
    private final Button infoPrevPage;
    private final String translationPrefix;

    public WindowInfo(IBuildingView building) {
        super("minecolonies:gui/windowinfo.xml");
        this.building = building;
        this.translationPrefix = "com.minecolonies.coremod.info." + building.getSchematicName() + ".";
        this.registerButton("exit", this::exitClicked);
        this.registerButton("infoNextPage", this::nextPage);
        this.registerButton("infoPrevPage", this::prevPage);
        this.infoNextPage = this.findPaneOfTypeByID("infoNextPage", Button.class);
        this.infoPrevPage = this.findPaneOfTypeByID("infoPrevPage", Button.class);
        this.name = this.findPaneOfTypeByID("name", Label.class);
        this.info = this.findPaneOfTypeByID("info", Label.class);
        this.infoIndex = 0;
        this.refreshPage();
    }

    private void exitClicked() {
        this.building.openGui(false);
    }

    private void refreshPage() {
        if (I18n.func_188566_a((String)(this.translationPrefix + (this.infoIndex + 1))) && !I18n.func_135052_a((String)(this.translationPrefix + (this.infoIndex + 1)), (Object[])new Object[0]).equals("")) {
            this.infoNextPage.enable();
        } else {
            this.infoNextPage.disable();
        }
        if (I18n.func_188566_a((String)(this.translationPrefix + (this.infoIndex - 1))) && !I18n.func_135052_a((String)(this.translationPrefix + (this.infoIndex - 1)), (Object[])new Object[0]).equals("")) {
            this.infoPrevPage.enable();
        } else {
            this.infoPrevPage.disable();
        }
        this.pageNum.setLabelText(Integer.toString(this.infoIndex));
        this.name.setLabelText(LanguageHandler.format(this.translationPrefix + this.infoIndex + ".name", new Object[0]));
        this.info.setLabelText(LanguageHandler.format(this.translationPrefix + this.infoIndex, new Object[0]).replace("\\n", "\n"));
    }

    private void nextPage() {
        ++this.infoIndex;
        this.refreshPage();
    }

    private void prevPage() {
        --this.infoIndex;
        this.refreshPage();
    }
}

