/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractFilterableListBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingRequestResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBuildingSmelterCrafter
extends AbstractFilterableListBuilding {
    private static final String TAG_POS = "pos";
    private static final String TAG_FURNACES = "furnaces";
    private final List<BlockPos> furnaces = new ArrayList<BlockPos>();
    private static final int EXTRA_RECIPE_MULTIPLIER = 10;

    public AbstractBuildingSmelterCrafter(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        ImmutableCollection<IRequestResolver<?>> supers = super.createResolvers();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(supers);
        builder.add((Object)new PublicWorkerCraftingRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        builder.add((Object)new PublicWorkerCraftingProductionResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<ItemStorage, Tuple> recipeOutputs = new HashMap<ItemStorage, Tuple>();
        for (ICitizenData citizen : this.getAssignedCitizen()) {
            if (!(citizen.getJob() instanceof AbstractJobCrafter)) continue;
            List<IToken<?>> assignedTaskIds = ((AbstractJobCrafter)citizen.getJob()).getAssignedTasksFromDataStore();
            for (IToken<?> taskToken : assignedTaskIds) {
                IRequest<?> request = this.colony.getRequestManager().getRequestForToken(taskToken);
                IRecipeStorage recipeStorage = this.getFirstFullFillableRecipe(((PublicCrafting)request.getRequest()).getStack());
                for (ItemStorage itemStorage : recipeStorage.getCleanedInput()) {
                    if (recipeOutputs.containsKey(itemStorage)) {
                        itemStorage.setAmount((Integer)((Tuple)recipeOutputs.get(itemStorage)).func_76341_a() + itemStorage.getAmount());
                    }
                    recipeOutputs.put(itemStorage, new Tuple((Object)itemStorage.getAmount(), (Object)true));
                }
            }
        }
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(this.keepX);
        toKeep.putAll(recipeOutputs.entrySet().stream().collect(Collectors.toMap(key -> stack -> stack.func_77969_a(((ItemStorage)key.getKey()).getItemStack()), Map.Entry::getValue)));
        return toKeep;
    }

    public List<BlockPos> getFurnaces() {
        return new ArrayList<BlockPos>(this.furnaces);
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        NBTTagList furnaceTagList = compound.func_150295_c(TAG_FURNACES, 10);
        for (int i = 0; i < furnaceTagList.func_74745_c(); ++i) {
            this.furnaces.add(NBTUtil.func_186861_c((NBTTagCompound)furnaceTagList.func_150305_b(i).func_74775_l(TAG_POS)));
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        NBTTagList furnacesTagList = new NBTTagList();
        for (BlockPos entry : this.furnaces) {
            NBTTagCompound furnaceCompound = new NBTTagCompound();
            furnaceCompound.func_74782_a(TAG_POS, (NBTBase)NBTUtil.func_186859_a((BlockPos)entry));
            furnacesTagList.func_74742_a((NBTBase)furnaceCompound);
        }
        compound.func_74782_a(TAG_FURNACES, (NBTBase)furnacesTagList);
        return compound;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block instanceof BlockFurnace && !this.furnaces.contains(pos)) {
            this.furnaces.add(pos);
        }
        this.markDirty();
    }

    public List<ItemStack> getAllowedFuel() {
        return this.getCopyOfAllowedItems().get("fuel").stream().map(ItemStorage::getItemStack).peek(stack -> stack.func_190920_e(stack.func_77976_d())).collect(Collectors.toList());
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return true;
    }

    @Override
    public boolean canRecipeBeAdded(IToken token) {
        return AbstractBuildingSmelterCrafter.canBuildingCanLearnMoreRecipes(this.getBuildingLevel(), super.getRecipes().size());
    }

    public void removeFromFurnaces(BlockPos pos) {
        this.furnaces.remove(pos);
    }

    public static boolean canBuildingCanLearnMoreRecipes(int buildingLevel, int learnedRecipes) {
        return Math.pow(2.0, buildingLevel) * 10.0 >= (double)(learnedRecipes + 1);
    }

    public static class View
    extends AbstractFilterableListsView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public boolean canRecipeBeAdded() {
            return AbstractBuildingSmelterCrafter.canBuildingCanLearnMoreRecipes(this.getBuildingLevel(), super.getRecipes().size());
        }
    }
}

