/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.permissions;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.network.PacketUtils;
import com.minecolonies.api.util.Utils;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionsView
implements IPermissions {
    @NotNull
    private final Map<UUID, Player> players = new HashMap<UUID, Player>();
    @NotNull
    private final Map<Rank, Integer> permissions = new EnumMap<Rank, Integer>(Rank.class);
    private Rank userRank = Rank.NEUTRAL;

    public Rank getUserRank() {
        return this.userRank;
    }

    @Override
    @NotNull
    public Set<Player> getPlayersByRank(Rank rank) {
        return Collections.unmodifiableSet(this.players.values().stream().filter(player -> player.getRank() == rank).collect(Collectors.toSet()));
    }

    @Override
    @NotNull
    public Map<UUID, Player> getPlayers() {
        return Collections.unmodifiableMap(this.players);
    }

    @Override
    public boolean setPlayerRank(UUID id, Rank rank, World world) {
        return false;
    }

    @Override
    public boolean addPlayer(@NotNull GameProfile gameprofile, Rank rank) {
        return false;
    }

    @Override
    @NotNull
    public Set<Player> getPlayersByRank(@NotNull Set<Rank> ranks) {
        return Collections.unmodifiableSet(this.players.values().stream().filter(player -> ranks.contains((Object)player.getRank())).collect(Collectors.toSet()));
    }

    @NotNull
    public Map<Rank, Integer> getPermissions() {
        return this.permissions;
    }

    public boolean hasPermission(UUID id, @NotNull Action action) {
        return this.hasPermission(this.getRank(id), action);
    }

    @Override
    public boolean hasPermission(Rank rank, @NotNull Action action) {
        return rank == Rank.OWNER && action != Action.GUARDS_ATTACK || this.permissions != null && action != null && this.permissions.containsKey((Object)rank) && Utils.testFlag(this.permissions.get((Object)rank), action.getFlag());
    }

    @Override
    public boolean setPermission(Rank rank, @NotNull Action action) {
        int flags = this.permissions.get((Object)rank);
        if (!Utils.testFlag(flags, action.getFlag())) {
            this.permissions.put(rank, Utils.setFlag(flags, action.getFlag()));
            return true;
        }
        return false;
    }

    @Override
    public boolean removePermission(Rank rank, @NotNull Action action) {
        int flags = this.permissions.get((Object)rank);
        if (Utils.testFlag(flags, action.getFlag())) {
            this.permissions.put(rank, Utils.unsetFlag(flags, action.getFlag()));
            return true;
        }
        return false;
    }

    @Override
    public boolean removePlayer(UUID playerID) {
        return false;
    }

    @Override
    public void togglePermission(Rank rank, @NotNull Action action) {
        this.permissions.put(rank, Utils.toggleFlag(this.permissions.get((Object)rank), action.getFlag()));
    }

    @Override
    @Nullable
    public Map.Entry<UUID, Player> getOwnerEntry() {
        return null;
    }

    @Override
    public boolean setOwner(EntityPlayer player) {
        return false;
    }

    @Override
    @NotNull
    public UUID getOwner() {
        return null;
    }

    public void deserialize(@NotNull ByteBuf buf) {
        this.userRank = Rank.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.players.clear();
        int numOwners = buf.readInt();
        for (int i = 0; i < numOwners; ++i) {
            UUID id = PacketUtils.readUUID(buf);
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            Rank rank = Rank.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.players.put(id, new Player(id, name, rank));
        }
        this.permissions.clear();
        int numPermissions = buf.readInt();
        for (int i = 0; i < numPermissions; ++i) {
            Rank rank = Rank.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
            int flags = buf.readInt();
            this.permissions.put(rank, flags);
        }
    }

    @Override
    @NotNull
    public Rank getRank(@NotNull EntityPlayer player) {
        return this.getRank(player.func_110124_au());
    }

    @Override
    public void restoreOwnerIfNull() {
    }

    @Override
    @NotNull
    public Rank getRank(UUID id) {
        Player player = this.players.get(id);
        return player == null ? Rank.NEUTRAL : player.getRank();
    }

    @Override
    public boolean hasPermission(@NotNull EntityPlayer player, @NotNull Action action) {
        return this.hasPermission(this.getRank(player), action);
    }

    @Override
    public boolean addPlayer(@NotNull String player, Rank rank, World world) {
        return false;
    }

    @Override
    public boolean addPlayer(@NotNull UUID id, String name, Rank rank) {
        return false;
    }

    @Override
    @Nullable
    public String getOwnerName() {
        return null;
    }

    @Override
    public boolean isSubscriber(@NotNull EntityPlayer player) {
        return false;
    }

    @Override
    public boolean isColonyMember(@NotNull EntityPlayer player) {
        return this.players.containsKey(player.func_110124_au());
    }
}

