/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.pvp;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.colony.Colony;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;

public class AttackingPlayer {
    private final EntityPlayer player;
    private final List<AbstractEntityCitizen> guards = new ArrayList<AbstractEntityCitizen>();

    public AttackingPlayer(EntityPlayer player) {
        this.player = player;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public static boolean isValidAttack(AbstractEntityCitizen citizen, Colony colony) {
        IColony guardColony = citizen.getCitizenColonyHandler().getColony();
        if (guardColony == null) {
            return false;
        }
        if (colony.getPermissions().getRank(guardColony.getPermissions().getOwner()) == Rank.HOSTILE) {
            return true;
        }
        return guardColony.getPermissions().getRank(colony.getPermissions().getOwner()) == Rank.HOSTILE && guardColony.getRaiderManager().getColonyRaidLevel() <= colony.getRaiderManager().getColonyRaidLevel() * 2;
    }

    public List<AbstractEntityCitizen> getGuards() {
        return ImmutableList.copyOf(this.guards);
    }

    public boolean addGuard(AbstractEntityCitizen guard) {
        if (!this.guards.contains((Object)guard)) {
            this.guards.add(guard);
            return true;
        }
        return false;
    }

    public boolean isValidAttack(Colony colony) {
        if (this.guards.isEmpty()) {
            return false;
        }
        return AttackingPlayer.isValidAttack(this.guards.get(0), colony);
    }

    public void removeGuard(AbstractEntityCitizen guard) {
        this.guards.add(guard);
    }

    public void refreshList(Colony colony) {
        for (AbstractEntityCitizen citizen : new ArrayList<AbstractEntityCitizen>(this.guards)) {
            if (!citizen.isDead() && colony.isCoordInColony(colony.getWorld(), citizen.func_180425_c())) continue;
            this.guards.remove((Object)citizen);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttackingPlayer that = (AttackingPlayer)o;
        return Objects.equals(this.player, that.player);
    }

    public int hashCode() {
        return Objects.hash(this.player);
    }
}

