/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.generalcommands;

import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class LootGenCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "lootGen";
    public static final String TADA = "TADA! Well done you just got yourself a nice treat!";
    private static final String NO_PERMISSION_MESSAGE = "You do not have permission to generate this sweet loot!";

    public LootGenCommand() {
        super(new String[0]);
    }

    public LootGenCommand(String ... parents) {
        super(parents);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        String building = actionMenuState.getStringForArgument("building");
        boolean paste = actionMenuState.getBooleanValueForArgument("paste", false);
        int level = actionMenuState.getIntValueForArgument("level", 0);
        if (LootGenCommand.isPlayerOpped(sender)) {
            server.func_152344_a(() -> {
                Item item = Item.func_111206_d((String)("minecolonies:" + building));
                NBTTagCompound compound = new NBTTagCompound();
                StringBuilder nameString = new StringBuilder();
                if (paste) {
                    compound.func_74757_a("isPasteable", true);
                    nameString.append("Insta ");
                }
                nameString.append(building.replace("blockHut", ""));
                if (level > 0) {
                    nameString.append(" Level: ").append(level);
                    compound.func_74768_a("otherLevel", level);
                }
                NBTTagCompound nameCompound = new NBTTagCompound();
                nameCompound.func_74778_a("Name", nameString.toString());
                compound.func_74782_a("display", (NBTBase)nameCompound);
                if (sender instanceof EntityPlayerMP && item != null) {
                    ItemStack stack = new ItemStack(item, 1);
                    stack.func_77982_d(compound);
                    ((EntityPlayerMP)sender).field_71071_by.func_70441_a(stack);
                }
            });
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_PERMISSION_MESSAGE));
        }
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

