/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.placementhandlers.IPlacementHandler;
import com.ldtteam.structurize.placementhandlers.PlacementHandlers;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.StructurePlacementUtils;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.interactionhandling.TranslationTextComponent;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.compatibility.candb.ChiselAndBitsCheck;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.util.StructureIterator;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Mirror;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIStructure<J extends AbstractJobStructure>
extends AbstractEntityAIInteract<J> {
    public static final String WAYPOINT_STRING = "infrastructure";
    private static final double XP_EACH_BUILDING = 10.0;
    private static final double XP_EACH_BLOCK = 0.1;
    private static final int PROGRESS_MULTIPLIER = 10;
    private static final double RUN_AWAY_SPEED = 4.1;
    private static final int MIN_ADDITIONAL_RANGE_TO_BUILD = 3;
    private static final int UNLIMITED_RESOURCES_TIMEOUT = 5;
    private static final int STANDARD_WORKING_RANGE = 5;
    private static final int MIN_WORKING_RANGE = 12;
    protected StructureIterator currentStructure;
    protected BlockPos workFrom;
    private int rotation = 0;

    protected AbstractEntityAIStructure(@NotNull J job) {
        super(job);
        this.registerTargets(new AITarget((IAIState)AIWorkerState.PICK_UP_RESIDUALS, this::pickUpResiduals, 20), new AIEventTarget(AIBlockingEventType.STATE_BLOCKING, this::checkIfCanceled, AIWorkerState.IDLE, 1), new AITarget((IAIState)AIWorkerState.START_BUILDING, this::startBuilding, 1), new AITarget(AIWorkerState.IDLE, this::isThereAStructureToBuild, () -> AIWorkerState.START_BUILDING, 100), new AITarget((IAIState)AIWorkerState.REMOVE_STEP, this.generateStructureGenerator(this::clearStep, AIWorkerState.COMPLETE_BUILD), 5), new AITarget((IAIState)AIWorkerState.CLEAR_STEP, this.generateStructureGenerator(this::clearStep, AIWorkerState.BUILDING_STEP), 5), new AITarget((IAIState)AIWorkerState.BUILDING_STEP, this.generateStructureGenerator(this::structureStep, AIWorkerState.SPAWN_STEP), 5), new AITarget((IAIState)AIWorkerState.SPAWN_STEP, this.generateStructureGenerator(this::spawnEntity, AIWorkerState.DECORATION_STEP), 5), new AITarget((IAIState)AIWorkerState.DECORATION_STEP, this.generateStructureGenerator(this::decorationStep, AIWorkerState.COMPLETE_BUILD), 5), new AITarget((IAIState)AIWorkerState.COMPLETE_BUILD, this::completeBuild, 5));
    }

    @Override
    public Class getExpectedBuildingClass() {
        return AbstractBuildingStructureBuilder.class;
    }

    private Supplier<IAIState> generateStructureGenerator(@NotNull Function<StructureIterator.StructureBlock, Boolean> evaluationFunction, @NotNull IAIState nextState) {
        Supplier<StructureIterator.StructureBlock> getCurrentBlock = () -> this.currentStructure.getCurrentBlock();
        Supplier<StructureIterator.Result> advanceBlock = () -> this.currentStructure.advanceBlock();
        return () -> {
            StructureIterator.StructureBlock currentBlock = (StructureIterator.StructureBlock)getCurrentBlock.get();
            if (currentBlock.block == null || ((Boolean)evaluationFunction.apply(currentBlock)).booleanValue()) {
                StructureIterator.Result result = (StructureIterator.Result)((Object)((Object)advanceBlock.get()));
                this.storeProgressPos(this.currentStructure.getLocalBlockPosition(), this.currentStructure.getStage());
                if (result == StructureIterator.Result.AT_END) {
                    return this.switchStage(nextState);
                }
                if (result == StructureIterator.Result.CONFIG_LIMIT) {
                    return this.getState();
                }
            }
            return this.getState();
        };
    }

    public void storeProgressPos(BlockPos blockPos, StructureIterator.Stage stage) {
    }

    @Nullable
    public Tuple<BlockPos, StructureIterator.Stage> getProgressPos() {
        return null;
    }

    public IAIState switchStage(IAIState state) {
        if (state.equals(AIWorkerState.REMOVE_STEP)) {
            this.currentStructure.setStage(StructureIterator.Stage.REMOVE);
        } else if (state.equals(AIWorkerState.BUILDING_STEP)) {
            this.currentStructure.setStage(StructureIterator.Stage.BUILD);
        } else if (state.equals(AIWorkerState.DECORATION_STEP)) {
            this.currentStructure.setStage(StructureIterator.Stage.DECORATE);
        } else if (state.equals(AIWorkerState.SPAWN_STEP)) {
            this.currentStructure.setStage(StructureIterator.Stage.SPAWN);
        } else if (state.equals(AIWorkerState.COMPLETE_BUILD)) {
            this.currentStructure.setStage(StructureIterator.Stage.COMPLETE);
        }
        return state;
    }

    private IAIState pickUpResiduals() {
        if (this.currentStructure.getStage() != StructureIterator.Stage.COMPLETE) {
            return AIWorkerState.IDLE;
        }
        if (this.getItemsForPickUp() == null) {
            this.fillItemsList();
        }
        if (this.getItemsForPickUp() != null && !this.getItemsForPickUp().isEmpty()) {
            this.gatherItems();
            return this.getState();
        }
        this.resetGatheringItems();
        this.workFrom = null;
        this.currentStructure = null;
        return AIWorkerState.IDLE;
    }

    @Override
    public void fillItemsList() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.gathering", new Object[0])});
        if (this.currentStructure == null) {
            return;
        }
        BlockPos centerPos = this.currentStructure.getCenter();
        if (centerPos.func_177956_o() == 0) {
            return;
        }
        this.searchForItems(new AxisAlignedBB(centerPos).func_72321_a((double)this.currentStructure.getLength() / 2.0, (double)this.currentStructure.getHeight(), (double)this.currentStructure.getWidth()));
    }

    private IAIState completeBuild() {
        this.storeProgressPos(null, StructureIterator.Stage.CLEAR);
        this.incrementActionsDoneAndDecSaturation();
        if (this.job instanceof AbstractJobStructure) {
            this.executeSpecificCompleteActions();
            this.worker.getCitizenExperienceHandler().addExperience(10.0);
        }
        return AIWorkerState.PICK_UP_RESIDUALS;
    }

    protected abstract void executeSpecificCompleteActions();

    private Boolean decorationStep(StructureIterator.StructureBlock structureBlock) {
        this.checkForExtraBuildingActions();
        if (!BlockUtils.shouldNeverBeMessedWith(structureBlock.worldBlock)) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.decorating", new Object[0])});
            if (!this.walkToConstructionSite(this.currentStructure.getCurrentBlockPosition())) {
                return false;
            }
            if (structureBlock.block == null || structureBlock.doesStructureBlockEqualWorldBlock() || structureBlock.metadata.func_185904_a().func_76220_a()) {
                return true;
            }
            WorkerUtil.faceBlock(structureBlock.blockPosition, this.worker);
            Block block = structureBlock.block;
            if (block == null) {
                BlockPos local = structureBlock.blockPosition;
                Log.getLogger().error(String.format("StructureProxy has null block at %s - local(%s)", this.currentStructure.getCurrentBlockPosition(), local));
                return true;
            }
            IBlockState blockState = structureBlock.metadata;
            return this.placeBlockAt(blockState, structureBlock.blockPosition);
        }
        return true;
    }

    public boolean walkToConstructionSite(BlockPos currentBlock) {
        if (this.workFrom == null) {
            this.workFrom = this.getWorkingPosition(currentBlock);
        }
        return this.worker.isWorkerAtSiteWithMove(this.workFrom, 5) || MathUtils.twoDimDistance(this.worker.func_180425_c(), this.workFrom) < 12.0;
    }

    private void handleBuildingOverBlock(@NotNull BlockPos pos) {
        List<ItemStack> items = BlockPosUtil.getBlockDrops(this.world, pos, 0);
        for (ItemStack item : items) {
            InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(item, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
        }
    }

    private boolean placeBlockAt(@NotNull IBlockState blockState, @NotNull BlockPos coords) {
        ItemStack item;
        if (blockState.func_177230_c() instanceof BlockGrassPath) {
            this.holdEfficientTool(blockState.func_177230_c(), coords);
        }
        this.worker.func_184201_a(EntityEquipmentSlot.MAINHAND, (item = BlockUtils.getItemStackFromBlockState(blockState)) == null ? ItemStackUtils.EMPTY : item);
        for (IPlacementHandler handlers : PlacementHandlers.handlers) {
            int slot;
            Object result;
            IBlockState worldState;
            if (!handlers.canHandle(this.world, coords, blockState)) continue;
            if (!Configurations.gameplay.builderInfiniteResources) {
                List requiredItems = handlers.getRequiredItems(this.world, coords, blockState, ((AbstractJobStructure)this.job).getStructure().getTileEntityData(((AbstractJobStructure)this.job).getStructure().getLocalPosition()), false);
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                for (ItemStack stack : requiredItems) {
                    itemList.add(this.getTotalAmount(stack));
                }
                if (AbstractEntityAIStructure.checkForListInInvAndRequest(this, itemList, itemList.size() > 1)) {
                    return false;
                }
            }
            if (!((worldState = this.world.func_180495_p(coords)).func_185904_a() == Material.field_151579_a || worldState.func_177230_c() instanceof BlockDoublePlant && ((BlockDoublePlant.EnumBlockHalf)worldState.func_177229_b((IProperty)BlockDoublePlant.field_176492_b)).equals((Object)BlockDoublePlant.EnumBlockHalf.UPPER))) {
                this.handleBuildingOverBlock(coords);
                this.world.func_175698_g(coords);
            }
            if ((result = handlers.handle(this.world, coords, blockState, ((AbstractJobStructure)this.job).getStructure().getTileEntityData(((AbstractJobStructure)this.job).getStructure().getLocalPosition()), false, ((AbstractJobStructure)this.job).getStructure().getPosition(), ((AbstractJobStructure)this.job).getStructure().getSettings())) instanceof IPlacementHandler.ActionProcessingResult) {
                if (result == IPlacementHandler.ActionProcessingResult.ACCEPT) {
                    return true;
                }
                if (result != IPlacementHandler.ActionProcessingResult.DENY) continue;
                return false;
            }
            if (result instanceof IBlockState) {
                IBlockState decrease = (IBlockState)result;
                this.decreaseInventory(coords, decrease.func_177230_c(), decrease);
                this.connectBlockToBuildingIfNecessary(decrease, coords);
                this.worker.func_184609_a(this.worker.func_184600_cs());
                this.worker.getCitizenExperienceHandler().addExperience(0.1);
                this.worker.decreaseSaturationForContinuousAction();
                return true;
            }
            if (!(result instanceof ItemStack) || (slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), s -> s.func_77969_a((ItemStack)result))) == -1) continue;
            ItemStack itemStack = this.worker.getInventoryCitizen().func_70301_a(slot);
            this.worker.getInventoryCitizen().func_70301_a(slot);
            this.worker.func_184201_a(EntityEquipmentSlot.MAINHAND, itemStack);
            itemStack.func_77972_a(1, (EntityLivingBase)this.worker);
        }
        Log.getLogger().warn("Couldn't handle block: " + blockState.func_177230_c().func_149739_a());
        return true;
    }

    public static boolean checkForListInInvAndRequest(@NotNull AbstractEntityAIStructure<?> placer, List<ItemStack> itemList, boolean force) {
        List<ItemStack> foundStacks = InventoryUtils.filterItemHandler((IItemHandler)new InvWrapper((IInventory)placer.getWorker().getInventoryCitizen()), itemStack -> itemList.stream().anyMatch(targetStack -> targetStack.func_77969_a(itemStack)));
        if (force) {
            for (ItemStack foundStack : new ArrayList<ItemStack>(foundStacks)) {
                Optional<ItemStack> opt = itemList.stream().filter(targetStack -> targetStack.func_77969_a(foundStack)).findFirst();
                if (!opt.isPresent()) continue;
                ItemStack stack = opt.get();
                itemList.remove(stack);
                if (stack.func_190916_E() <= foundStack.func_190916_E()) continue;
                stack.func_190920_e(stack.func_190916_E() - foundStack.func_190916_E());
                itemList.add(stack);
            }
        } else {
            itemList.removeIf(itemStack -> ItemStackUtils.isEmpty(itemStack) != false || foundStacks.stream().anyMatch(target -> target.func_77969_a(itemStack)));
        }
        itemList.removeIf(itemstack -> itemstack.func_77973_b() instanceof ItemBlock && AbstractEntityAIStructure.isBlockFree(((ItemBlock)itemstack.func_77973_b()).func_179223_d(), itemstack.func_77960_j()));
        HashMap<ItemStorage, Integer> list = new HashMap<ItemStorage, Integer>();
        for (ItemStack stack : itemList) {
            ItemStorage tempStorage = new ItemStorage(stack.func_77946_l());
            if (list.containsKey(tempStorage)) {
                int oldSize = (Integer)list.get(tempStorage);
                tempStorage.setAmount(tempStorage.getAmount() + oldSize);
            }
            list.put(tempStorage, tempStorage.getAmount());
        }
        Iterator<Object> iterator = list.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry placedStack = (Map.Entry)iterator.next();
            if (ItemStackUtils.isEmpty(((ItemStorage)placedStack.getKey()).getItemStack()).booleanValue()) {
                return true;
            }
            if (((AbstractBuilding)placer.getOwnBuilding()).getOpenRequestsOfTypeFiltered(placer.getWorker().getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(((ItemStorage)placedStack.getKey()).getItemStack())).isEmpty()) {
                Stack stackRequest = new Stack(((ItemStorage)placedStack.getKey()).getItemStack());
                stackRequest.setCount((Integer)placedStack.getValue());
                placer.getWorker().getCitizenData().createRequest(stackRequest);
                placer.registerBlockAsNeeded(((ItemStorage)placedStack.getKey()).getItemStack());
                return true;
            }
            return true;
        }
        return false;
    }

    public void registerBlockAsNeeded(ItemStack stack) {
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        int length = this.currentStructure.getLength();
        int width = this.currentStructure.getWidth();
        int distance = Math.max(width, length) + 3;
        return this.getWorkingPosition(distance, targetPosition, 0);
    }

    private boolean decreaseInventory(@NotNull BlockPos pos, Block block, @NotNull IBlockState state) {
        Block blockToPlace;
        IBlockState stateToPlace = state;
        if (MathHelper.func_76128_c((double)this.worker.getPosX()) == pos.func_177958_n() && MathHelper.func_76130_a((int)(pos.func_177956_o() - (int)this.worker.getPosY())) <= 1 && MathHelper.func_76128_c((double)this.worker.getPosZ()) == pos.func_177952_p() && this.worker.getNavigator().func_75500_f()) {
            this.worker.getNavigator().moveAwayFromXYZ(pos, 4.1, 1.0);
        }
        if (AbstractEntityAIStructure.isBlockFree(blockToPlace = block, blockToPlace.func_176201_c(stateToPlace))) {
            return true;
        }
        ItemStack stack = BlockUtils.getItemStackFromBlockState(stateToPlace);
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            Log.getLogger().error("Block causes NPE: " + stateToPlace.func_177230_c());
            return false;
        }
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        if (!ChiselAndBitsCheck.isChiselAndBitsBlock(stateToPlace)) {
            itemList.add(stack);
        }
        itemList.addAll(this.getItemsFromTileEntity());
        for (ItemStack tempStack : itemList) {
            int slot;
            if (ItemStackUtils.isEmpty(tempStack).booleanValue() || (slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(tempStack.func_77973_b(), tempStack.func_77952_i())) == -1) continue;
            ItemStack container = tempStack.func_77973_b().getContainerItem(tempStack);
            new InvWrapper((IInventory)this.getInventory()).extractItem(slot, tempStack.func_190916_E(), false);
            if (!ItemStackUtils.isEmpty(container).booleanValue()) {
                new InvWrapper((IInventory)this.getInventory()).insertItem(slot, container, false);
            }
            this.reduceNeededResources(tempStack);
        }
        if (Configurations.gameplay.builderBuildBlockDelay > 0 && blockToPlace != Blocks.field_150350_a) {
            this.setDelay(Configurations.gameplay.builderBuildBlockDelay * 10 / (this.worker.getCitizenExperienceHandler().getLevel() + 10));
        }
        return true;
    }

    public void connectBlockToBuildingIfNecessary(@NotNull IBlockState blockState, @NotNull BlockPos pos) {
    }

    public static boolean isBlockFree(@Nullable Block block, int metadata) {
        return block == null || BlockUtils.isWater(block.func_176223_P()) || block.equals(Blocks.field_150362_t) || block.equals(Blocks.field_150361_u) || block.equals(Blocks.field_150398_cm) && Utils.testFlag(metadata, 8) || block == ModBlocks.blockDecorationPlaceholder;
    }

    public List<ItemStack> getItemsFromTileEntity() {
        return Collections.emptyList();
    }

    public void reduceNeededResources(ItemStack stack) {
    }

    public void checkForExtraBuildingActions() {
    }

    private Boolean structureStep(StructureIterator.StructureBlock structureBlock) {
        this.checkForExtraBuildingActions();
        if (!BlockUtils.shouldNeverBeMessedWith(structureBlock.worldBlock)) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.building", new Object[0])});
            if (!this.walkToConstructionSite(this.currentStructure.getCurrentBlockPosition())) {
                return false;
            }
            if (structureBlock.block == null || !structureBlock.metadata.func_185904_a().func_76220_a() && structureBlock.block != Blocks.field_150350_a) {
                return true;
            }
            if (structureBlock.doesStructureBlockEqualWorldBlock()) {
                this.connectBlockToBuildingIfNecessary(structureBlock.metadata, structureBlock.blockPosition);
                return true;
            }
            Block block = structureBlock.block;
            IBlockState blockState = structureBlock.metadata;
            if (block == com.ldtteam.structurize.blocks.ModBlocks.blockSolidSubstitution || this.shallReplaceSolidSubstitutionBlock(structureBlock.worldBlock, structureBlock.worldMetadata)) {
                blockState = this.getSolidSubstitution(structureBlock.blockPosition);
                block = blockState.func_177230_c();
            }
            WorkerUtil.faceBlock(structureBlock.blockPosition, this.worker);
            if (block == null) {
                BlockPos local = structureBlock.blockPosition;
                Log.getLogger().error(String.format("StructureProxy has null block at %s - local(%s)", this.currentStructure.getCurrentBlockPosition(), local));
                return true;
            }
            return this.placeBlockAt(blockState, structureBlock.blockPosition);
        }
        return true;
    }

    public abstract boolean shallReplaceSolidSubstitutionBlock(Block var1, IBlockState var2);

    public abstract IBlockState getSolidSubstitution(BlockPos var1);

    public void loadStructure(@NotNull String name, int rotateTimes, BlockPos position, boolean isMirrored, boolean removal) {
        this.rotation = rotateTimes;
        try {
            Structure structure = new Structure(this.world, name, new PlacementSettings());
            ((AbstractJobStructure)this.job).setStructure(structure);
            this.currentStructure = new StructureIterator(this.world, structure, removal ? StructureIterator.Stage.REMOVE : StructureIterator.Stage.CLEAR);
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn(String.format("StructureProxy: (%s) does not exist - removing build request", name), (Throwable)e);
            ((AbstractJobStructure)this.job).setStructure(null);
        }
        try {
            ((AbstractJobStructure)this.job).getStructure().rotate(BlockPosUtil.getRotationFromRotations(rotateTimes), this.world, position, isMirrored ? Mirror.FRONT_BACK : Mirror.NONE);
            ((AbstractJobStructure)this.job).getStructure().setPosition(position);
            ((AbstractJobStructure)this.job).getStructure().setPlacementSettings(new PlacementSettings(isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, BlockPosUtil.getRotationFromRotations(rotateTimes)));
        }
        catch (NullPointerException ex) {
            this.handleSpecificCancelActions();
            ((AbstractJobStructure)this.job).setStructure(null);
            Log.getLogger().warn("StructureIterator couldn't be found which caused an NPE, removed workOrder, more details in log", (Throwable)ex);
        }
        if (this.getProgressPos() != null) {
            this.currentStructure.setStage((StructureIterator.Stage)((Object)this.getProgressPos().func_76340_b()));
        }
    }

    public void handleSpecificCancelActions() {
    }

    protected abstract boolean checkIfCanceled();

    private boolean clearStep(@NotNull StructureIterator.StructureBlock currentBlock) {
        this.checkForExtraBuildingActions();
        if (this.isAlreadyCleared() || !this.currentStructure.getStage().equals((Object)StructureIterator.Stage.CLEAR) && !this.currentStructure.getStage().equals((Object)StructureIterator.Stage.REMOVE)) {
            return true;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.clearing", new Object[0])});
        if (!BlockUtils.shouldNeverBeMessedWith(currentBlock.worldBlock) && currentBlock.worldBlock != Blocks.field_150478_aa) {
            if (!this.walkToConstructionSite(this.currentStructure.getCurrentBlockPosition())) {
                return false;
            }
            if (StructurePlacementUtils.isStructureBlockEqualWorldBlock((World)this.world, (BlockPos)currentBlock.blockPosition, (IBlockState)((AbstractJobStructure)this.job).getStructure().getBlockstate()) || currentBlock.block instanceof BlockBed && ((BlockBed.EnumPartType)currentBlock.metadata.func_177229_b((IProperty)BlockBed.field_176472_a)).equals((Object)BlockBed.EnumPartType.FOOT) || currentBlock.block instanceof BlockDoor && ((BlockDoor.EnumDoorHalf)currentBlock.metadata.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.UPPER)) {
                return true;
            }
            WorkerUtil.faceBlock(currentBlock.blockPosition, this.worker);
            if (Configurations.gameplay.builderInfiniteResources || currentBlock.worldMetadata.func_185904_a().func_76224_d()) {
                this.worker.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStackUtils.EMPTY);
                this.world.func_175698_g(currentBlock.blockPosition);
                this.world.func_175656_a(currentBlock.blockPosition, Blocks.field_150350_a.func_176223_P());
                this.worker.func_184609_a(this.worker.func_184600_cs());
                this.setDelay(50 / (this.worker.getCitizenExperienceHandler().getLevel() + 10));
            } else {
                if (!this.mineBlock(currentBlock.blockPosition, this.getCurrentWorkingPosition())) {
                    return false;
                }
                this.worker.decreaseSaturationForContinuousAction();
            }
        }
        return true;
    }

    protected boolean isAlreadyCleared() {
        return false;
    }

    private BlockPos getCurrentWorkingPosition() {
        return this.workFrom == null ? this.getWorkingPosition(this.currentStructure.getCurrentBlockPosition()) : this.workFrom;
    }

    protected boolean isThereAStructureToBuild() {
        if (this.currentStructure == null) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.waitingForBuild", new Object[0])});
        }
        return this.currentStructure != null;
    }

    @NotNull
    private IAIState startBuilding() {
        if (this.currentStructure == null) {
            this.onStartWithoutStructure();
            return AIWorkerState.IDLE;
        }
        switch (this.currentStructure.getStage()) {
            case REMOVE: {
                return AIWorkerState.REMOVE_STEP;
            }
            case CLEAR: {
                return AIWorkerState.CLEAR_STEP;
            }
            case BUILD: {
                return AIWorkerState.BUILDING_STEP;
            }
            case DECORATE: {
                return AIWorkerState.DECORATION_STEP;
            }
            case SPAWN: {
                return AIWorkerState.SPAWN_STEP;
            }
        }
        return AIWorkerState.COMPLETE_BUILD;
    }

    protected abstract void onStartWithoutStructure();

    @Nullable
    public ItemStack getTotalAmount(@Nullable ItemStack stack) {
        return stack;
    }

    public void resetCurrentStructure() {
        this.workFrom = null;
        this.currentStructure = null;
    }

    private Boolean spawnEntity(@NotNull StructureIterator.StructureBlock currentBlock) {
        NBTTagCompound[] entityInfos = currentBlock.entity;
        if (entityInfos.length == 0) {
            return true;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.spawning", new Object[0])});
        for (NBTTagCompound entityInfo : entityInfos) {
            if (entityInfo == null) continue;
            Entity entity = ItemStackUtils.getEntityFromEntityInfoOrNull(entityInfo, this.world);
            BlockPos pos = this.currentStructure.getPos();
            if (entity == null) continue;
            Vec3d worldPos = entity.func_174791_d().func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            entity.func_70012_b(worldPos.field_72450_a, worldPos.field_72448_b, worldPos.field_72449_c, entity.field_70177_z, entity.field_70125_A);
            if (EntityUtils.isEntityAtPosition(entity, this.world, this.worker)) continue;
            ArrayList<ItemStack> request = new ArrayList<ItemStack>();
            if (entity instanceof EntityItemFrame) {
                ItemStack stack = ((EntityItemFrame)entity).func_82335_i();
                if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
                    ItemStackUtils.setSize(stack, 1);
                    request.add(stack);
                }
                request.add(new ItemStack(Items.field_151160_bD, 1));
            } else if (entity instanceof EntityArmorStand) {
                request.add(entity.getPickedResult(new RayTraceResult((Entity)this.worker)));
                entity.func_184193_aE().forEach(request::add);
                entity.func_184214_aD().forEach(request::add);
            } else {
                request.add(entity.getPickedResult(new RayTraceResult((Entity)this.worker)));
            }
            request.removeIf(ItemStackUtils::isEmpty);
            if (!Configurations.gameplay.builderInfiniteResources) {
                if (AbstractEntityAIStructure.checkForListInInvAndRequest(this, new ArrayList<ItemStack>(request), true)) {
                    return false;
                }
                for (ItemStack stack : request) {
                    int slot;
                    if (ItemStackUtils.isEmpty(stack).booleanValue() || (slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(stack.func_77973_b(), stack.func_77952_i())) == -1) continue;
                    new InvWrapper((IInventory)this.getInventory()).extractItem(slot, 1, false);
                    this.reduceNeededResources(stack);
                }
            }
            entity.func_184221_a(UUID.randomUUID());
            if (this.world.func_72838_d(entity)) continue;
            Log.getLogger().info("Failed to spawn entity");
        }
        return true;
    }

    public AbstractEntityCitizen getWorker() {
        return this.worker;
    }

    public int getRotation() {
        return this.rotation;
    }
}

