/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.inventory;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerMinecoloniesBuildingInventory
extends Container {
    private final IItemHandlerModifiable lowerChestInventory;
    private final IInventory playerInventory;
    private final int inventorySize;
    private final IColony colony;

    public ContainerMinecoloniesBuildingInventory(IInventory playerInventory, IItemHandlerModifiable inventory, final int colonyId, final BlockPos buildingId, final World world) {
        int i;
        this.colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, buildingId);
        this.lowerChestInventory = inventory;
        this.inventorySize = inventory.getSlots() / 9;
        int size = inventory.getSlots();
        int columns = this.inventorySize <= 8 ? 9 : size / 8 + 1;
        int extraOffset = this.inventorySize <= 8 ? 0 : 2;
        int index = 0;
        for (int j = 0; j < Math.min(this.inventorySize, 8); ++j) {
            for (int k = 0; k < columns; ++k) {
                if (index >= size) continue;
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, index, 8 + k * 18, 18 + j * 18){

                    public void func_75215_d(ItemStack stack) {
                        IColony colony;
                        IBuilding building;
                        super.func_75215_d(stack);
                        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && !ItemStackUtils.isEmpty(stack).booleanValue() && (building = (colony = IColonyManager.getInstance().getColonyByWorld(colonyId, world)).getBuildingManager().getBuilding(buildingId)) != null) {
                            building.overruleNextOpenRequestWithStack(stack);
                        }
                    }
                });
                ++index;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot(playerInventory, j + i * 9 + 9, 8 + j * 18, 30 + extraOffset + 18 * Math.min(this.inventorySize, 8) + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot(playerInventory, i, 8 + i * 18, 88 + extraOffset + 18 * Math.min(this.inventorySize, 8)));
        }
        this.playerInventory = playerInventory;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStackUtils.EMPTY;
        }
        ItemStack stackCopy = slot.func_75211_c().func_77946_l();
        int maxIndex = this.inventorySize * 9;
        if (index < maxIndex ? !this.func_75135_a(stackCopy, maxIndex, this.field_75151_b.size(), true) : !this.func_75135_a(stackCopy, 0, maxIndex, false)) {
            return ItemStackUtils.EMPTY;
        }
        if (ItemStackUtils.getSize(stackCopy) == 0) {
            slot.func_75215_d(ItemStackUtils.EMPTY);
        } else {
            slot.func_75215_d(stackCopy);
        }
        return stackCopy;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
    }

    public boolean func_75145_c(@NotNull EntityPlayer playerIn) {
        return this.colony.getPermissions().hasPermission(playerIn, Action.ACCESS_HUTS);
    }

    public IItemHandlerModifiable getLowerChestInventory() {
        return this.lowerChestInventory;
    }

    public IInventory getPlayerInventory() {
        return this.playerInventory;
    }
}

