/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.client.gui.WindowBuildTool;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InstantStructurePlacer;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.workerbuildings.PostBox;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.event.EventHandler;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.ColonyUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.stats.StatList;
import net.minecraft.util.Mirror;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class BuildToolPasteMessage
extends AbstractMessage<BuildToolPasteMessage, IMessage> {
    private static final int SUPPLY_SHIP_CHEST_HEIGHT = 6;
    private IBlockState state;
    private boolean complete;
    private String structureName;
    private String workOrderName;
    private int rotation;
    private BlockPos pos;
    private boolean isHut;
    private boolean mirror;
    private WindowBuildTool.FreeMode freeMode;
    @GameRegistry.ItemStackHolder(value="gbook:guidebook", nbt="{Book:\"minecolonies:book/minecolonies.xml\"}")
    public static ItemStack guideBook;

    public BuildToolPasteMessage() {
    }

    public BuildToolPasteMessage(String structureName, String workOrderName, BlockPos pos, int rotation, boolean isHut, Mirror mirror, boolean complete, WindowBuildTool.FreeMode freeMode, IBlockState state) {
        this.structureName = structureName;
        this.workOrderName = workOrderName;
        this.pos = pos;
        this.rotation = rotation;
        this.isHut = isHut;
        this.mirror = mirror == Mirror.FRONT_BACK;
        this.complete = complete;
        this.freeMode = freeMode;
        this.state = state;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.structureName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.workOrderName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readInt();
        this.isHut = buf.readBoolean();
        this.mirror = buf.readBoolean();
        this.complete = buf.readBoolean();
        int modeId = buf.readInt();
        if (modeId >= 0) {
            this.freeMode = WindowBuildTool.FreeMode.values()[modeId];
        }
        this.state = NBTUtil.func_190008_d((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.structureName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.workOrderName);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isHut);
        buf.writeBoolean(this.mirror);
        buf.writeBoolean(this.complete);
        if (this.freeMode == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.freeMode.ordinal());
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.state));
    }

    @Override
    public void messageOnServerThread(BuildToolPasteMessage message, EntityPlayerMP player) {
        StructureName sn = new StructureName(message.structureName);
        if (!Structures.hasMD5((StructureName)sn)) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can not build " + message.workOrderName + ": schematic missing!"));
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            IBuilding building;
            if (message.isHut) {
                BuildToolPasteMessage.handleHut(CompatibilityUtils.getWorldFromEntity((Entity)player), (EntityPlayer)player, sn, message.rotation, message.pos, message.mirror, message.state);
            }
            InstantStructurePlacer.loadAndPlaceStructureWithRotation(player.field_70170_p, message.structureName, message.pos, message.rotation, message.mirror ? Mirror.FRONT_BACK : Mirror.NONE, message.complete);
            if (message.isHut && (building = IColonyManager.getInstance().getBuilding(CompatibilityUtils.getWorldFromEntity((Entity)player), message.pos)) != null) {
                building.onUpgradeComplete(building.getBuildingLevel());
                WorkOrderBuildBuilding workOrder = new WorkOrderBuildBuilding(building, 1);
                ConstructionTapeHelper.removeConstructionTape(workOrder, CompatibilityUtils.getWorldFromEntity((Entity)player));
            }
        } else if (message.freeMode != null) {
            int chestHeight;
            if (player.func_147099_x().func_77444_a(StatList.func_188057_b((Item)ModItems.supplyChest)) > 0 && !Configurations.gameplay.allowInfiniteSupplyChests) {
                LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.error.supplyChestAlreadyPlaced", new Object[0]);
                return;
            }
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (message.freeMode == WindowBuildTool.FreeMode.SUPPLYSHIP) {
                stacks.add(new ItemStack(ModItems.supplyChest));
                chestHeight = 6;
            } else if (message.freeMode == WindowBuildTool.FreeMode.SUPPLYCAMP) {
                stacks.add(new ItemStack(ModItems.supplyCamp));
                chestHeight = 1;
            } else {
                chestHeight = 0;
            }
            LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.progress.supplies_placed", new Object[0]);
            player.func_71029_a(StatList.func_188057_b((Item)ModItems.supplyChest));
            AdvancementTriggers.PLACE_SUPPLY.trigger(player);
            if (InventoryUtils.removeStacksFromItemHandler((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), stacks)) {
                InstantStructurePlacer.loadAndPlaceStructureWithRotation(player.field_70170_p, message.structureName, message.pos, message.rotation, message.mirror ? Mirror.FRONT_BACK : Mirror.NONE, message.complete);
                player.func_71121_q().func_175656_a(message.pos.func_177981_b(chestHeight), Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)player.func_174811_aO()));
            } else {
                LanguageHandler.sendPlayerMessage((EntityPlayer)player, "item.supplyChestDeployer.missing", new Object[0]);
            }
        }
    }

    private static void handleHut(@NotNull World world, @NotNull EntityPlayer player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror, IBlockState state) {
        IColony tempColony = IColonyManager.getInstance().getClosestColony(world, buildPos);
        if (tempColony != null && !tempColony.getPermissions().hasPermission(player, Action.MANAGE_HUTS) && !IColonyManager.getInstance().isTooCloseToColony(world, buildPos)) {
            return;
        }
        String hut = sn.getSection();
        Block block = Block.func_149684_b((String)("minecolonies:blockHut" + hut));
        if (block != null && EventHandler.onBlockHutPlaced(world, player, block, buildPos)) {
            world.func_175655_b(buildPos, true);
            world.func_175656_a(buildPos, state.func_185907_a(BlockPosUtil.getRotationFromRotations(rotation)));
            ((AbstractBlockHut)block).onBlockPlacedByBuildTool(world, buildPos, world.func_180495_p(buildPos), (EntityLivingBase)player, null, mirror, sn.getStyle());
            BuildToolPasteMessage.setupBuilding(world, player, sn, rotation, buildPos, mirror);
        }
    }

    private static void setupBuilding(@NotNull World world, @NotNull EntityPlayer player, StructureName sn, int rotation, @NotNull BlockPos buildPos, boolean mirror) {
        IBuilding building = IColonyManager.getInstance().getBuilding(world, buildPos);
        if (building == null) {
            Log.getLogger().error("BuildTool: building is null!");
        } else {
            if (building.getTileEntity() != null) {
                IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, buildPos);
                if (colony == null) {
                    Log.getLogger().info("No colony for " + player.func_70005_c_());
                } else {
                    building.getTileEntity().setColony(colony);
                }
            }
            String name = sn.toString();
            name = name.substring(name.length() - 1);
            try {
                int level = Integer.parseInt(name);
                building.setBuildingLevel(level);
            }
            catch (NumberFormatException e) {
                Log.getLogger().warn("Couldn't parse the level.", (Throwable)e);
            }
            building.setStyle(sn.getStyle());
            building.setRotation(rotation);
            if (!(building instanceof PostBox)) {
                ConstructionTapeHelper.removeConstructionTape(building.getCorners(), world);
                WorkOrderBuildBuilding workOrder = new WorkOrderBuildBuilding(building, 1);
                Structure wrapper = new Structure(world, workOrder.getStructureName(), new PlacementSettings());
                Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(building.getPosition(), world, wrapper, workOrder.getRotation(world), workOrder.isMirrored());
                building.setCorners((Integer)((Tuple)corners.func_76341_a()).func_76341_a(), (Integer)((Tuple)corners.func_76341_a()).func_76340_b(), (Integer)((Tuple)corners.func_76340_b()).func_76341_a(), (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
                building.setHeight(wrapper.getHeight());
            }
            if (mirror) {
                building.invertMirror();
            }
        }
    }
}

