/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.controlpanel;

import blusunrize.immersiveengineering.api.IEProperties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.BlockIWBase;
import malte0811.industrialwires.blocks.IMetaEnum;
import malte0811.industrialwires.blocks.controlpanel.BlockTypes_Panel;
import malte0811.industrialwires.blocks.controlpanel.ItemBlockPanel;
import malte0811.industrialwires.blocks.controlpanel.TileEntityComponentPanel;
import malte0811.industrialwires.blocks.controlpanel.TileEntityGeneralCP;
import malte0811.industrialwires.blocks.controlpanel.TileEntityPanel;
import malte0811.industrialwires.blocks.controlpanel.TileEntityPanelCreator;
import malte0811.industrialwires.blocks.controlpanel.TileEntityRSPanel;
import malte0811.industrialwires.blocks.controlpanel.TileEntityRSPanelIE;
import malte0811.industrialwires.blocks.controlpanel.TileEntityRSPanelOthers;
import malte0811.industrialwires.blocks.controlpanel.TileEntityUnfinishedPanel;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PropertyComponents;
import malte0811.industrialwires.util.MiscUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockPanel
extends BlockIWBase
implements IMetaEnum {
    public static final PropertyEnum<BlockTypes_Panel> type = PropertyEnum.func_177709_a((String)"type", BlockTypes_Panel.class);
    public static final String NAME = "control_panel";

    public BlockPanel() {
        super(Material.field_151573_f, NAME);
        this.field_149786_r = 0;
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockPanel(this);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        switch ((BlockTypes_Panel)((Object)state.func_177229_b(type))) {
            case TOP: 
            case SINGLE_COMP: {
                return layer == BlockRenderLayer.CUTOUT;
            }
            case RS_WIRE: {
                return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.SOLID;
            }
        }
        return super.canRenderInLayer(state, layer);
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        switch ((BlockTypes_Panel)((Object)state.func_177229_b(type))) {
            case TOP: {
                return new TileEntityPanel();
            }
            case RS_WIRE: {
                return new TileEntityRSPanelIE();
            }
            case CREATOR: {
                return new TileEntityPanelCreator();
            }
            case UNFINISHED: {
                return new TileEntityUnfinishedPanel();
            }
            case SINGLE_COMP: {
                return new TileEntityComponentPanel();
            }
            case DUMMY: {
                return new TileEntityGeneralCP();
            }
            case OTHER_RS_WIRES: {
                return new TileEntityRSPanelOthers();
            }
        }
        return null;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    protected IProperty<?>[] getProperties() {
        return new IProperty[]{IEProperties.FACING_ALL, type};
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        BlockStateContainer base = super.func_180661_e();
        return new ExtendedBlockState((Block)this, base.func_177623_d().toArray(new IProperty[0]), new IUnlistedProperty[]{PropertyComponents.INSTANCE, IEProperties.CONNECTIONS});
    }

    @Override
    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = super.func_176221_a(state, worldIn, pos);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityComponentPanel) {
            state.func_177226_a(type, (Comparable)((Object)BlockTypes_Panel.SINGLE_COMP));
        } else if (te instanceof TileEntityPanel) {
            state.func_177226_a(type, (Comparable)((Object)BlockTypes_Panel.TOP));
        } else if (te instanceof TileEntityRSPanelIE) {
            state.func_177226_a(type, (Comparable)((Object)BlockTypes_Panel.RS_WIRE));
        }
        return state;
    }

    @Override
    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        if ((state = super.getExtendedState(state, world, pos)) instanceof IExtendedBlockState && (te = world.func_175625_s(pos)) instanceof TileEntityPanel) {
            state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)PropertyComponents.INSTANCE, (Object)((TileEntityPanel)te).getComponents());
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockTypes_Panel)((Object)state.func_177229_b(type))).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a(type, (Comparable)((Object)BlockTypes_Panel.values()[meta]));
    }

    @Override
    public Object[] getValues() {
        return BlockTypes_Panel.values();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        BlockTypes_Panel[] values = BlockTypes_Panel.values();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].showInCreative()) continue;
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ) && hand == EnumHand.MAIN_HAND) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityRSPanel) {
                if (!world.field_72995_K) {
                    player.openGui((Object)IndustrialWires.instance, 0, te.func_145831_w(), te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p());
                }
                return true;
            }
            if (te instanceof TileEntityPanelCreator) {
                if (!world.field_72995_K) {
                    player.openGui((Object)IndustrialWires.instance, 0, te.func_145831_w(), te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p());
                }
                return true;
            }
            return false;
        }
        return state.func_177229_b(type) == BlockTypes_Panel.TOP || state.func_177229_b(type) == BlockTypes_Panel.SINGLE_COMP;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityPanel) {
            return ((TileEntityPanel)te).getTileDrop(player, state);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @Override
    public void func_180657_a(@Nonnull World worldIn, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (te instanceof TileEntityPanel) {
            for (PanelComponent pc : ((TileEntityPanel)te).getComponents()) {
                pc.dropItems();
            }
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return state.func_177229_b(type) == BlockTypes_Panel.SINGLE_COMP;
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return state.func_177229_b(type) == BlockTypes_Panel.SINGLE_COMP;
    }

    @Override
    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity te;
        if (blockState.func_177229_b(type) == BlockTypes_Panel.SINGLE_COMP && (te = blockAccess.func_175625_s(pos)) instanceof TileEntityComponentPanel && side == ((TileEntityComponentPanel)te).getComponents().getTop()) {
            return ((TileEntityComponentPanel)te).getRSOutput();
        }
        return 0;
    }

    @Override
    public int func_180656_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity te;
        if (state.func_177229_b(type) == BlockTypes_Panel.SINGLE_COMP && (te = blockAccess.func_175625_s(pos)) instanceof TileEntityComponentPanel) {
            return ((TileEntityComponentPanel)te).getRSOutput();
        }
        return 0;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!worldIn.field_72995_K) {
            TileEntityGeneralCP panel = MiscUtils.getLoadedTE(worldIn, pos, TileEntityGeneralCP.class);
            if (panel instanceof TileEntityComponentPanel) {
                ((TileEntityComponentPanel)panel).updateRSInput();
            } else if (panel instanceof TileEntityRSPanelOthers) {
                ((TileEntityRSPanelOthers)panel).updateInput();
            }
        }
    }
}

