/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.converter;

import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxConnection;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import malte0811.industrialwires.IWConfig;
import malte0811.industrialwires.blocks.EnergyAdapter;
import malte0811.industrialwires.blocks.TileEntityIWBase;
import malte0811.industrialwires.util.ConversionUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityIEMotor
extends TileEntityIWBase
implements ITickable,
IFluxReceiver,
IEBlockInterfaces.IDirectionalTile {
    private double rotBuffer = 0.0;
    private FluxStorage energy = new FluxStorage(20 * IWConfig.MechConversion.maxIfToMech, 2 * IWConfig.MechConversion.maxIfToMech);
    private EnumFacing dir = EnumFacing.DOWN;
    private BlockPos receiver;
    private Map<EnumFacing, IEnergyStorage> energies = new HashMap<EnumFacing, IEnergyStorage>();

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntity te;
            if (this.receiver == null) {
                this.receiver = this.field_174879_c.func_177972_a(this.dir);
            }
            int max = IWConfig.MechConversion.maxIfToMech;
            boolean dirty = false;
            if (this.rotBuffer < (double)(2 * IWConfig.MechConversion.maxIfToMech) * ConversionUtil.rotPerIf() && this.energy.extractEnergy(max, true) > 0) {
                int extracted = this.energy.extractEnergy(max, false);
                this.rotBuffer += (double)extracted * ConversionUtil.rotPerIf() * IWConfig.MechConversion.ifMotorEfficiency;
                dirty = true;
            }
            if ((te = this.field_145850_b.func_175625_s(this.receiver)) instanceof IRotationAcceptor) {
                ((IRotationAcceptor)te).inputRotation(this.rotBuffer, this.dir);
                this.rotBuffer = 0.0;
                dirty = true;
            }
            if (dirty) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public void readNBT(NBTTagCompound in, boolean updatePacket) {
        this.dir = EnumFacing.field_82609_l[in.func_74771_c("dir")];
        this.energy.readFromNBT(in.func_74775_l("energy"));
        this.receiver = null;
        this.rotBuffer = in.func_74769_h("buffer");
    }

    @Override
    public void writeNBT(NBTTagCompound out, boolean updatePacket) {
        out.func_74774_a("dir", (byte)this.dir.func_176745_a());
        NBTTagCompound nbt = new NBTTagCompound();
        this.energy.writeToNBT(nbt);
        out.func_74782_a("energy", (NBTBase)nbt);
        out.func_74780_a("buffer", this.rotBuffer);
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return from == this.dir.func_176734_d() || from == null;
    }

    public int receiveEnergy(EnumFacing from, int energyIn, boolean simulate) {
        if (this.canConnectEnergy(from)) {
            int ret = this.energy.receiveEnergy(energyIn, simulate);
            this.func_70296_d();
            return ret;
        }
        return 0;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    @Nonnull
    public EnumFacing getFacing() {
        return this.dir;
    }

    public void setFacing(@Nonnull EnumFacing facing) {
        this.dir = facing;
        this.receiver = null;
        this.func_70296_d();
    }

    public int getFacingLimitation() {
        return 1;
    }

    public boolean mirrorFacingOnPlacement(@Nonnull EntityLivingBase placer) {
        return false;
    }

    public boolean canHammerRotate(@Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EntityLivingBase entity) {
        return true;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this.canConnectEnergy(facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this.canConnectEnergy(facing)) {
            if (!this.energies.containsKey(facing)) {
                this.energies.put(facing, new EnergyAdapter((IFluxConnection)this, facing));
            }
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energies.get(facing));
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean canRotate(@Nonnull EnumFacing axis) {
        return true;
    }
}

