/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.client.manual;

import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;

public class TextSplitter {
    private final Function<String, Integer> width;
    private final TIntObjectMap<Map<Integer, Page>> specialByAnchor = new TIntObjectHashMap();
    private final TIntObjectMap<Page> specialByPage = new TIntObjectHashMap();
    private final List<List<String>> entry = new ArrayList<List<String>>();
    private final Function<String, String> tokenTransform;
    private final int lineWidth;
    private final int linesPerPage;
    private TIntIntMap pageByAnchor = new TIntIntHashMap();
    private final Function<String, IManualPage> defaultPage;

    public TextSplitter(Function<String, Integer> w, int lineWidthPixel, int linesPerPage, Function<String, IManualPage> defPage, Function<String, String> tokenTransform) {
        this.width = w;
        this.lineWidth = lineWidthPixel;
        this.linesPerPage = linesPerPage;
        this.tokenTransform = tokenTransform;
        this.defaultPage = defPage;
    }

    public TextSplitter(ManualInstance m) {
        this(arg_0 -> ((FontRenderer)m.fontRenderer).func_78256_a(arg_0), 120, 16, s -> new ManualPages.Text(m, s), s -> s);
    }

    public TextSplitter(ManualInstance m, Function<String, String> tokenTransform) {
        this(arg_0 -> ((FontRenderer)m.fontRenderer).func_78256_a(arg_0), 120, 16, s -> new ManualPages.Text(m, s), tokenTransform);
    }

    public void clearSpecialByPage() {
        this.specialByPage.clear();
    }

    public void clearSpecialByAnchor() {
        this.specialByAnchor.clear();
    }

    public void addSpecialPage(int ref, int offset, int lines, Function<String, IManualPage> factory) {
        if (offset < 0 || ref != -1 && ref < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.specialByAnchor.containsKey(ref)) {
            this.specialByAnchor.put(ref, new HashMap());
        }
        ((Map)this.specialByAnchor.get(ref)).put(offset, new Page(lines, factory));
    }

    public void split(String in) {
        this.clearSpecialByPage();
        this.entry.clear();
        String[] wordsAndSpaces = this.splitWhitespace(in);
        int pos = 0;
        ArrayList overflow = new ArrayList();
        this.updateSpecials(-1, 0, 0, -1);
        while (pos < wordsAndSpaces.length) {
            List<String> page = new ArrayList<String>(overflow);
            overflow.clear();
            block1: while (page.size() < this.getLinesOnPage(this.entry.size()) && pos < wordsAndSpaces.length) {
                String token;
                int textWidth;
                String line = "";
                int currWidth = 0;
                while (pos < wordsAndSpaces.length && currWidth < this.lineWidth && (currWidth + (textWidth = this.getWidth(token = this.tokenTransform.apply(wordsAndSpaces[pos]))) < this.lineWidth || line.length() == 0)) {
                    ++pos;
                    if (token.equals("<np>")) {
                        page.add(line);
                        break block1;
                    }
                    if (token.equals("<br>")) break;
                    if (token.startsWith("<&") && token.endsWith(">")) {
                        int id = Integer.parseInt(token.substring(2, token.length() - 1));
                        int pageForId = this.entry.size();
                        Map specialForId = (Map)this.specialByAnchor.get(id);
                        if (specialForId != null && specialForId.containsKey(0) && page.size() >= ((Page)specialForId.get((Object)Integer.valueOf((int)0))).lines) {
                            ++pageForId;
                        }
                        if (!this.updateSpecials(id, pageForId, page.size(), this.entry.size())) continue;
                        page.add(line);
                        --pos;
                        break block1;
                    }
                    if (Character.isWhitespace(token.charAt(0)) && line.length() == 0) continue;
                    line = line + token;
                    currWidth += textWidth;
                }
                if ((line = line.trim()).isEmpty()) continue;
                page.add(line);
            }
            if (page.stream().allMatch(String::isEmpty) && pos == wordsAndSpaces.length) continue;
            int linesMax = this.getLinesOnPage(this.entry.size());
            if (page.size() > linesMax) {
                overflow.addAll(page.subList(linesMax, page.size()));
                page = page.subList(0, linesMax);
            }
            this.entry.add(page);
        }
    }

    public List<IManualPage> toManualEntry() {
        ArrayList<IManualPage> ret = new ArrayList<IManualPage>(this.entry.size());
        for (int i = 0; i < this.entry.size(); ++i) {
            String s = this.entry.get(i).stream().collect(Collectors.joining("\n"));
            if (this.specialByPage.containsKey(i)) {
                ret.add(((Page)this.specialByPage.get((int)i)).factory.apply(s));
                continue;
            }
            ret.add(this.defaultPage.apply(s));
        }
        return ret;
    }

    private int getWidth(String text) {
        switch (text) {
            case "<br>": 
            case "<np>": {
                return 0;
            }
        }
        if (text.startsWith("<link;")) {
            text = text.substring(text.indexOf(59) + 1);
            text = text.substring(text.indexOf(59) + 1, text.lastIndexOf(59));
        }
        return this.width.apply(text);
    }

    private int getLinesOnPage(int id) {
        if (this.specialByPage.containsKey(id)) {
            return ((Page)this.specialByPage.get((int)id)).lines;
        }
        return this.linesPerPage;
    }

    private boolean updateSpecials(int ref, int pageRef, int currLine, int currPage) {
        if (this.specialByAnchor.containsKey(ref)) {
            TIntObjectHashMap specialByPageTmp = new TIntObjectHashMap();
            for (Map.Entry entry : ((Map)this.specialByAnchor.get(ref)).entrySet()) {
                int specialPage = pageRef + (Integer)entry.getKey();
                if (this.specialByPage.containsKey(specialPage)) {
                    return true;
                }
                if ((Integer)entry.getKey() == 0 && currPage == pageRef && ((Page)entry.getValue()).lines <= currLine) {
                    return true;
                }
                specialByPageTmp.put(specialPage, entry.getValue());
            }
            this.specialByPage.putAll((TIntObjectMap)specialByPageTmp);
        } else if (ref != -1) {
            System.out.println("WARNING: Reference " + ref + " was found, but no special pages were registered for it");
        }
        this.pageByAnchor.put(ref, pageRef);
        return false;
    }

    private String[] splitWhitespace(String in) {
        ArrayList<String> parts = new ArrayList<String>();
        int i = 0;
        while (i < in.length()) {
            StringBuilder here = new StringBuilder();
            char first = in.charAt(i);
            here.append(first);
            ++i;
            while (i < in.length()) {
                char hereC = in.charAt(i);
                byte action = this.shouldSplit(first, hereC);
                if ((action & 1) != 0) {
                    here.append(in.charAt(i));
                    ++i;
                }
                if ((action & 2) == 0 && (action & 1) != 0) continue;
                break;
            }
            parts.add(here.toString());
        }
        return parts.toArray(new String[0]);
    }

    private byte shouldSplit(char start, char here) {
        byte ret = 1;
        if (Character.isWhitespace(start) ^ Character.isWhitespace(here)) {
            ret = 2;
        }
        if (here == '<') {
            ret = 2;
        }
        if (start == '<') {
            ret = 1;
            if (here == '>') {
                ret = (byte)(ret | 2);
            }
        }
        return ret;
    }

    private class Page {
        final int lines;
        final Function<String, IManualPage> factory;

        public Page(int l, Function<String, IManualPage> f) {
            this.factory = f;
            this.lines = l;
        }
    }
}

