/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.client.render;

import blusunrize.immersiveengineering.api.IEApi;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import malte0811.industrialwires.IWConfig;
import malte0811.industrialwires.IndustrialWires;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.ARBShaderObjects;

public class Shaders {
    public static int JACOBS_ARC;
    public static int MARX;
    private static String PREFIX;
    private static final int VERT = 35633;
    private static final int FRAG = 35632;

    public static void initShaders(boolean setupReload) {
        if (Shaders.areShadersEnabled()) {
            JACOBS_ARC = Shaders.createProgram(null, PREFIX + "jacobs.frag");
            MARX = Shaders.createProgram(null, PREFIX + "marx.frag");
            if (setupReload) {
                IEApi.renderCacheClearers.add(() -> {
                    if (JACOBS_ARC != 0) {
                        Shaders.deleteShader(JACOBS_ARC);
                        JACOBS_ARC = 0;
                    }
                    if (MARX != 0) {
                        Shaders.deleteShader(MARX);
                        MARX = 0;
                    }
                    Shaders.initShaders(false);
                });
            }
        }
    }

    private static void deleteShader(int id) {
        if (id != 0) {
            ARBShaderObjects.glDeleteObjectARB((int)id);
        }
    }

    public static void useShader(int shader) {
        if (Shaders.areShadersEnabled()) {
            ARBShaderObjects.glUseProgramObjectARB((int)shader);
            if (shader != 0) {
                int time = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"time");
                ARBShaderObjects.glUniform1fARB((int)time, (float)((float)Minecraft.func_71410_x().field_71441_e.func_82737_E() + Minecraft.func_71410_x().func_184121_ak()));
            }
        }
    }

    public static void stopUsingShaders() {
        Shaders.useShader(0);
    }

    private static int createProgram(String vert, String frag) {
        int program;
        int vertId = 0;
        int fragId = 0;
        if (vert != null) {
            vertId = Shaders.createShader(vert, 35633);
        }
        if (frag != null) {
            fragId = Shaders.createShader(frag, 35632);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            IndustrialWires.logger.error(Shaders.getLogInfo(program));
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            IndustrialWires.logger.error(Shaders.getLogInfo(program));
            return 0;
        }
        return program;
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)Shaders.readFileAsString(filename));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + Shaders.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    private static String readFileAsString(String filename) throws Exception {
        InputStream in = Shaders.class.getResourceAsStream(filename);
        if (in == null) {
            return "";
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            String string = Shaders.preProcess(reader.lines());
            return string;
        }
    }

    public static boolean areShadersEnabled() {
        return IWConfig.HVStuff.enableShaders && OpenGlHelper.field_148824_g;
    }

    private static String preProcess(Stream<String> lines) {
        lines = lines.map(s -> {
            if (s.startsWith("#include ")) {
                s = s.substring("#include ".length());
                String fileName = PREFIX + s;
                try {
                    return Shaders.readFileAsString(fileName);
                }
                catch (Exception e) {
                    throw new RuntimeException(fileName + " not readable", e);
                }
            }
            return s;
        });
        return lines.collect(Collectors.joining("\n"));
    }

    static {
        PREFIX = "/assets/industrialwires/shaders/";
    }
}

