/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.client.render;

import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import malte0811.industrialwires.blocks.IWProperties;
import malte0811.industrialwires.blocks.hv.TileEntityMarx;
import malte0811.industrialwires.client.ClientEventHandler;
import malte0811.industrialwires.client.render.Shaders;
import malte0811.industrialwires.util.MiscUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class TileRenderMarx
extends TileEntitySpecialRenderer<TileEntityMarx> {
    public static boolean screenShot = false;

    public void render(TileEntityMarx te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        boolean debug = false;
        if (te.type == IWProperties.MarxType.BOTTOM && te.state == TileEntityMarx.FiringState.FIRE && te.dischargeData != null) {
            Vec3d player = Minecraft.func_71410_x().field_71439_g.func_174824_e(partialTicks);
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder vb = tes.func_178180_c();
            Matrix4 mat = this.prepare(x, y, z, te, player);
            if (te.dischargeData.energy > 0.0f) {
                this.drawDischarge(te.dischargeData, vb, tes, mat);
            }
            GlStateManager.func_179121_F();
            Vec3i facing = te.facing.func_176730_m();
            Vec3d offset = new Vec3d((Vec3i)MiscUtils.offset(BlockPos.field_177992_a, te.facing, te.mirrored, 1, 1, 0));
            offset = offset.func_72441_c(-0.5 * this.oneSgn(offset.field_72450_a), 0.0, -0.5 * this.oneSgn(offset.field_72449_c));
            float pos = 0.3125f;
            Vec3d gapDir = new Vec3d((double)(facing.func_177952_p() * (te.mirrored ? -1 : 1)), 1.0, (double)(facing.func_177958_n() * (te.mirrored ? 1 : -1)));
            Vec3d up = new Vec3d(gapDir.field_72450_a, -1.0, gapDir.field_72449_c);
            Vec3d bottomGap = new Vec3d(offset.field_72450_a + (double)((float)facing.func_177958_n() * 0.3125f) + 0.5, offset.field_72448_b + 0.75, offset.field_72449_c + (double)((float)facing.func_177952_p() * 0.3125f) + 0.5);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + bottomGap.field_72450_a), (double)(y + bottomGap.field_72448_b), (double)(z + bottomGap.field_72449_c));
            bottomGap = bottomGap.func_72441_c((double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p());
            for (int i = 0; i < te.getStageCount() - 1; ++i) {
                this.renderGap(i, facing, vb, tes, player, gapDir, up, bottomGap, te.mirrored);
            }
            this.cleanUp();
            te.state = TileEntityMarx.FiringState.CHARGING;
            if (screenShot) {
                ClientEventHandler.shouldScreenshot = true;
                screenShot = false;
            }
        }
    }

    private double oneSgn(double in) {
        double ret = Math.signum(in);
        return ret == 0.0 ? 1.0 : ret;
    }

    private void renderGap(int i, Vec3i facing, BufferBuilder vb, Tessellator tes, Vec3d player, Vec3d gapDir, Vec3d up, Vec3d bottomGap, boolean mirrored) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)i, (float)0.0f);
        GlStateManager.func_179114_b((float)(mirrored ? 45 : 135), (float)facing.func_177958_n(), (float)facing.func_177956_o(), (float)facing.func_177952_p());
        player = player.func_178786_a(bottomGap.field_72450_a, bottomGap.field_72448_b + (double)i, bottomGap.field_72449_c);
        double t = player.func_72430_b(gapDir) / 2.0;
        Vec3d lineToPlayer = gapDir.func_186678_a(t).func_178788_d(player);
        double angleRad = Math.acos(up.func_72430_b(lineToPlayer) / (up.func_72433_c() * lineToPlayer.func_72433_c()));
        float angle = (float)Math.toDegrees(angleRad *= Math.signum(lineToPlayer.func_72430_b(new Vec3d(facing))));
        if (facing.func_177952_p() < 0) {
            angle = 270.0f + angle;
        } else if (facing.func_177952_p() > 0) {
            angle = 90.0f + angle;
        } else if (facing.func_177958_n() > 0) {
            angle = 180.0f + angle;
        }
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        this.drawDischargeSection(new Vec3d(0.0, (double)-0.2f, 0.0), new Vec3d(0.0, (double)0.2f, 0.0), 0.25f, 0.4f, 0.45f, vb);
        tes.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private Matrix4 prepare(double x, double y, double z, TileEntityMarx te, Vec3d player) {
        this.func_190053_a(true);
        GlStateManager.func_179094_E();
        BlockPos offset = MiscUtils.offset(BlockPos.field_177992_a, te.facing, te.mirrored, 1, 4, 1);
        Vec3d bottom = new Vec3d((double)offset.func_177958_n() + 0.5, (double)offset.func_177956_o(), (double)offset.func_177952_p() + 0.5);
        GlStateManager.func_179137_b((double)(x + bottom.field_72450_a), (double)(y + bottom.field_72448_b), (double)(z + bottom.field_72449_c));
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        player = player.func_178788_d(bottom.func_178787_e(new Vec3d((Vec3i)te.func_174877_v())));
        double angle = Math.atan2(player.field_72450_a, player.field_72449_c);
        Matrix4 ret = new Matrix4();
        ret.rotate(-angle, 0.0, 1.0, 0.0);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(angle)), (float)0.0f, (float)1.0f, (float)0.0f);
        Shaders.useShader(Shaders.MARX);
        return ret;
    }

    private void cleanUp() {
        this.func_190053_a(false);
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        Shaders.stopUsingShaders();
    }

    private void drawDischarge(TileEntityMarx.Discharge d, BufferBuilder vb, Tessellator tes, Matrix4 mat) {
        if (d != null && d.vertices != null) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            for (int i = 0; i < d.vertices.length - 1; ++i) {
                this.drawDischargeSection(mat.apply(d.vertices[i]), mat.apply(d.vertices[i + 1]), d.diameter, (float)i / (float)(d.vertices.length - 1), (float)(i + 1) / (float)(d.vertices.length - 1), vb);
            }
            tes.func_78381_a();
        }
    }

    private void drawDischargeSection(Vec3d start, Vec3d end, float diameter, float aMin, float aMax, BufferBuilder vb) {
        if (Shaders.areShadersEnabled()) {
            this.drawPart(0.0, diameter, start, end, aMin, aMax, vb);
        } else {
            this.drawPart(-diameter / 3.0f, diameter / 3.0f, start, end, 0.0f, 1.0f, vb);
            this.drawPart(0.0, diameter / 3.0f, start, end, 1.0f, 1.0f, vb);
            this.drawPart(diameter / 3.0f, diameter / 3.0f, start, end, 1.0f, 0.0f, vb);
        }
    }

    private void drawPart(double offset, double diameter, Vec3d start, Vec3d end, float aMin, float aMax, BufferBuilder vb) {
        boolean shaders = Shaders.areShadersEnabled();
        float red1 = shaders ? 0.0f : 1.0f;
        vb.func_178969_c(offset - diameter / 2.0, 0.0, 0.0);
        vb.func_181662_b(start.field_72450_a, start.field_72448_b, start.field_72449_c).func_181666_a(red1, 1.0f, 1.0f, aMin).func_181675_d();
        vb.func_181662_b(start.field_72450_a + diameter, start.field_72448_b, start.field_72449_c).func_181666_a(1.0f, 1.0f, 1.0f, shaders ? aMin : aMax).func_181675_d();
        vb.func_181662_b(end.field_72450_a + diameter, end.field_72448_b, end.field_72449_c).func_181666_a(1.0f, 1.0f, 1.0f, aMax).func_181675_d();
        vb.func_181662_b(end.field_72450_a, end.field_72448_b, end.field_72449_c).func_181666_a(red1, 1.0f, 1.0f, shaders ? aMax : aMin).func_181675_d();
        vb.func_178969_c(0.0, 0.0, 0.0);
    }
}

