/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.mech_mb;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration0;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import malte0811.industrialwires.IEObjects;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.converter.MechanicalMBBlockType;
import malte0811.industrialwires.blocks.converter.TileEntityMechMB;
import malte0811.industrialwires.client.render.TileRenderMechMB;
import malte0811.industrialwires.entities.EntityBrokenPart;
import malte0811.industrialwires.mech_mb.MechEnergy;
import malte0811.industrialwires.mech_mb.MechPartCommutator;
import malte0811.industrialwires.mech_mb.MechPartCommutator4Phase;
import malte0811.industrialwires.mech_mb.MechPartFlywheel;
import malte0811.industrialwires.mech_mb.MechPartFourCoils;
import malte0811.industrialwires.mech_mb.MechPartFourElectrodes;
import malte0811.industrialwires.mech_mb.MechPartShaft;
import malte0811.industrialwires.mech_mb.MechPartSingleCoil;
import malte0811.industrialwires.mech_mb.MechPartSpeedometer;
import malte0811.industrialwires.mech_mb.MechPartTwoElectrodes;
import malte0811.industrialwires.util.LocalSidedWorld;
import malte0811.industrialwires.util.MiscUtils;
import malte0811.industrialwires.util.MultiblockTemplateManual;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MechMBPart {
    public static final Map<String, MechMBPart> INSTANCES = new HashMap<String, MechMBPart>();
    public LocalSidedWorld world;
    protected Map<BlockPos, IBlockState> original = new HashMap<BlockPos, IBlockState>();
    public static final BiMap<String, Class<? extends MechMBPart>> REGISTRY = HashBiMap.create();
    public static final String SHAFT_KEY = "shaft";
    public static final ResourceLocation EXAMPLE_MECHMB_LOC = new ResourceLocation("industrialwires", "example_mech_mb");
    public static final Comparator<MechMBPart> SORT_BY_COUNT = (a, b) -> {
        if (a.getLength() != b.getLength()) {
            return Integer.compare(a.getLength(), b.getLength());
        }
        for (int i = 0; i < a.getLength(); ++i) {
            int bBits;
            int aBits = MiscUtils.count1Bits(a.getFormPattern(i));
            if (aBits == (bBits = MiscUtils.count1Bits(b.getFormPattern(i)))) continue;
            return Integer.compare(aBits, bBits);
        }
        return 0;
    };

    public abstract void createMEnergy(MechEnergy var1);

    public abstract double requestMEnergy(MechEnergy var1);

    public abstract void insertMEnergy(double var1);

    public abstract double getInertia();

    public abstract double getMaxSpeed();

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public IBlockState getExtState(IBlockState in) {
        return in;
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getRotatingQuads() {
        return TileRenderMechMB.BASE_MODELS.get(this.getRotatingBaseModel()).func_188616_a(null, null, 123L);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract ResourceLocation getRotatingBaseModel();

    public abstract boolean canForm(LocalSidedWorld var1);

    protected boolean hasSupportPillars(LocalSidedWorld w) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                IBlockState state = w.getBlockState(new BlockPos(2 * i - 1, j - 1, 0));
                if (MechMBPart.isLightEngineering(state)) continue;
                return false;
            }
        }
        return true;
    }

    public abstract short getFormPattern(int var1);

    public abstract void breakOnFailure(MechEnergy var1);

    public ItemStack getOriginalItem(BlockPos pos) {
        IBlockState state = this.getOriginalBlock(pos);
        return new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
    }

    public IBlockState getOriginalBlock(BlockPos pos) {
        return this.original.getOrDefault(pos, Blocks.field_150350_a.func_176223_P());
    }

    public abstract MechanicalMBBlockType getType();

    public <T> boolean hasCapability(Capability<T> cap, EnumFacing side, BlockPos pos) {
        return false;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing side, BlockPos pos) {
        return null;
    }

    public int interact(@Nonnull EnumFacing side, @Nonnull Vec3i offset, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull ItemStack heldItem) {
        return -1;
    }

    public static void preInit() {
        REGISTRY.put((Object)"flywheel", MechPartFlywheel.class);
        REGISTRY.put((Object)"singleCoil", MechPartSingleCoil.class);
        REGISTRY.put((Object)"twoElectrodes", MechPartTwoElectrodes.class);
        REGISTRY.put((Object)"commutator", MechPartCommutator.class);
        REGISTRY.put((Object)SHAFT_KEY, MechPartShaft.class);
        REGISTRY.put((Object)"speedometer", MechPartSpeedometer.class);
        REGISTRY.put((Object)"commFour", MechPartCommutator4Phase.class);
        REGISTRY.put((Object)"fourCoils", MechPartFourCoils.class);
        REGISTRY.put((Object)"fourElectrodes", MechPartFourElectrodes.class);
        for (String key : REGISTRY.keySet()) {
            MechMBPart.cacheNewInstance(key);
            MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)new MultiblockTemplateManual(MechMBPart.getSchematicLocationForPart(key)));
        }
    }

    public static void init() {
        for (String key : REGISTRY.keySet()) {
            MechMBPart.cacheNewInstance(key);
        }
    }

    public static ResourceLocation getSchematicLocationForPart(Class<? extends MechMBPart> cl) {
        String name = (String)REGISTRY.inverse().get(cl);
        return MechMBPart.getSchematicLocationForPart(name);
    }

    public static ResourceLocation getSchematicLocationForPart(String name) {
        if (name == null) {
            return null;
        }
        name = MiscUtils.toSnakeCase(name);
        return new ResourceLocation("industrialwires", name);
    }

    public static MultiblockHandler.IMultiblock getManualMBForPart(Class<? extends MechMBPart> cl) {
        return MiscUtils.getMBFromName(MechMBPart.getSchematicLocationForPart(cl).toString());
    }

    public static void cacheNewInstance(String key) {
        try {
            MechMBPart instance = (MechMBPart)((Class)REGISTRY.get((Object)key)).newInstance();
            INSTANCES.put(key, instance);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static MechMBPart fromNBT(NBTTagCompound nbt, LocalSidedWorld w) {
        String name = nbt.func_74779_i("type");
        Class clazz = (Class)REGISTRY.get((Object)name);
        try {
            MechMBPart ret = (MechMBPart)clazz.newInstance();
            ret.readFromNBT(nbt);
            if (w == null) {
                throw new NullPointerException();
            }
            ret.world = w;
            return ret;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("While creating mechanical MB part", e);
        }
    }

    public static NBTTagCompound toNBT(MechMBPart part) {
        Class<?> clazz = part.getClass();
        String name = (String)REGISTRY.inverse().get(clazz);
        NBTTagCompound nbt = new NBTTagCompound();
        part.writeToNBT(nbt);
        nbt.func_74778_a("type", name);
        return nbt;
    }

    public static boolean isValidDefaultCenter(IBlockState state) {
        return state.func_177230_c() == IEObjects.blockMetalDecoration0 && state.func_177229_b((IProperty)IEObjects.blockMetalDecoration0.property) == BlockTypes_MetalDecoration0.HEAVY_ENGINEERING;
    }

    public static boolean isHeavyEngineering(IBlockState state) {
        return MechMBPart.isValidDefaultCenter(state);
    }

    public static boolean isLightEngineering(IBlockState state) {
        return state.func_177230_c() == IEObjects.blockMetalDecoration0 && state.func_177229_b((IProperty)IEObjects.blockMetalDecoration0.property) == BlockTypes_MetalDecoration0.LIGHT_ENGINEERING;
    }

    public IBlockState getDefaultShaft() {
        return IEObjects.blockMetalDecoration0.func_176223_P().func_177226_a((IProperty)IEObjects.blockMetalDecoration0.property, (Comparable)BlockTypes_MetalDecoration0.HEAVY_ENGINEERING);
    }

    public IBlockState getLightEngineering() {
        return IEObjects.blockMetalDecoration0.func_176223_P().func_177226_a((IProperty)IEObjects.blockMetalDecoration0.property, (Comparable)BlockTypes_MetalDecoration0.LIGHT_ENGINEERING);
    }

    protected boolean areBlocksRegistered() {
        return Loader.instance().getLoaderState().ordinal() > LoaderState.PREINITIALIZATION.ordinal();
    }

    public void form(LocalSidedWorld w, Consumer<TileEntityMechMB> initializer) {
        this.world = w;
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int z = 0; z < this.getLength(); ++z) {
            short pattern = this.getFormPattern(z);
            int i = 0;
            for (int y = -1; y <= 1; ++y) {
                for (int x = -1; x <= 1; ++x) {
                    if ((pattern & 1 << i) != 0) {
                        pos.func_181079_c(x, y, -z);
                        w.setBlockState((BlockPos)pos, IndustrialWires.mechanicalMB.func_176203_a((i == 4 ? this.getType() : MechanicalMBBlockType.NO_MODEL).ordinal()));
                        TileEntity te = w.getTileEntity((BlockPos)pos);
                        if (te instanceof TileEntityMechMB) {
                            initializer.accept((TileEntityMechMB)te);
                        }
                    }
                    ++i;
                }
            }
        }
        pos.func_185344_t();
    }

    public void disassemble() {
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int z = 0; z < this.getLength(); ++z) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    pos.func_181079_c(x, y, -z);
                    IBlockState state = this.getOriginalBlock((BlockPos)pos);
                    if (state.func_177230_c() == Blocks.field_150350_a) continue;
                    this.world.setBlockState((BlockPos)pos, state);
                }
            }
        }
        pos.func_185344_t();
    }

    protected void spawnBrokenParts(int count, MechEnergy energy, ResourceLocation texture) {
        Matrix4 mat = new Matrix4();
        mat.rotate(Utils.RAND.nextDouble(), 0.0, 0.0, 1.0);
        Vec3d baseVec = new Vec3d(0.0, 1.5, 0.0);
        for (int i = 0; i < count; ++i) {
            mat.rotate(Math.PI * 2 / (double)count, 0.0, 0.0, 1.0);
            Vec3d pos = mat.apply(baseVec);
            EntityBrokenPart e = new EntityBrokenPart(this.world.getWorld(), texture);
            e.func_70107_b(pos.field_72450_a, pos.field_72448_b, -0.5);
            double speed = energy.getSpeed() / this.getMaxSpeed() / 1.5;
            e.field_70159_w = pos.field_72448_b * speed;
            e.field_70181_x = -pos.field_72450_a * speed;
            e.field_70179_y = (Utils.RAND.nextDouble() - 0.5) * speed / 10.0;
            this.world.spawnEntity(e);
            e.breakBlocks(speed * speed * 1.5 * 1.5);
        }
    }

    public int getLength() {
        return 1;
    }

    public abstract AxisAlignedBB getBoundingBox(BlockPos var1);
}

