/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.mech_mb;

import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration0;
import malte0811.industrialwires.IEObjects;
import malte0811.industrialwires.blocks.converter.MechanicalMBBlockType;
import malte0811.industrialwires.mech_mb.IMBPartElectric;
import malte0811.industrialwires.mech_mb.Material;
import malte0811.industrialwires.mech_mb.MechEnergy;
import malte0811.industrialwires.mech_mb.MechMBPart;
import malte0811.industrialwires.mech_mb.Waveform;
import malte0811.industrialwires.util.LocalSidedWorld;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class MechPartSingleCoil
extends MechMBPart
implements IMBPartElectric {
    private double bufferToMech;
    private double bufferToE;
    protected static final ResourceLocation COIL_TEXTURE = new ResourceLocation("immersiveengineering", "blocks/metal_decoration0_coil_lv_side");

    public MechPartSingleCoil() {
        if (this.areBlocksRegistered()) {
            IBlockState lightEng = this.getLightEngineering();
            IBlockState coil = this.getCoil();
            for (int y = -1; y <= 1; ++y) {
                this.original.put(new BlockPos(-1, y, 0), lightEng);
                this.original.put(new BlockPos(0, y, 0), coil);
                this.original.put(new BlockPos(1, y, 0), lightEng);
            }
            this.original.put(BlockPos.field_177992_a, this.getDefaultShaft());
        }
    }

    @Override
    public Waveform getProduced(MechEnergy state) {
        return Waveform.forParameters(Waveform.Type.AC, Waveform.Phases.get(this.has4Phases()), Waveform.Speed.ROTATION);
    }

    @Override
    public double getAvailableEEnergy(MechEnergy energy) {
        return this.bufferToE;
    }

    @Override
    public void extractEEnergy(double eEnergy, MechEnergy mEnergy) {
        this.bufferToE -= eEnergy;
    }

    @Override
    public double requestEEnergy(Waveform waveform, MechEnergy energy) {
        if (this.has4Phases() ^ waveform.isSinglePhase()) {
            return this.getMaxBuffer() - this.bufferToMech;
        }
        return 0.0;
    }

    @Override
    public void insertEEnergy(double given, Waveform waveform, MechEnergy energy) {
        this.bufferToMech = waveform.isDC() ? 0.0 : (this.bufferToMech += given);
    }

    @Override
    public void createMEnergy(MechEnergy e) {
        e.addEnergy(this.bufferToMech);
        this.bufferToMech = 0.0;
    }

    @Override
    public double requestMEnergy(MechEnergy e) {
        return this.getMaxBuffer() - this.bufferToE;
    }

    @Override
    public void insertMEnergy(double added) {
        this.bufferToE += added;
    }

    @Override
    public double getInertia() {
        return Material.IRON.density + Material.COPPER.density;
    }

    @Override
    public double getMaxSpeed() {
        return 100.0;
    }

    @Override
    public void writeToNBT(NBTTagCompound out) {
        out.func_74780_a("inBuffer", this.bufferToMech);
        out.func_74780_a("outBuffer", this.bufferToE);
    }

    @Override
    public void readFromNBT(NBTTagCompound in) {
        this.bufferToMech = in.func_74769_h("inBuffer");
        this.bufferToE = in.func_74769_h("outBuffer");
    }

    @Override
    public ResourceLocation getRotatingBaseModel() {
        return new ResourceLocation("industrialwires", "block/mech_mb/single_coil.obj");
    }

    protected boolean isCoil(IBlockState state) {
        return state.func_177230_c() == IEObjects.blockMetalDecoration0 && state.func_177229_b((IProperty)IEObjects.blockMetalDecoration0.property) == BlockTypes_MetalDecoration0.COIL_LV;
    }

    protected IBlockState getCoil() {
        return IEObjects.blockMetalDecoration0.func_176223_P().func_177226_a((IProperty)IEObjects.blockMetalDecoration0.property, (Comparable)BlockTypes_MetalDecoration0.COIL_LV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canForm(LocalSidedWorld w) {
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185339_c((int)0, (int)0, (int)0);
        try {
            if (!MechPartSingleCoil.isValidDefaultCenter(w.getBlockState((BlockPos)pos))) {
                boolean bl = false;
                return bl;
            }
            pos.func_181079_c(0, 1, 0);
            if (!this.isCoil(w.getBlockState((BlockPos)pos))) {
                boolean bl = false;
                return bl;
            }
            pos.func_181079_c(0, -1, 0);
            if (!this.isCoil(w.getBlockState((BlockPos)pos))) {
                boolean bl = false;
                return bl;
            }
            for (int i = -1; i <= 1; i += 2) {
                for (int y = -1; y <= 1; ++y) {
                    pos.func_181079_c(i, y, 0);
                    if (MechPartSingleCoil.isLightEngineering(w.getBlockState((BlockPos)pos))) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            pos.func_185344_t();
        }
    }

    @Override
    public short getFormPattern(int offset) {
        return 511;
    }

    @Override
    public void breakOnFailure(MechEnergy energy) {
        this.world.setBlockState(BlockPos.field_177992_a, this.getDefaultShaft());
        for (int i = -1; i <= 1; i += 2) {
            for (int y = -1; y <= 1; ++y) {
                this.world.setBlockState(new BlockPos(i, y, 0), this.getLightEngineering());
            }
        }
        this.spawnBrokenParts(this.has4Phases() ? 8 : 4, energy, COIL_TEXTURE);
    }

    @Override
    public MechanicalMBBlockType getType() {
        return MechanicalMBBlockType.COIL_1_PHASE;
    }

    protected double getMaxBuffer() {
        return 10000.0;
    }

    protected boolean has4Phases() {
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBox(BlockPos offsetPart) {
        if (BlockPos.field_177992_a.equals((Object)offsetPart)) {
            return Block.field_185505_j;
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 1.0, 0.9375);
    }
}

