/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.util;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.hv.MultiblockMarx;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public final class MiscUtils {
    private MiscUtils() {
    }

    public static List<BlockPos> discoverLocal(BlockPos here, BiPredicate<BlockPos, Integer> isValid) {
        if (!isValid.test(here, 0)) {
            return new ArrayList<BlockPos>();
        }
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        ArrayDeque<BlockPos> open = new ArrayDeque<BlockPos>();
        open.add(here);
        while (!open.isEmpty()) {
            BlockPos curr = (BlockPos)open.poll();
            assert (curr != null);
            ret.add(curr);
            for (EnumFacing f : EnumFacing.field_82609_l) {
                BlockPos next = curr.func_177972_a(f);
                if (open.contains(next) || ret.contains(next) || !isValid.test(next, ret.size())) continue;
                open.offer(next);
            }
        }
        return ret;
    }

    public static BlockPos offset(BlockPos p, EnumFacing f, boolean mirror, Vec3i relative) {
        return MiscUtils.offset(p, f, mirror, relative.func_177958_n(), relative.func_177952_p(), relative.func_177956_o());
    }

    public static BlockPos offset(BlockPos p, EnumFacing f, boolean mirror, int right, int forward, int up) {
        if (mirror) {
            right *= -1;
        }
        return p.func_177967_a(f, forward).func_177967_a(f.func_176746_e(), right).func_177982_a(0, up, 0);
    }

    public static Vec3d offset(Vec3d p, EnumFacing f, boolean mirror, Vec3d relative) {
        return MiscUtils.offset(p, f, mirror, relative.field_72450_a, relative.field_72449_c, relative.field_72448_b);
    }

    public static Vec3d offset(Vec3d p, EnumFacing f, boolean mirror, double right, double forward, double up) {
        if (mirror) {
            right *= -1.0;
        }
        return MiscUtils.offset(MiscUtils.offset(p, f, forward), f.func_176746_e(), right).func_72441_c(0.0, up, 0.0);
    }

    public static Vec3d offset(Vec3d in, EnumFacing f, double amount) {
        if (amount == 0.0) {
            return in;
        }
        return in.func_72441_c((double)f.func_82601_c() * amount, (double)f.func_96559_d() * amount, (double)f.func_82599_e() * amount);
    }

    public static BlockPos getOffset(Vec3i origin, EnumFacing f, boolean mirror, Vec3i here) {
        int dX = here.func_177958_n() - origin.func_177958_n();
        int dZ = here.func_177952_p() - origin.func_177952_p();
        int forward = 0;
        int right = 0;
        int up = here.func_177956_o() - origin.func_177956_o();
        switch (f) {
            case NORTH: {
                forward = dZ;
                right = -dX;
                break;
            }
            case SOUTH: {
                forward = -dZ;
                right = dX;
                break;
            }
            case WEST: {
                right = dZ;
                forward = dX;
                break;
            }
            case EAST: {
                right = -dZ;
                forward = -dX;
            }
        }
        if (mirror) {
            right *= -1;
        }
        return new BlockPos(right, forward, up);
    }

    @Nonnull
    public static AxisAlignedBB apply(@Nonnull Matrix4 mat, @Nonnull AxisAlignedBB in) {
        Vec3d min = new Vec3d(in.field_72340_a, in.field_72338_b, in.field_72339_c);
        Vec3d max = new Vec3d(in.field_72336_d, in.field_72337_e, in.field_72334_f);
        min = mat.apply(min);
        max = mat.apply(max);
        return new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
    }

    public static float[] interpolate(double a, float[] cA, double b, float[] cB) {
        float[] ret = new float[cA.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (float)(a * (double)cA[i] + b * (double)cB[i]);
        }
        return ret;
    }

    public static Set<ImmersiveNetHandler.Connection> genConnBlockstate(Set<ImmersiveNetHandler.Connection> conns, World world) {
        if (conns == null) {
            return ImmutableSet.of();
        }
        HashSet<ImmersiveNetHandler.Connection> ret = new HashSet<ImmersiveNetHandler.Connection>(){

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof HashSet)) {
                    return false;
                }
                HashSet other = (HashSet)o;
                if (other.size() != this.size()) {
                    return false;
                }
                for (ImmersiveNetHandler.Connection c : this) {
                    if (other.contains(c)) continue;
                    return false;
                }
                return true;
            }
        };
        for (ImmersiveNetHandler.Connection c : conns) {
            IImmersiveConnectable end = ApiUtils.toIIC((Object)c.end, (World)world, (boolean)false);
            if (end == null) continue;
            c.getSubVertices(world);
            ret.add(c);
        }
        return ret;
    }

    public static void writeConnsToNBT(NBTTagCompound nbt, TileEntity te) {
        World world = te.func_145831_w();
        if (world != null && !world.field_72995_K && nbt != null) {
            NBTTagList connectionList = new NBTTagList();
            Set conL = ImmersiveNetHandler.INSTANCE.getConnections(world, Utils.toCC((Object)te));
            if (conL != null) {
                for (ImmersiveNetHandler.Connection con : conL) {
                    connectionList.func_74742_a((NBTBase)con.writeToNBT());
                }
            }
            nbt.func_74782_a("connectionList", (NBTBase)connectionList);
        }
    }

    public static void loadConnsFromNBT(NBTTagCompound nbt, TileEntity te) {
        World world = te.func_145831_w();
        if (world != null && world.field_72995_K && !IndustrialWires.proxy.isSingleplayer() && nbt != null) {
            NBTTagList connectionList = nbt.func_150295_c("connectionList", 10);
            ImmersiveNetHandler.INSTANCE.clearConnectionsOriginatingFrom(Utils.toCC((Object)te), world);
            for (int i = 0; i < connectionList.func_74745_c(); ++i) {
                NBTTagCompound conTag = connectionList.func_150305_b(i);
                ImmersiveNetHandler.Connection con = ImmersiveNetHandler.Connection.readFromNBT((NBTTagCompound)conTag);
                if (con != null) {
                    ImmersiveNetHandler.INSTANCE.addConnection(world, Utils.toCC((Object)te), con);
                    continue;
                }
                IndustrialWires.logger.error("CLIENT read connection as null");
            }
        }
    }

    public static boolean handleUpdate(int id, BlockPos pos, World world) {
        if (id == -1 || id == 255) {
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
            return true;
        }
        if (id == 254) {
            IBlockState state = world.func_180495_p(pos);
            if (state instanceof IExtendedBlockState) {
                state = state.func_185899_b((IBlockAccess)world, pos);
                state = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos);
                ImmersiveEngineering.proxy.removeStateFromSmartModelCache((IExtendedBlockState)state);
                ImmersiveEngineering.proxy.removeStateFromConnectionModelCache((IExtendedBlockState)state);
            }
            world.func_184138_a(pos, state, state, 3);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static Vec2f rotate90(Vec2f in) {
        return new Vec2f(-in.field_189983_j, in.field_189982_i);
    }

    @SideOnly(value=Side.CLIENT)
    public static Vec2f subtract(Vec2f a, Vec2f b) {
        return new Vec2f(a.field_189982_i - b.field_189982_i, a.field_189983_j - b.field_189983_j);
    }

    @SideOnly(value=Side.CLIENT)
    public static Vec2f add(Vec2f a, Vec2f b) {
        return new Vec2f(a.field_189982_i + b.field_189982_i, a.field_189983_j + b.field_189983_j);
    }

    @SideOnly(value=Side.CLIENT)
    public static Vec2f scale(Vec2f a, float f) {
        return new Vec2f(a.field_189982_i * f, a.field_189983_j * f);
    }

    @SideOnly(value=Side.CLIENT)
    public static Vector3f withNewY(Vec2f in, float y) {
        return new Vector3f(in.field_189982_i, y, in.field_189983_j);
    }

    public static int count1Bits(int i) {
        int ret = 0;
        for (int j = 0; j < 32; ++j) {
            ret += i >>> j & 1;
        }
        return ret;
    }

    public static EnumFacing applyRotationToFacing(Rotation rot, EnumFacing facing) {
        switch (rot) {
            case CLOCKWISE_90: {
                facing = facing.func_176746_e();
                break;
            }
            case CLOCKWISE_180: {
                facing = facing.func_176734_d();
                break;
            }
            case COUNTERCLOCKWISE_90: {
                facing = facing.func_176735_f();
            }
        }
        return facing;
    }

    public static Rotation getRotationBetweenFacings(EnumFacing orig, EnumFacing to) {
        if (to == orig) {
            return Rotation.NONE;
        }
        if (orig.func_176740_k() == EnumFacing.Axis.Y || to.func_176740_k() == EnumFacing.Axis.Y) {
            return null;
        }
        if ((orig = orig.func_176746_e()) == to) {
            return Rotation.CLOCKWISE_90;
        }
        if ((orig = orig.func_176746_e()) == to) {
            return Rotation.CLOCKWISE_180;
        }
        if ((orig = orig.func_176746_e()) == to) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        return null;
    }

    public static String toSnakeCase(String in) {
        StringBuilder ret = new StringBuilder(in.length());
        ret.append(in.charAt(0));
        for (int i = 1; i < in.length(); ++i) {
            char here = in.charAt(i);
            if (Character.isUpperCase(here)) {
                ret.append('_').append(Character.toLowerCase(here));
                continue;
            }
            ret.append(here);
        }
        return ret.toString();
    }

    public static MultiblockHandler.IMultiblock getMBFromName(String s) {
        for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
            if (!mb.getUniqueName().equals(s)) continue;
            return mb;
        }
        return MultiblockMarx.INSTANCE;
    }

    public static <T extends TileEntity> T getLoadedTE(World w, BlockPos pos, Class<T> clazz) {
        TileEntity te;
        if (w.func_175667_e(pos) && (te = w.func_175625_s(pos)) != null && clazz.isAssignableFrom(te.getClass())) {
            return (T)te;
        }
        return null;
    }
}

