/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.backpacked.BackpackConfig;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class ExtendedPlayerInventory
extends InventoryPlayer {
    public final NonNullList<ItemStack> backpackArray = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    public final NonNullList<ItemStack> backpackInventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private final List<NonNullList<ItemStack>> allInventories = ImmutableList.of((Object)this.field_70462_a, (Object)this.field_70460_b, (Object)this.field_184439_c, this.backpackInventory);

    public ExtendedPlayerInventory(EntityPlayer player) {
        super(player);
    }

    public NonNullList<ItemStack> getBackpackItems() {
        return this.backpackInventory;
    }

    public void copyBackpack(ExtendedPlayerInventory inventory) {
        this.backpackInventory.set(0, inventory.backpackInventory.get(0));
    }

    public ItemStack func_70298_a(int index, int count) {
        NonNullList<ItemStack> targetInventory = null;
        for (NonNullList<ItemStack> inventory : this.allInventories) {
            if (index < inventory.size()) {
                targetInventory = inventory;
                break;
            }
            index -= inventory.size();
        }
        return targetInventory != null && !((ItemStack)targetInventory.get(index)).func_190926_b() ? ItemStackHelper.func_188382_a(targetInventory, (int)index, (int)count) : ItemStack.field_190927_a;
    }

    public void func_184437_d(ItemStack stack) {
        block0: for (NonNullList<ItemStack> inventory : this.allInventories) {
            for (int i = 0; i < inventory.size(); ++i) {
                if (inventory.get(i) != stack) continue;
                inventory.set(i, (Object)ItemStack.field_190927_a);
                continue block0;
            }
        }
    }

    public ItemStack func_70304_b(int index) {
        NonNullList<ItemStack> targetInventory = null;
        for (NonNullList<ItemStack> inventory : this.allInventories) {
            if (index < inventory.size()) {
                targetInventory = inventory;
                break;
            }
            index -= inventory.size();
        }
        if (targetInventory != null && !((ItemStack)targetInventory.get(index)).func_190926_b()) {
            ItemStack stack = (ItemStack)targetInventory.get(index);
            targetInventory.set(index, (Object)ItemStack.field_190927_a);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        NonNullList<ItemStack> targetInventory = null;
        for (NonNullList<ItemStack> inventory : this.allInventories) {
            if (index < inventory.size()) {
                targetInventory = inventory;
                break;
            }
            index -= inventory.size();
        }
        if (targetInventory != null) {
            targetInventory.set(index, (Object)stack);
        }
    }

    public ItemStack func_70301_a(int index) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> inventory : this.allInventories) {
            if (index < inventory.size()) {
                list = inventory;
                break;
            }
            index -= inventory.size();
        }
        return list == null ? ItemStack.field_190927_a : (ItemStack)list.get(index);
    }

    public NBTTagList func_70442_a(NBTTagList tagList) {
        tagList = super.func_70442_a(tagList);
        for (int i = 0; i < this.backpackInventory.size(); ++i) {
            if (((ItemStack)this.backpackInventory.get(i)).func_190926_b()) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)(i + 200));
            ((ItemStack)this.backpackInventory.get(i)).func_77955_b(compound);
            tagList.func_74742_a((NBTBase)compound);
        }
        return tagList;
    }

    public void func_70443_b(NBTTagList tagList) {
        super.func_70443_b(tagList);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            ItemStack stack;
            NBTTagCompound compound = tagList.func_150305_b(i);
            int slot = compound.func_74771_c("Slot") & 0xFF;
            if (slot < 200 || slot >= this.backpackInventory.size() + 200 || (stack = new ItemStack(compound)).func_190926_b()) continue;
            this.backpackInventory.set(slot - 200, (Object)stack);
        }
    }

    public int func_70302_i_() {
        return super.func_70302_i_() + this.backpackInventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.backpackInventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return super.func_191420_l();
    }

    public boolean func_70431_c(ItemStack targetStack) {
        Iterator<NonNullList<ItemStack>> iterator = this.allInventories.iterator();
        if (iterator.hasNext()) {
            ItemStack stack;
            NonNullList<ItemStack> inventory = iterator.next();
            Iterator iterator2 = inventory.iterator();
            do {
                if (iterator2.hasNext()) continue;
                return false;
            } while ((stack = (ItemStack)iterator2.next()).func_190926_b() || !stack.func_77969_a(targetStack));
            return true;
        }
        return false;
    }

    public void func_174888_l() {
        for (List list : this.allInventories) {
            list.clear();
        }
    }

    public void func_70436_m() {
        if (BackpackConfig.COMMON.keepBackpackOnDeath) {
            super.func_70436_m();
        } else {
            for (List list : this.allInventories) {
                for (int i = 0; i < list.size(); ++i) {
                    ItemStack itemstack = (ItemStack)list.get(i);
                    if (itemstack.func_190926_b()) continue;
                    this.field_70458_d.func_146097_a(itemstack, true, false);
                    list.set(i, ItemStack.field_190927_a);
                }
            }
        }
    }
}

