/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class UV {
    private static final float[] cornerUs = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    private static final float[] cornerVs = new float[]{0.0f, 1.0f, 1.0f, 0.0f};
    public float x;
    public float y;
    public float z;
    public float u;
    public float v;

    public UV(Vec3d pos, float u, float v) {
        this((float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c, u, v);
    }

    public UV(float x, float y, float z, float u, float v) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.u = u;
        this.v = v;
    }

    public UV(float x, float y, float z, int corner) {
        this(x, y, z, cornerUs[corner], cornerVs[corner]);
    }

    public UV(float x, float y, float z, int corner, float u1, float u2, float v1, float v2) {
        this(x, y, z, Math.min(u1, u2) + Math.abs(u2 - u1) * cornerUs[corner], Math.min(v1, v2) + Math.abs(v2 - v1) * cornerVs[corner]);
    }

    public static UV interpolate(UV a, UV b, float p) {
        float q = 1.0f - p;
        return new UV(a.x * p + b.x * q, a.y * p + b.y * q, a.z * p + b.z * q, a.u * p + b.u * q, a.v * p + b.v * q);
    }

    public static UV interpolateQuad(UV[] uvs, float u, float v) {
        return UV.interpolate(UV.interpolate(uvs[0], uvs[1], u), UV.interpolate(uvs[3], uvs[2], u), v);
    }

    public void setUVTextureBounds(float u1, float u2, float v1, float v2, int corner) {
        this.u = u1 + (u2 - u1) * cornerUs[corner];
        this.v = v1 + (v2 - v1) * cornerVs[corner];
    }

    public UV add(float d, EnumFacing side) {
        return new UV(this.x + (float)side.func_82601_c() * d, this.y + (float)side.func_96559_d() * d, this.z + (float)side.func_82599_e() * d, this.u, this.v);
    }

    @SideOnly(value=Side.CLIENT)
    public Vector3f toVector3f() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public void offset(float dx, float dy, float dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
    }

    public String toString() {
        return "UV{x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", u=" + this.u + ", v=" + this.v + '}';
    }

    public UV copy() {
        return new UV(this.x, this.y, this.z, this.u, this.v);
    }
}

