/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.fluid;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FluidUtil {
    public static boolean handleFluidContainer(World world, BlockPos pos, EntityPlayer player, ItemStack held) {
        TileEntity te;
        if (held != ItemStack.field_190927_a && held.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (te = world.func_175625_s(pos)) != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            IFluidHandler fh = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            if (player.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler ih = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (!net.minecraftforge.fluids.FluidUtil.tryFillContainerAndStow((ItemStack)held, (IFluidHandler)fh, (IItemHandler)ih, (int)1000000, (EntityPlayer)player, (boolean)true).success) {
                    net.minecraftforge.fluids.FluidUtil.tryEmptyContainerAndStow((ItemStack)held, (IFluidHandler)fh, (IItemHandler)ih, (int)1000000, (EntityPlayer)player, (boolean)true);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean fillWithFluidContainer(IFluidHandler tile, IFluidHandler container) {
        int amt = tile.fill(container.drain(1000, false), true);
        container.drain(amt, true);
        return amt > 0;
    }

    public static boolean emptyWithFluidContainer(IFluidHandler tile, IFluidHandler container) {
        int amt = container.fill(tile.drain(1000, false), true);
        tile.drain(amt, true);
        return amt > 0;
    }

    public static ItemStack transferFluidFromItem(IFluidHandler destination, ItemStack stack, IValidFluid check) {
        IFluidTankProperties[] tp;
        Object fh = FluidUtil.isBucket(stack) ? new FluidBucketWrapper(stack) : net.minecraftforge.fluids.FluidUtil.getFluidHandler((ItemStack)stack);
        if (fh == null) {
            return stack;
        }
        for (IFluidTankProperties i : tp = fh.getTankProperties()) {
            FluidStack fl = i.getContents();
            if (!check.checkValidFluid(fl)) continue;
            net.minecraftforge.fluids.FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)fh, (FluidStack)fl, (boolean)true);
        }
        if (FluidUtil.isBucket(stack)) {
            return fh.getContainer();
        }
        return stack;
    }

    public static boolean isBucket(ItemStack stack) {
        Item i = stack.func_77973_b();
        return i instanceof ItemBucket || i instanceof UniversalBucket;
    }

    public static interface IValidFluid {
        public boolean checkValidFluid(FluidStack var1);
    }
}

