/*
 * Decompiled with CFR 0.152.
 */
package lumien.quickleafdecay;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import lumien.quickleafdecay.config.QuickLeafDecayConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="quickleafdecay", name="Quick Leaf Decay", version="1.2.4", acceptableRemoteVersions="*", guiFactory="lumien.quickleafdecay.config.QuickLeafDecayGuiFactory", acceptedMinecraftVersions="[1.12,1.13)")
public class QuickLeafDecay {
    public static final String MOD_ID = "quickleafdecay";
    static final String MOD_NAME = "Quick Leaf Decay";
    static final String MOD_VERSION = "1.2.4";
    static Random rng = new Random();
    @Mod.Instance
    public static QuickLeafDecay INSTANCE;
    public QuickLeafDecayConfig config;
    Cache<BlockPos, Integer> brokenBlockCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).maximumSize(200L).build();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new QuickLeafDecayConfig();
        this.config.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (this.config.playerDecay && !(event.getPlayer() instanceof FakePlayer) && !event.getWorld().field_72995_K) {
            this.brokenBlockCache.put((Object)event.getPos(), (Object)0);
        }
    }

    @SubscribeEvent
    public void notifyNeighbors(BlockEvent.NeighborNotifyEvent event) {
        if (!this.config.playerDecay || this.brokenBlockCache.getIfPresent((Object)event.getPos()) != null) {
            IBlockState notifierState;
            Block b;
            if (this.config.playerDecay) {
                this.brokenBlockCache.invalidate((Object)event.getPos());
            }
            if ((b = (notifierState = event.getState()).func_177230_c()).isAir(notifierState, (IBlockAccess)event.getWorld(), event.getPos())) {
                for (EnumFacing facing : event.getNotifiedSides()) {
                    IBlockState state;
                    BlockPos pos = event.getPos().func_177972_a(facing);
                    if (!event.getWorld().func_175667_e(pos) || !(state = event.getWorld().func_180495_p(pos)).func_177230_c().isLeaves(state, (IBlockAccess)event.getWorld(), pos) || event.getWorld().func_175691_a(pos, state.func_177230_c()) || event.getWorld().func_184145_b(pos, state.func_177230_c())) continue;
                    if (this.config.playerDecay) {
                        this.brokenBlockCache.put((Object)pos, (Object)0);
                    }
                    event.getWorld().func_175684_a(pos, state.func_177230_c(), this.config.decaySpeed + (this.config.decayFuzz > 0 ? rng.nextInt(this.config.decayFuzz) : 0));
                }
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            this.config.syncConfig();
        }
    }
}

