/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.drop;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jeresources.api.conditionals.Conditional;
import jeresources.util.LootConditionHelper;
import jeresources.util.LootFunctionHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class LootDrop
implements Comparable<LootDrop> {
    public int minDrop;
    public int maxDrop;
    public ItemStack item;
    public ItemStack smeltedItem;
    public float chance;
    private Set<Conditional> conditionals;
    public int fortuneLevel;
    public boolean enchanted;
    private float sortIndex;

    public LootDrop(ItemStack item) {
        this(item, item.func_190916_E());
    }

    public LootDrop(ItemStack item, float chance) {
        this(item, chance, 0);
    }

    public LootDrop(ItemStack item, float chance, int fortuneLevel) {
        this(item, (int)Math.floor(chance), (int)Math.ceil(chance), chance, fortuneLevel, new Conditional[0]);
    }

    public LootDrop(ItemStack item, int minDrop, int maxDrop, Conditional ... conditionals) {
        this(item, minDrop, maxDrop, 1.0f, 0, conditionals);
    }

    public LootDrop(ItemStack item, int minDrop, int maxDrop, float chance, int fortuneLevel, Conditional ... conditionals) {
        this.item = item;
        this.smeltedItem = null;
        this.minDrop = minDrop;
        this.maxDrop = maxDrop;
        this.chance = chance;
        this.sortIndex = Math.min(chance, 1.0f) * (float)(minDrop + maxDrop);
        this.conditionals = new HashSet<Conditional>();
        Collections.addAll(this.conditionals, conditionals);
        this.fortuneLevel = fortuneLevel;
    }

    public LootDrop(Item item, int minDrop, int maxDrop, Conditional ... conditionals) {
        this(new ItemStack(item), minDrop, maxDrop, 1.0f, 0, conditionals);
    }

    public LootDrop(Item item, int itemDamage, int minDrop, int maxDrop, Conditional ... conditionals) {
        this(new ItemStack(item, 1, itemDamage), minDrop, maxDrop, 1.0f, 0, conditionals);
    }

    public LootDrop(Item item, int minDrop, int maxDrop, float chance, Conditional ... conditionals) {
        this(new ItemStack(item), minDrop, maxDrop, chance, 0, conditionals);
    }

    public LootDrop(Item item, int itemDamage, int minDrop, int maxDrop, float chance, Conditional ... conditionals) {
        this(new ItemStack(item, 1, itemDamage), minDrop, maxDrop, chance, 0, conditionals);
    }

    public LootDrop(ItemStack item, int minDrop, int maxDrop, float chance, Conditional ... conditionals) {
        this(item, minDrop, maxDrop, chance, 0, conditionals);
    }

    public LootDrop(Item item, float chance, LootFunction ... lootFunctions) {
        this(new ItemStack(item), chance);
        this.enchanted = false;
        this.addLootFunctions(lootFunctions);
    }

    public LootDrop(Item item, float chance, LootCondition[] lootConditions, LootFunction ... lootFunctions) {
        this(item, chance, lootFunctions);
        this.addLootConditions(lootConditions);
    }

    public LootDrop addLootConditions(LootCondition[] lootFunctions) {
        return this.addLootConditions(Arrays.asList(lootFunctions));
    }

    public LootDrop addLootConditions(Collection<LootCondition> lootFunctions) {
        lootFunctions.forEach(this::addLootCondition);
        return this;
    }

    public LootDrop addLootCondition(LootCondition condition) {
        LootConditionHelper.applyCondition(condition, this);
        return this;
    }

    public LootDrop addLootFunctions(LootFunction[] lootFunctions) {
        return this.addLootFunctions(Arrays.asList(lootFunctions));
    }

    public LootDrop addLootFunctions(Collection<LootFunction> lootFunctions) {
        lootFunctions.forEach(this::addLootFunction);
        return this;
    }

    public LootDrop addLootFunction(LootFunction lootFunction) {
        LootFunctionHelper.applyFunction(lootFunction, this);
        return this;
    }

    public boolean canBeCooked() {
        return this.smeltedItem != null;
    }

    public List<ItemStack> getDrops() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        if (this.item != null) {
            list.add(this.item);
        }
        if (this.smeltedItem != null) {
            list.add(this.smeltedItem);
        }
        return list;
    }

    public String toString() {
        if (this.minDrop == this.maxDrop) {
            return this.minDrop + this.getDropChance();
        }
        return this.minDrop + "-" + this.maxDrop + this.getDropChance();
    }

    private String getDropChance() {
        return this.chance < 1.0f ? " (" + this.formatChance() + "%)" : "";
    }

    private String formatChance() {
        float chance = this.chance * 100.0f;
        if (chance < 10.0f) {
            return String.format("%.1f", Float.valueOf(chance));
        }
        return String.format("%2d", (int)chance);
    }

    public String chanceString() {
        if (this.chance >= 0.995f) {
            return String.format("%.2G", Float.valueOf(this.chance));
        }
        return String.format("%.2G%%", Float.valueOf(this.chance * 100.0f));
    }

    public List<String> getTooltipText() {
        return this.getTooltipText(false);
    }

    public List<String> getTooltipText(boolean smelted) {
        List<String> list = this.conditionals.stream().map(Conditional::toString).collect(Collectors.toList());
        if (smelted) {
            list.add(Conditional.burning.toString());
        }
        return list;
    }

    public void addConditional(Conditional conditional) {
        this.conditionals.add(conditional);
    }

    public void addConditionals(List<Conditional> conditionals) {
        this.conditionals.addAll(conditionals);
    }

    public float getSortIndex() {
        return this.sortIndex;
    }

    @Override
    public int compareTo(@Nonnull LootDrop o) {
        if (ItemStack.func_77989_b((ItemStack)this.item, (ItemStack)o.item)) {
            return Integer.compare(o.fortuneLevel, this.fortuneLevel);
        }
        int cmp = Float.compare(o.getSortIndex(), this.getSortIndex());
        return cmp != 0 ? cmp : this.item.func_82833_r().compareTo(o.item.func_82833_r());
    }
}

