/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.factory;

import info.loenwind.autoconfig.factory.AbstractValue;
import info.loenwind.autoconfig.factory.BooleanValue;
import info.loenwind.autoconfig.factory.ByteBufAdapterRegistry;
import info.loenwind.autoconfig.factory.ByteBufAdapters;
import info.loenwind.autoconfig.factory.DoubleValue;
import info.loenwind.autoconfig.factory.EnumValue;
import info.loenwind.autoconfig.factory.FactoryManager;
import info.loenwind.autoconfig.factory.FloatValue;
import info.loenwind.autoconfig.factory.FluidValue;
import info.loenwind.autoconfig.factory.IByteBufAdapter;
import info.loenwind.autoconfig.factory.IFactory;
import info.loenwind.autoconfig.factory.IValue;
import info.loenwind.autoconfig.factory.IValueFactory;
import info.loenwind.autoconfig.factory.IntListValue;
import info.loenwind.autoconfig.factory.IntValue;
import info.loenwind.autoconfig.factory.LimitedStringValue;
import info.loenwind.autoconfig.factory.StringListValue;
import info.loenwind.autoconfig.factory.StringValue;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;

public class SlaveFactory
implements IValueFactory {
    private final String section;
    private final IFactory parent;
    @Nullable
    private Map<String, Object> serverConfig = null;
    private int generation = 0;
    private final List<AbstractValue<?>> syncValues = new ArrayList();

    public SlaveFactory(IFactory valueFactory, String section) {
        this.parent = valueFactory;
        this.section = section;
        FactoryManager.registerFactory(this);
    }

    @Override
    @Nonnull
    public IValueFactory section(@Nonnull String section) {
        if (section.startsWith(".")) {
            return new SlaveFactory(this, this.section + section);
        }
        return new SlaveFactory(this, section);
    }

    @Override
    @Nonnull
    public String getModid() {
        return this.parent.getModid();
    }

    @Override
    @Nonnull
    public String getSection() {
        return this.section;
    }

    @Override
    @Nonnull
    public IValue<Integer> make(@Nonnull String keyname, int defaultValue, @Nonnull String text) {
        return new IntValue((IValueFactory)this, this.section, keyname, defaultValue, text).preload();
    }

    @Override
    public IValue<int[]> make(String keyname, int[] defaultValue, String text) {
        return new IntListValue((IValueFactory)this, this.section, keyname, defaultValue, text).preload();
    }

    @Override
    @Nonnull
    public IValue<Double> make(@Nonnull String keyname, double defaultValue, @Nonnull String text) {
        return new DoubleValue((IValueFactory)this, this.section, keyname, defaultValue, text).preload();
    }

    @Override
    @Nonnull
    public IValue<Float> make(@Nonnull String keyname, float defaultValue, @Nonnull String text) {
        return new FloatValue((IValueFactory)this, this.section, keyname, Float.valueOf(defaultValue), text).preload();
    }

    @Override
    @Nonnull
    public IValue<String> make(@Nonnull String keyname, @Nonnull String defaultValue, @Nonnull String text) {
        return new StringValue((IValueFactory)this, this.section, keyname, defaultValue, text).preload();
    }

    @Override
    @Nonnull
    public IValue<List<String>> make(@Nonnull String keyname, @Nonnull List<String> defaultValue, @Nonnull String text) {
        return new StringListValue((IValueFactory)this, this.section, keyname, defaultValue, text).preload();
    }

    @Override
    @Nonnull
    public IValue<String> make(@Nonnull String keyname, @Nonnull String defaultValue, @Nonnull String[] limit, @Nonnull String text) {
        return new LimitedStringValue(this, this.section, keyname, defaultValue, limit, text).preload();
    }

    @Override
    @Nonnull
    public IValue<Boolean> make(@Nonnull String keyname, @Nonnull Boolean defaultValue, @Nonnull String text) {
        return new BooleanValue((IValueFactory)this, this.section, keyname, defaultValue, text).preload();
    }

    @Override
    @Nonnull
    public <E extends Enum<E>> IValue<E> make(@Nonnull String keyname, @Nonnull E defaultValue, @Nonnull String text) {
        return new EnumValue<E>(this, this.section, keyname, defaultValue, text);
    }

    @Override
    @Nonnull
    public IValue<Fluid> makeFluid(@Nonnull String keyname, @Nonnull String defaultValue, @Nonnull String text) {
        return new FluidValue((IValueFactory)this, this.section, keyname, defaultValue, text).preload();
    }

    @Override
    public synchronized int read(ByteBuf buf) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (ByteBufAdapters.ENDMARKER.readValue(buf) == null) {
            String keyName = ByteBufAdapters.STRING127.readValue(buf);
            byte dataTypeByte = buf.readByte();
            IByteBufAdapter<?> dataType = ByteBufAdapterRegistry.get(dataTypeByte);
            Object readValue = dataType.readValue(buf);
            result.put(keyName, readValue);
        }
        for (AbstractValue<?> abstractValue : this.syncValues) {
            abstractValue.onServerSync(result);
        }
        this.serverConfig = result;
        ++this.generation;
        return result.size();
    }

    @Override
    public boolean needsSyncing() {
        return !this.syncValues.isEmpty();
    }

    @Override
    public void save(ByteBuf buf) {
        for (AbstractValue<?> value : this.syncValues) {
            value.save(buf);
        }
        ByteBufAdapters.ENDMARKER.saveValue(buf, true);
    }

    @Override
    public void endServerOverride() {
        this.serverConfig = null;
        ++this.generation;
    }

    @Override
    public Configuration getConfig() {
        return this.parent.getConfig();
    }

    @Override
    public boolean isInInit() {
        return this.parent.isInInit();
    }

    @Override
    @Nullable
    public Map<String, Object> getServerConfig() {
        return this.serverConfig;
    }

    @Override
    public int getGeneration() {
        return 31 * (31 + this.parent.getGeneration()) + this.generation;
    }

    @Override
    public void addSyncValue(@Nonnull AbstractValue<?> value) {
        this.syncValues.add(value);
    }

    @Override
    public void addValue(@Nonnull AbstractValue<?> value) {
        this.parent.addValue(value);
    }
}

