/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.bloodmagic;

import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bloodmagic.TartaricForge")
@ZenRegister
@ModOnly(value="bloodmagic")
public class TartaricForge {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] inputs, double minSouls, double soulDrain) {
        if (inputs.length == 0 || inputs.length > 4) {
            CraftTweakerAPI.logError((String)"Invalid Input Array! Maximum size is 4!");
            return;
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)output), minSouls, soulDrain, InputHelper.toObjects((IIngredient[])inputs)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack[] inputs) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toStacks((IItemStack[])inputs)));
    }

    public static String[] getStringFromStacks(Object[] arr) {
        String[] retArr = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            retArr[i] = arr[i].toString();
        }
        return retArr;
    }

    private static class Remove
    extends BaseAction {
        private ItemStack[] inputs;

        public Remove(ItemStack[] inputs) {
            super("TartaricForge");
            this.inputs = inputs;
        }

        public void apply() {
            BloodMagicAPI.INSTANCE.getRecipeRegistrar().removeTartaricForge(this.inputs);
        }

        public String describe() {
            return "Removing TartaricForge recipe for: [" + String.join((CharSequence)",", TartaricForge.getStringFromStacks(this.inputs)) + "]";
        }
    }

    private static class Add
    extends BaseAction {
        private ItemStack output;
        private double minSouls;
        private double soulDrain;
        private Object[] inputs;

        public Add(ItemStack output, double minSouls, double soulDrain, Object[] inputs) {
            super("TartaricForge");
            this.output = output;
            this.minSouls = minSouls;
            this.soulDrain = soulDrain;
            this.inputs = inputs;
        }

        public void apply() {
            BloodMagicAPI.INSTANCE.getRecipeRegistrar().addTartaricForge(this.output, this.minSouls, this.soulDrain, this.inputs);
        }

        public String describe() {
            return "Adding TartaricForge recipe for: " + this.output + " from: [" + String.join((CharSequence)",", TartaricForge.getStringFromStacks(this.inputs)) + "] minSouls: " + this.minSouls + ", soulDrain: " + this.soulDrain;
        }
    }
}

