/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.handler;

import javax.annotation.Nullable;
import net.blay09.mods.waystones.GlobalWaystones;
import net.blay09.mods.waystones.WarpMode;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.block.TileWaystone;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.MessageEditWaystone;
import net.blay09.mods.waystones.network.message.MessageOpenWaystoneSelection;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class HandlerEditWaystone
implements IMessageHandler<MessageEditWaystone, IMessage> {
    @Nullable
    public IMessage onMessage(MessageEditWaystone message, MessageContext ctx) {
        NetworkHandler.getThreadListener(ctx).func_152344_a(() -> {
            EntityPlayerMP entityPlayer = ctx.getServerHandler().field_147369_b;
            if (WaystoneConfig.general.creativeModeOnly && !entityPlayer.field_71075_bZ.field_75098_d) {
                return;
            }
            World world = entityPlayer.func_130014_f_();
            BlockPos pos = message.getPos();
            if (entityPlayer.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > 10.0) {
                return;
            }
            GlobalWaystones globalWaystones = GlobalWaystones.get(entityPlayer.field_70170_p);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileWaystone) {
                TileWaystone tileWaystone = ((TileWaystone)tileEntity).getParent();
                if (globalWaystones.getGlobalWaystone(tileWaystone.getWaystoneName()) != null && !entityPlayer.field_71075_bZ.field_75098_d && !WaystoneConfig.general.allowEveryoneGlobal) {
                    return;
                }
                if (WaystoneConfig.general.restrictRenameToOwner && !tileWaystone.isOwner((EntityPlayer)entityPlayer)) {
                    ctx.getServerHandler().field_147369_b.func_145747_a((ITextComponent)new TextComponentTranslation("waystones:notTheOwner", new Object[0]));
                    return;
                }
                String newName = message.getName();
                if (newName.equals("%RANDOM%") && !entityPlayer.field_71075_bZ.field_75098_d) {
                    newName = "RANDOM";
                }
                if (globalWaystones.getGlobalWaystone(newName) != null && !entityPlayer.field_71075_bZ.field_75098_d) {
                    ctx.getServerHandler().field_147369_b.func_145747_a((ITextComponent)new TextComponentTranslation("waystones:nameOccupied", new Object[]{newName}));
                    return;
                }
                WaystoneEntry oldWaystone = new WaystoneEntry(tileWaystone);
                if (oldWaystone.isGlobal()) {
                    globalWaystones.removeGlobalWaystone(oldWaystone);
                }
                tileWaystone.setWaystoneName(newName);
                WaystoneEntry newWaystone = new WaystoneEntry(tileWaystone);
                if (message.isGlobal() && (entityPlayer.field_71075_bZ.field_75098_d || WaystoneConfig.general.allowEveryoneGlobal)) {
                    tileWaystone.setGlobal(true);
                    newWaystone.setGlobal(true);
                    globalWaystones.addGlobalWaystone(newWaystone);
                    for (Object obj : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                        WaystoneManager.sendPlayerWaystones((EntityPlayer)obj);
                    }
                }
                if (!newWaystone.isGlobal()) {
                    WaystoneManager.removePlayerWaystone((EntityPlayer)entityPlayer, oldWaystone);
                    WaystoneManager.addPlayerWaystone((EntityPlayer)entityPlayer, newWaystone);
                    WaystoneManager.sendPlayerWaystones((EntityPlayer)entityPlayer);
                }
                if (message.isFromSelectionGui()) {
                    NetworkHandler.channel.sendTo((IMessage)new MessageOpenWaystoneSelection(WarpMode.WAYSTONE, EnumHand.MAIN_HAND, newWaystone), entityPlayer);
                }
            }
        });
        return null;
    }
}

