/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.gencontroller;

import java.util.HashSet;
import mcjty.deepresonance.blocks.generator.GeneratorConfiguration;
import mcjty.deepresonance.blocks.generator.GeneratorSetup;
import mcjty.deepresonance.blocks.generator.GeneratorTileEntity;
import mcjty.deepresonance.client.sound.GeneratorSoundController;
import mcjty.deepresonance.generatornetwork.DRGeneratorNetwork;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.Broadcaster;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GeneratorControllerTileEntity
extends GenericTileEntity
implements ITickable {
    private int startup = 0;
    private int shutdown = 0;
    private boolean active = false;
    private boolean rsControlled = true;
    private boolean activated = false;

    public boolean isPowered() {
        return this.powerLevel > 0;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean working = this.isPowered();
        super.onDataPacket(net, packet);
        if (this.func_145831_w().field_72995_K && this.isPowered() != working) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.func_145831_w().field_72995_K) {
            this.stopSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopSounds() {
        GeneratorSoundController.stopSound(this.func_145831_w(), this.func_174877_v());
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        } else {
            this.checkStateClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void checkStateClient() {
        if (GeneratorConfiguration.baseGeneratorVolume < 0.01f) {
            return;
        }
        if (this.startup != 0) {
            if (!GeneratorSoundController.isStartupPlaying(this.func_145831_w(), this.field_174879_c)) {
                GeneratorSoundController.playStartup(this.func_145831_w(), this.field_174879_c);
            }
        } else if (this.shutdown != 0) {
            if (!GeneratorSoundController.isShutdownPlaying(this.func_145831_w(), this.field_174879_c)) {
                GeneratorSoundController.playShutdown(this.func_145831_w(), this.field_174879_c);
            }
        } else if (this.active) {
            if (!GeneratorSoundController.isLoopPlaying(this.func_145831_w(), this.field_174879_c)) {
                GeneratorSoundController.playLoop(this.func_145831_w(), this.field_174879_c);
            }
        } else {
            this.stopSounds();
        }
    }

    protected void checkStateServer() {
        boolean active = this.rsControlled && this.powerLevel > 0 || !this.rsControlled && this.activated;
        boolean dirty = false;
        HashSet<Integer> networks = new HashSet<Integer>();
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            GeneratorTileEntity generatorTileEntity;
            int networkId;
            BlockPos newC = this.func_174877_v().func_177972_a(direction);
            Block b = this.func_145831_w().func_180495_p(newC).func_177230_c();
            if (b != GeneratorSetup.generatorBlock || (networkId = (generatorTileEntity = (GeneratorTileEntity)this.func_145831_w().func_175625_s(newC)).getNetworkId()) == -1 || networks.contains(networkId)) continue;
            networks.add(networkId);
            if (active) {
                int countCollectors = generatorTileEntity.getNetwork().getCollectorBlocks();
                if (countCollectors == 1) {
                    if (!this.handleActivate(networkId, newC)) continue;
                    dirty = true;
                    continue;
                }
                if (countCollectors < 1) {
                    Broadcaster.broadcast((World)this.func_145831_w(), (int)this.func_174877_v().func_177958_n(), (int)this.func_174877_v().func_177956_o(), (int)this.func_174877_v().func_177952_p(), (String)"There is no energy collector on this generator!", (float)100.0f);
                } else {
                    Broadcaster.broadcast((World)this.func_145831_w(), (int)this.func_174877_v().func_177958_n(), (int)this.func_174877_v().func_177956_o(), (int)this.func_174877_v().func_177952_p(), (String)"There are too many energy collectors on this generator!!", (float)100.0f);
                }
                if (!this.handleDeactivate(networkId, newC)) continue;
                dirty = true;
                continue;
            }
            if (!this.handleDeactivate(networkId, newC)) continue;
            dirty = true;
        }
        if (dirty) {
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.func_145831_w());
            generatorNetwork.save();
        }
    }

    public void activate() {
        this.rsControlled = false;
        this.activated = true;
        this.markDirtyClient();
    }

    public void deactivate() {
        this.activated = false;
        this.markDirtyClient();
    }

    public void setRsControlled(boolean f) {
        this.rsControlled = f;
    }

    private boolean handleActivate(int id, BlockPos coordinate) {
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.func_145831_w());
        DRGeneratorNetwork.Network network = generatorNetwork.getOrCreateNetwork(id);
        if (network.isActive() && network.getShutdownCounter() == 0) {
            return false;
        }
        this.startup = network.getStartupCounter();
        if (this.startup == 0) {
            this.startup = GeneratorConfiguration.startupTime;
        }
        --this.startup;
        if (this.startup <= 0) {
            this.startup = 0;
            GeneratorTileEntity generatorTileEntity = (GeneratorTileEntity)this.func_145831_w().func_175625_s(coordinate);
            generatorTileEntity.activate(true);
        }
        this.active = network.isActive();
        this.shutdown = 0;
        network.setShutdownCounter(0);
        network.setStartupCounter(this.startup);
        this.func_70296_d();
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
        return true;
    }

    private boolean handleDeactivate(int id, BlockPos coordinate) {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.func_145831_w());
        DRGeneratorNetwork.Network network = generatorNetwork.getOrCreateNetwork(id);
        if (!network.isActive() && network.getShutdownCounter() == 0 && network.getStartupCounter() == 0) {
            if (network.getShutdownCounter() != this.shutdown || network.getStartupCounter() != this.startup || network.isActive() != this.active) {
                this.shutdown = network.getShutdownCounter();
                this.startup = network.getStartupCounter();
                this.active = network.isActive();
                this.func_70296_d();
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
            }
            return false;
        }
        this.shutdown = network.getShutdownCounter();
        if (network.isActive() || network.getStartupCounter() != 0) {
            this.shutdown = GeneratorConfiguration.shutdownTime;
            GeneratorTileEntity generatorTileEntity = (GeneratorTileEntity)this.func_145831_w().func_175625_s(coordinate);
            generatorTileEntity.activate(false);
        }
        --this.shutdown;
        if (this.shutdown <= 0) {
            this.shutdown = 0;
        }
        this.startup = 0;
        this.active = network.isActive();
        network.setStartupCounter(0);
        network.setShutdownCounter(this.shutdown);
        this.func_70296_d();
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        return true;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.startup = tagCompound.func_74762_e("startup");
        this.shutdown = tagCompound.func_74762_e("shutdown");
        this.active = tagCompound.func_74767_n("active");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("startup", this.startup);
        tagCompound.func_74768_a("shutdown", this.shutdown);
        tagCompound.func_74757_a("active", this.active);
        return tagCompound;
    }
}

