/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.laser;

public class InfusingBonus {
    private final int color;
    private final Modifier purityModifier;
    private final Modifier strengthModifier;
    private final Modifier efficiencyModifier;

    public InfusingBonus(int color, Modifier purityModifier, Modifier strengthModifier, Modifier efficiencyModifier) {
        this.color = color;
        this.efficiencyModifier = efficiencyModifier;
        this.purityModifier = purityModifier;
        this.strengthModifier = strengthModifier;
    }

    public int getColor() {
        return this.color;
    }

    public Modifier getEfficiencyModifier() {
        return this.efficiencyModifier;
    }

    public Modifier getPurityModifier() {
        return this.purityModifier;
    }

    public Modifier getStrengthModifier() {
        return this.strengthModifier;
    }

    public static class Modifier {
        private final float bonus;
        private final float maxOrMin;
        public static final Modifier NONE = new Modifier(0.0f, 0.0f);

        public Modifier(float bonus, float maxOrMin) {
            this.maxOrMin = maxOrMin;
            this.bonus = bonus;
        }

        public float getMaxOrMin() {
            return this.maxOrMin;
        }

        public float getBonus() {
            return this.bonus;
        }

        public float modify(float value, float quality, float factor) {
            if (this.bonus == 0.0f) {
                return value;
            }
            float toAdd = factor * this.bonus / 100.0f;
            float cap = this.maxOrMin / 100.0f * quality;
            if (this.bonus > 0.0f) {
                if (value + toAdd > cap && (toAdd = cap - value) < 0.0f) {
                    toAdd = 0.0f;
                }
            } else if (value + toAdd < cap && (toAdd = cap - value) > 0.0f) {
                toAdd = 0.0f;
            }
            return value += toAdd;
        }
    }
}

