/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.deepresonance.generatornetwork.DRGeneratorNetwork;
import mcjty.deepresonance.network.DRMessages;
import mcjty.deepresonance.network.PacketReturnGeneratorInfo;
import mcjty.lib.thirteen.Context;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetGeneratorInfo
implements IMessage {
    private int networkId;

    public void fromBytes(ByteBuf buf) {
        this.networkId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.networkId);
    }

    public PacketGetGeneratorInfo() {
    }

    public PacketGetGeneratorInfo(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGetGeneratorInfo(int networkId) {
        this.networkId = networkId;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            World world = ctx.getSender().func_130014_f_();
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(world);
            DRGeneratorNetwork.Network network = generatorNetwork.getChannel(this.networkId);
            if (network == null) {
                return;
            }
            PacketReturnGeneratorInfo packet = new PacketReturnGeneratorInfo(this.networkId, network.getEnergy(), network.getGeneratorBlocks(), network.getLastRfPerTick());
            DRMessages.INSTANCE.sendTo((IMessage)packet, ctx.getSender());
        });
        ctx.setPacketHandled(true);
    }
}

