/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Action;
import com.mrcrayfish.controllable.event.AvailableActionsEvent;
import com.mrcrayfish.controllable.event.ControllerEvent;
import com.mrcrayfish.controllable.event.RenderPlayerPreviewEvent;
import com.mrcrayfish.vehicle.VehicleConfig;
import com.mrcrayfish.vehicle.entity.EntityHelicopter;
import com.mrcrayfish.vehicle.entity.EntityLandVehicle;
import com.mrcrayfish.vehicle.entity.EntityPlane;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageHitchTrailer;
import com.mrcrayfish.vehicle.proxy.ClientProxy;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class ControllerEvents {
    @SubscribeEvent
    public void onButtonInput(ControllerEvent.ButtonInput event) {
        if (event.getState()) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            switch (event.getButton()) {
                case 0: {
                    if (Minecraft.func_71410_x().field_71462_r != null || !(player.func_184187_bx() instanceof EntityPoweredVehicle)) break;
                    event.setCanceled(true);
                    break;
                }
                case 2: {
                    if (Minecraft.func_71410_x().field_71462_r != null || !(player.func_184187_bx() instanceof EntityVehicle)) break;
                    EntityVehicle vehicle = (EntityVehicle)player.func_184187_bx();
                    if (vehicle.canTowTrailer()) {
                        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageHitchTrailer(vehicle.getTrailer() == null));
                    }
                    event.setCanceled(true);
                    break;
                }
                case 4: {
                    if (!(player.func_184187_bx() instanceof EntityVehicle)) break;
                    player.field_70177_z = player.func_184187_bx().field_70177_z;
                    player.field_70125_A = 15.0f;
                    event.setCanceled(true);
                    break;
                }
                case 9: 
                case 10: {
                    if (!(player.func_184187_bx() instanceof EntityVehicle)) break;
                    event.setCanceled(true);
                    break;
                }
                case 11: 
                case 12: {
                    if (!VehicleConfig.CLIENT.controller.useTriggers || !(player.func_184187_bx() instanceof EntityVehicle)) break;
                    event.setCanceled(true);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onControllerMove(ControllerEvent.Move event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184187_bx() instanceof EntityVehicle) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAvailableActions(AvailableActionsEvent event) {
        Entity entity;
        Map availableActions = event.getActions();
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player.func_184187_bx() instanceof EntityVehicle && mc.field_71462_r == null) {
            availableActions.remove(10);
            availableActions.remove(9);
            availableActions.remove(12);
            availableActions.remove(11);
            availableActions.remove(7);
            availableActions.remove(2);
            availableActions.remove(14);
            availableActions.put(7, new Action("Exit Vehicle", Action.Side.LEFT));
            if (VehicleConfig.CLIENT.controller.useTriggers) {
                availableActions.put(12, new Action("Accelerate", Action.Side.RIGHT));
            } else {
                availableActions.put(0, new Action("Accelerate", Action.Side.RIGHT));
            }
            EntityVehicle vehicle = (EntityVehicle)player.func_184187_bx();
            if (vehicle instanceof EntityPoweredVehicle) {
                int button;
                int n = button = VehicleConfig.CLIENT.controller.useTriggers ? 11 : 1;
                if (((EntityPoweredVehicle)vehicle).getSpeed() > 0.05f) {
                    availableActions.put(button, new Action("Brake", Action.Side.RIGHT));
                } else {
                    availableActions.put(button, new Action("Reverse", Action.Side.RIGHT));
                }
            }
            if (vehicle instanceof EntityLandVehicle) {
                availableActions.put(10, new Action("Drift", Action.Side.RIGHT));
            } else if (vehicle instanceof EntityPlane) {
                availableActions.put(10, new Action("Pull Up", Action.Side.RIGHT));
                availableActions.put(9, new Action("Pull Down", Action.Side.RIGHT));
            } else if (vehicle instanceof EntityHelicopter) {
                availableActions.put(10, new Action("Increase Elevation", Action.Side.RIGHT));
                availableActions.put(9, new Action("Decreased Elevation", Action.Side.RIGHT));
            }
        } else if (!player.func_184218_aH() && mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.ENTITY && (entity = mc.field_71476_x.field_72308_g) instanceof EntityVehicle) {
            availableActions.put(11, new Action("Ride Vehicle", Action.Side.RIGHT));
        }
    }

    @SubscribeEvent
    public void onRenderPlayerPreview(RenderPlayerPreviewEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184187_bx() instanceof EntityVehicle) {
            event.setCanceled(true);
        }
    }

    public static boolean isRightClicking() {
        boolean isRightClicking = Mouse.isButtonDown((int)(Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151463_i() + 100));
        return isRightClicking |= ClientProxy.controllableLoaded && Controllable.getController() != null && Controllable.getController().getLTriggerValue() != 0.0f;
    }
}

