/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mrcrayfish.vehicle.VehicleConfig;
import com.mrcrayfish.vehicle.client.ControllerEvents;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.common.CommonEvents;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.trailer.EntityFertilizerTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityFluidTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntitySeederTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityStorageTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityVehicleTrailer;
import com.mrcrayfish.vehicle.entity.vehicle.EntityATV;
import com.mrcrayfish.vehicle.entity.vehicle.EntityAluminumBoat;
import com.mrcrayfish.vehicle.entity.vehicle.EntityBath;
import com.mrcrayfish.vehicle.entity.vehicle.EntityBumperCar;
import com.mrcrayfish.vehicle.entity.vehicle.EntityCouch;
import com.mrcrayfish.vehicle.entity.vehicle.EntityDuneBuggy;
import com.mrcrayfish.vehicle.entity.vehicle.EntityGoKart;
import com.mrcrayfish.vehicle.entity.vehicle.EntityGolfCart;
import com.mrcrayfish.vehicle.entity.vehicle.EntityJetSki;
import com.mrcrayfish.vehicle.entity.vehicle.EntityLawnMower;
import com.mrcrayfish.vehicle.entity.vehicle.EntityMiniBike;
import com.mrcrayfish.vehicle.entity.vehicle.EntityMiniBus;
import com.mrcrayfish.vehicle.entity.vehicle.EntityMoped;
import com.mrcrayfish.vehicle.entity.vehicle.EntityOffRoader;
import com.mrcrayfish.vehicle.entity.vehicle.EntityShoppingCart;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySmartCar;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySofacopter;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySpeedBoat;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySportsPlane;
import com.mrcrayfish.vehicle.entity.vehicle.EntityTractor;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.item.ItemJerryCan;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageFuelVehicle;
import com.mrcrayfish.vehicle.network.message.MessageInteractKey;
import com.mrcrayfish.vehicle.network.message.MessagePickupVehicle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class EntityRaytracer {
    private static boolean initialized;
    private static final Map<Class<? extends IEntityRaytraceable>, Map<RayTracePart, TriangleRayTraceList>> entityRaytraceTrianglesStatic;
    private static final Map<Class<? extends IEntityRaytraceable>, Map<RayTracePart, TriangleRayTraceList>> entityRaytraceTrianglesDynamic;
    private static final Map<Class<? extends IEntityRaytraceable>, Map<RayTracePart, TriangleRayTraceList>> entityRaytraceTriangles;
    private static final Map<Class<? extends Entity>, Pair<Float, Float>> entityCrateScalesAndOffsets;
    private static final Pair<Float, Float> SCALE_AND_OFFSET_DEFAULT;
    private static Class<? extends Entity> entityRaytraceSuperclass;
    public static final String PART_NAME = "nameRaytrace";
    private static RayTraceResultRotated continuousInteraction;
    private static Object continuousInteractionObject;
    private static int continuousInteractionTickCounter;
    public static final Function<RayTraceResultRotated, EnumHand> FUNCTION_FUELING;

    public static void clearDataForReregistration() {
        entityRaytraceTrianglesStatic.clear();
        entityRaytraceTrianglesDynamic.clear();
        entityRaytraceTriangles.clear();
        entityCrateScalesAndOffsets.clear();
        entityRaytraceSuperclass = null;
        initialized = false;
    }

    @Nullable
    public static RayTraceResultRotated getContinuousInteraction() {
        return continuousInteraction;
    }

    @Nullable
    public static Object getContinuousInteractionObject() {
        return continuousInteractionObject;
    }

    private static void registerEntitiesStatic() {
        ArrayList<MatrixTransformation> aluminumBoatTransformGlobal = new ArrayList<MatrixTransformation>();
        EntityRaytracer.createBodyTransforms(aluminumBoatTransformGlobal, EntityAluminumBoat.class);
        HashMap aluminumBoatParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.ALUMINUM_BOAT_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)aluminumBoatParts, aluminumBoatTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createFuelablePartTransforms(SpecialModels.FUEL_PORT_CLOSED, EntityAluminumBoat.class, (HashMap<RayTracePart, List<MatrixTransformation>>)aluminumBoatParts, aluminumBoatTransformGlobal);
        EntityRaytracer.registerEntityStatic(EntityAluminumBoat.class, aluminumBoatParts);
        ArrayList atvTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(atvTransformGlobal, EntityATV.class);
        HashMap atvParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.ATV_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)atvParts, (List<MatrixTransformation>)atvTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart(SpecialModels.ATV_HANDLE_BAR, (HashMap<RayTracePart, List<MatrixTransformation>>)atvParts, (List<MatrixTransformation>)atvTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.3375, 0.25), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.025, 0.0));
        EntityRaytracer.createTransformListForPart(SpecialModels.TOW_BAR, (HashMap<RayTracePart, List<MatrixTransformation>>)atvParts, MatrixTransformation.createRotation(180.0, 0.0, 1.0, 0.0), MatrixTransformation.createTranslation(0.0, 0.5, 1.05));
        EntityRaytracer.createFuelablePartTransforms(SpecialModels.FUEL_PORT_2_CLOSED, EntityATV.class, (HashMap<RayTracePart, List<MatrixTransformation>>)atvParts, (List<MatrixTransformation>)atvTransformGlobal);
        EntityRaytracer.createKeyPortTransforms(SpecialModels.KEY_HOLE, EntityATV.class, (HashMap<RayTracePart, List<MatrixTransformation>>)atvParts, (List<MatrixTransformation>)atvTransformGlobal);
        EntityRaytracer.registerEntityStatic(EntityATV.class, atvParts);
        ArrayList bumperCarTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(bumperCarTransformGlobal, EntityBumperCar.class);
        HashMap bumperCarParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.BUMPER_CAR_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)bumperCarParts, (List<MatrixTransformation>)bumperCarTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart(SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)bumperCarParts, (List<MatrixTransformation>)bumperCarTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.2, 0.0), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.02, 0.0), MatrixTransformation.createScale(0.9));
        EntityRaytracer.createFuelablePartTransforms(SpecialModels.FUEL_PORT_CLOSED, EntityBumperCar.class, (HashMap<RayTracePart, List<MatrixTransformation>>)bumperCarParts, (List<MatrixTransformation>)bumperCarTransformGlobal);
        EntityRaytracer.registerEntityStatic(EntityBumperCar.class, bumperCarParts);
        ArrayList duneBuggyTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(duneBuggyTransformGlobal, EntityDuneBuggy.class);
        HashMap duneBuggyParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.DUNE_BUGGY_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)duneBuggyParts, (List<MatrixTransformation>)duneBuggyTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart(SpecialModels.DUNE_BUGGY_HANDLE_BAR, (HashMap<RayTracePart, List<MatrixTransformation>>)duneBuggyParts, (List<MatrixTransformation>)duneBuggyTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.0, -0.0046875));
        EntityRaytracer.createFuelablePartTransforms(SpecialModels.FUEL_PORT_CLOSED, EntityDuneBuggy.class, (HashMap<RayTracePart, List<MatrixTransformation>>)duneBuggyParts, (List<MatrixTransformation>)duneBuggyTransformGlobal);
        EntityRaytracer.registerEntityStatic(EntityDuneBuggy.class, duneBuggyParts);
        ArrayList goKartTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(goKartTransformGlobal, EntityGoKart.class);
        HashMap goKartParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.GO_KART_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)goKartParts, (List<MatrixTransformation>)goKartTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart(SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)goKartParts, (List<MatrixTransformation>)goKartTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.09, 0.49), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.02, 0.0), MatrixTransformation.createScale(0.9));
        EntityRaytracer.createPartTransforms(ModItems.SMALL_ENGINE, VehicleProperties.getProperties(EntityGoKart.class).getEnginePosition(), (HashMap<RayTracePart, List<MatrixTransformation>>)goKartParts, (List<MatrixTransformation>)goKartTransformGlobal, FUNCTION_FUELING);
        EntityRaytracer.registerEntityStatic(EntityGoKart.class, goKartParts);
        ArrayList jetSkiTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(jetSkiTransformGlobal, EntityJetSki.class);
        HashMap jetSkiParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.JET_SKI_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)jetSkiParts, (List<MatrixTransformation>)jetSkiTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart(SpecialModels.ATV_HANDLE_BAR, (HashMap<RayTracePart, List<MatrixTransformation>>)jetSkiParts, (List<MatrixTransformation>)jetSkiTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.375, 0.25), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, 0.02, 0.0));
        EntityRaytracer.createFuelablePartTransforms(SpecialModels.FUEL_PORT_2_CLOSED, EntityJetSki.class, (HashMap<RayTracePart, List<MatrixTransformation>>)jetSkiParts, (List<MatrixTransformation>)jetSkiTransformGlobal);
        EntityRaytracer.registerEntityStatic(EntityJetSki.class, jetSkiParts);
        ArrayList lawnMowerTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(lawnMowerTransformGlobal, EntityLawnMower.class);
        HashMap lawnMowerParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.LAWN_MOWER_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)lawnMowerParts, (List<MatrixTransformation>)lawnMowerTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart(SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)lawnMowerParts, (List<MatrixTransformation>)lawnMowerTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.4, -0.15), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createScale(0.9));
        EntityRaytracer.createTransformListForPart(SpecialModels.TOW_BAR, (HashMap<RayTracePart, List<MatrixTransformation>>)lawnMowerParts, MatrixTransformation.createRotation(180.0, 0.0, 1.0, 0.0), MatrixTransformation.createTranslation(0.0, 0.5, 0.6));
        EntityRaytracer.createFuelablePartTransforms(SpecialModels.FUEL_PORT_CLOSED, EntityLawnMower.class, (HashMap<RayTracePart, List<MatrixTransformation>>)lawnMowerParts, (List<MatrixTransformation>)lawnMowerTransformGlobal);
        EntityRaytracer.registerEntityStatic(EntityLawnMower.class, lawnMowerParts);
        ArrayList miniBikeTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(miniBikeTransformGlobal, EntityMiniBike.class);
        HashMap miniBikeParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.MINI_BIKE_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)miniBikeParts, (List<MatrixTransformation>)miniBikeTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart(SpecialModels.MINI_BIKE_HANDLE_BAR, (HashMap<RayTracePart, List<MatrixTransformation>>)miniBikeParts, (List<MatrixTransformation>)miniBikeTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createPartTransforms(ModItems.SMALL_ENGINE, VehicleProperties.getProperties(EntityMiniBike.class).getEnginePosition(), (HashMap<RayTracePart, List<MatrixTransformation>>)miniBikeParts, (List<MatrixTransformation>)miniBikeTransformGlobal, FUNCTION_FUELING);
        EntityRaytracer.registerEntityStatic(EntityMiniBike.class, miniBikeParts);
        ArrayList mopedTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(mopedTransformGlobal, EntityMoped.class);
        HashMap mopedParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.MOPED_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)mopedParts, (List<MatrixTransformation>)mopedTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart(SpecialModels.MOPED_HANDLE_BAR, (HashMap<RayTracePart, List<MatrixTransformation>>)mopedParts, (List<MatrixTransformation>)mopedTransformGlobal, MatrixTransformation.createTranslation(0.0, -0.0625, 0.0), MatrixTransformation.createTranslation(0.0, 0.835, 0.525), MatrixTransformation.createScale(0.8));
        EntityRaytracer.createTransformListForPart(SpecialModels.MOPED_MUD_GUARD, (HashMap<RayTracePart, List<MatrixTransformation>>)mopedParts, (List<MatrixTransformation>)mopedTransformGlobal, MatrixTransformation.createTranslation(0.0, -0.0625, 0.0), MatrixTransformation.createTranslation(0.0, -0.12, 0.785), MatrixTransformation.createRotation(-22.5, 1.0, 0.0, 0.0), MatrixTransformation.createScale(0.9));
        EntityRaytracer.createFuelablePartTransforms(SpecialModels.FUEL_PORT_CLOSED, EntityMoped.class, (HashMap<RayTracePart, List<MatrixTransformation>>)mopedParts, (List<MatrixTransformation>)mopedTransformGlobal);
        EntityRaytracer.registerEntityStatic(EntityMoped.class, mopedParts);
        ArrayList cartTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(cartTransformGlobal, EntityShoppingCart.class);
        HashMap cartParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.SHOPPING_CART_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)cartParts, (List<MatrixTransformation>)cartTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.registerEntityStatic(EntityShoppingCart.class, cartParts);
        ArrayList smartCarTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(smartCarTransformGlobal, EntitySmartCar.class);
        HashMap smartCarParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.SMART_CAR_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)smartCarParts, (List<MatrixTransformation>)smartCarTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart(SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)smartCarParts, (List<MatrixTransformation>)smartCarTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.2, 0.3), MatrixTransformation.createRotation(-67.5, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.02, 0.0), MatrixTransformation.createScale(0.9));
        EntityRaytracer.createTransformListForPart(SpecialModels.TOW_BAR, (HashMap<RayTracePart, List<MatrixTransformation>>)smartCarParts, MatrixTransformation.createRotation(180.0, 0.0, 1.0, 0.0), MatrixTransformation.createTranslation(0.0, 0.5, 1.35));
        EntityRaytracer.createFuelablePartTransforms(SpecialModels.FUEL_PORT_CLOSED, EntitySmartCar.class, (HashMap<RayTracePart, List<MatrixTransformation>>)smartCarParts, (List<MatrixTransformation>)smartCarTransformGlobal);
        EntityRaytracer.registerEntityStatic(EntitySmartCar.class, smartCarParts);
        ArrayList speedBoatTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(speedBoatTransformGlobal, EntitySpeedBoat.class);
        HashMap speedBoatParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.SPEED_BOAT_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)speedBoatParts, (List<MatrixTransformation>)speedBoatTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart(SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)speedBoatParts, (List<MatrixTransformation>)speedBoatTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.215, -0.125), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, 0.02, 0.0));
        EntityRaytracer.createFuelablePartTransforms(SpecialModels.FUEL_PORT_CLOSED, EntitySpeedBoat.class, (HashMap<RayTracePart, List<MatrixTransformation>>)speedBoatParts, (List<MatrixTransformation>)speedBoatTransformGlobal);
        EntityRaytracer.registerEntityStatic(EntitySpeedBoat.class, speedBoatParts);
        ArrayList sportsPlaneTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(sportsPlaneTransformGlobal, EntitySportsPlane.class);
        HashMap sportsPlaneParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.SPORTS_PLANE_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createFuelablePartTransforms(SpecialModels.FUEL_PORT_CLOSED, EntitySportsPlane.class, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal);
        EntityRaytracer.createKeyPortTransforms(SpecialModels.KEY_HOLE, EntitySportsPlane.class, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal);
        EntityRaytracer.createTransformListForPart(SpecialModels.SPORTS_PLANE_WING, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(0.0, -0.1875, 0.5), MatrixTransformation.createRotation(180.0, 0.0, 0.0, 1.0), MatrixTransformation.createTranslation(0.875, 0.0625, 0.0), MatrixTransformation.createRotation(5.0, 1.0, 0.0, 0.0));
        EntityRaytracer.createTransformListForPart(SpecialModels.SPORTS_PLANE_WING, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(0.875, -0.1875, 0.5), MatrixTransformation.createRotation(-5.0, 1.0, 0.0, 0.0));
        sportsPlaneTransformGlobal.add(MatrixTransformation.createTranslation(0.0, -0.5, 0.0));
        sportsPlaneTransformGlobal.add(MatrixTransformation.createScale(0.85));
        EntityRaytracer.createTransformListForPart(SpecialModels.SPORTS_PLANE_WHEEL_COVER, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(0.0, -0.1875, 1.5));
        EntityRaytracer.createTransformListForPart(SpecialModels.SPORTS_PLANE_LEG, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(0.0, -0.1875, 1.5));
        EntityRaytracer.createTransformListForPart(SpecialModels.SPORTS_PLANE_WHEEL_COVER, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(-0.46875, -0.1875, 0.125));
        EntityRaytracer.createTransformListForPart(SpecialModels.SPORTS_PLANE_LEG, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(-0.46875, -0.1875, 0.125), MatrixTransformation.createRotation(-100.0, 0.0, 1.0, 0.0));
        EntityRaytracer.createTransformListForPart(SpecialModels.SPORTS_PLANE_WHEEL_COVER, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(0.46875, -0.1875, 0.125));
        EntityRaytracer.createTransformListForPart(SpecialModels.SPORTS_PLANE_LEG, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(0.46875, -0.1875, 0.125), MatrixTransformation.createRotation(100.0, 0.0, 1.0, 0.0));
        EntityRaytracer.registerEntityStatic(EntitySportsPlane.class, sportsPlaneParts);
        ArrayList golfCartTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(golfCartTransformGlobal, EntityGolfCart.class);
        HashMap golfCartParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.GOLF_CART_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)golfCartParts, (List<MatrixTransformation>)golfCartTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart(SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)golfCartParts, (List<MatrixTransformation>)golfCartTransformGlobal, MatrixTransformation.createTranslation(-0.345, 0.425, 0.1), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.02, 0.0), MatrixTransformation.createScale(0.95));
        EntityRaytracer.createFuelablePartTransforms(SpecialModels.FUEL_PORT_CLOSED, EntityGolfCart.class, (HashMap<RayTracePart, List<MatrixTransformation>>)golfCartParts, (List<MatrixTransformation>)golfCartTransformGlobal);
        EntityRaytracer.createKeyPortTransforms(SpecialModels.KEY_HOLE, EntityGolfCart.class, (HashMap<RayTracePart, List<MatrixTransformation>>)golfCartParts, (List<MatrixTransformation>)golfCartTransformGlobal);
        EntityRaytracer.registerEntityStatic(EntityGolfCart.class, golfCartParts);
        ArrayList offRoaderTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(offRoaderTransformGlobal, EntityOffRoader.class);
        HashMap offRoaderParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.OFF_ROADER_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)offRoaderParts, (List<MatrixTransformation>)offRoaderTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart(SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)offRoaderParts, (List<MatrixTransformation>)offRoaderTransformGlobal, MatrixTransformation.createTranslation(-0.3125, 0.35, 0.2), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.02, 0.0), MatrixTransformation.createScale(0.75));
        EntityRaytracer.createFuelablePartTransforms(SpecialModels.FUEL_PORT_CLOSED, EntityOffRoader.class, (HashMap<RayTracePart, List<MatrixTransformation>>)offRoaderParts, (List<MatrixTransformation>)offRoaderTransformGlobal);
        EntityRaytracer.createKeyPortTransforms(SpecialModels.KEY_HOLE, EntityOffRoader.class, (HashMap<RayTracePart, List<MatrixTransformation>>)offRoaderParts, (List<MatrixTransformation>)offRoaderTransformGlobal);
        EntityRaytracer.registerEntityStatic(EntityOffRoader.class, offRoaderParts);
        ArrayList tractorTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(tractorTransformGlobal, EntityTractor.class);
        HashMap tractorParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.TRACTOR_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)tractorParts, (List<MatrixTransformation>)tractorTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart(SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)tractorParts, (List<MatrixTransformation>)tractorTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.66, -0.475), MatrixTransformation.createRotation(-67.5, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.02, 0.0), MatrixTransformation.createScale(0.9));
        EntityRaytracer.createFuelablePartTransforms(SpecialModels.FUEL_PORT_CLOSED, EntityTractor.class, (HashMap<RayTracePart, List<MatrixTransformation>>)tractorParts, (List<MatrixTransformation>)tractorTransformGlobal);
        EntityRaytracer.createKeyPortTransforms(SpecialModels.KEY_HOLE, EntityTractor.class, (HashMap<RayTracePart, List<MatrixTransformation>>)tractorParts, (List<MatrixTransformation>)tractorTransformGlobal);
        EntityRaytracer.registerEntityStatic(EntityTractor.class, tractorParts);
        ArrayList miniBusTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(miniBusTransformGlobal, EntityMiniBus.class);
        HashMap miniBusParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.MINI_BUS_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)miniBusParts, (List<MatrixTransformation>)miniBusTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart(SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)miniBusParts, (List<MatrixTransformation>)miniBusTransformGlobal, MatrixTransformation.createTranslation(-0.2825f, 0.225f, 1.0625), MatrixTransformation.createRotation(-67.5, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.02f, 0.0), MatrixTransformation.createScale(0.75));
        EntityRaytracer.createFuelablePartTransforms(SpecialModels.FUEL_PORT_CLOSED, EntityMiniBus.class, (HashMap<RayTracePart, List<MatrixTransformation>>)miniBusParts, (List<MatrixTransformation>)miniBusTransformGlobal);
        EntityRaytracer.createKeyPortTransforms(SpecialModels.KEY_HOLE, EntityMiniBus.class, (HashMap<RayTracePart, List<MatrixTransformation>>)miniBusParts, (List<MatrixTransformation>)miniBusTransformGlobal);
        EntityRaytracer.registerEntityStatic(EntityMiniBus.class, miniBusParts);
        if (Loader.isModLoaded((String)"cfm")) {
            ArrayList bathTransformGlobal = Lists.newArrayList();
            EntityRaytracer.createBodyTransforms(bathTransformGlobal, EntityBath.class);
            HashMap bathParts = Maps.newHashMap();
            EntityRaytracer.createTransformListForPart(Item.func_111206_d((String)"cfm:bath_bottom"), (HashMap<RayTracePart, List<MatrixTransformation>>)bathParts, (List<MatrixTransformation>)bathTransformGlobal, MatrixTransformation.createRotation(90.0, 0.0, 1.0, 0.0));
            EntityRaytracer.registerEntityStatic(EntityBath.class, bathParts);
            ArrayList couchTransformGlobal = Lists.newArrayList();
            EntityRaytracer.createBodyTransforms(couchTransformGlobal, EntityCouch.class);
            HashMap couchParts = Maps.newHashMap();
            EntityRaytracer.createTransformListForPart(Item.func_111206_d((String)"cfm:couch_jeb"), (HashMap<RayTracePart, List<MatrixTransformation>>)couchParts, (List<MatrixTransformation>)couchTransformGlobal, MatrixTransformation.createRotation(90.0, 0.0, 1.0, 0.0), MatrixTransformation.createTranslation(0.0, 0.0625, 0.0));
            EntityRaytracer.registerEntityStatic(EntityCouch.class, couchParts);
            ArrayList sofacopterTransformGlobal = Lists.newArrayList();
            EntityRaytracer.createBodyTransforms(sofacopterTransformGlobal, EntitySofacopter.class);
            HashMap sofacopterParts = Maps.newHashMap();
            EntityRaytracer.createTransformListForPart(Item.func_111206_d((String)"cfm:couch"), (HashMap<RayTracePart, List<MatrixTransformation>>)sofacopterParts, (List<MatrixTransformation>)sofacopterTransformGlobal, MatrixTransformation.createRotation(90.0, 0.0, 1.0, 0.0));
            EntityRaytracer.createTransformListForPart(SpecialModels.COUCH_HELICOPTER_ARM, (HashMap<RayTracePart, List<MatrixTransformation>>)sofacopterParts, (List<MatrixTransformation>)sofacopterTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.5, 0.0));
            EntityRaytracer.createPartTransforms(SpecialModels.FUEL_PORT_CLOSED, EntitySofacopter.FUEL_PORT_POSITION, (HashMap<RayTracePart, List<MatrixTransformation>>)sofacopterParts, (List<MatrixTransformation>)sofacopterTransformGlobal, FUNCTION_FUELING);
            EntityRaytracer.createPartTransforms(SpecialModels.KEY_HOLE, EntitySofacopter.KEY_PORT_POSITION, (HashMap<RayTracePart, List<MatrixTransformation>>)sofacopterParts, (List<MatrixTransformation>)sofacopterTransformGlobal);
            EntityRaytracer.registerEntityStatic(EntitySofacopter.class, sofacopterParts);
        }
        ArrayList trailerVehicleTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(trailerVehicleTransformGlobal, EntityVehicleTrailer.class);
        HashMap trailerVehicleParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.TRAILER_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)trailerVehicleParts, (List<MatrixTransformation>)trailerVehicleTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.registerEntityStatic(EntityVehicleTrailer.class, trailerVehicleParts);
        ArrayList trailerStorageTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(trailerStorageTransformGlobal, EntityStorageTrailer.class);
        HashMap trailerStorageParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.CHEST_TRAILER, (HashMap<RayTracePart, List<MatrixTransformation>>)trailerStorageParts, (List<MatrixTransformation>)trailerStorageTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.registerEntityStatic(EntityStorageTrailer.class, trailerStorageParts);
        ArrayList seederTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(seederTransformGlobal, EntitySeederTrailer.class);
        HashMap seederParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.SEEDER_TRAILER, (HashMap<RayTracePart, List<MatrixTransformation>>)seederParts, (List<MatrixTransformation>)seederTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.registerEntityStatic(EntitySeederTrailer.class, seederParts);
        ArrayList fertilizerTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(fertilizerTransformGlobal, EntityFertilizerTrailer.class);
        HashMap fertilizerParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.FERTILIZER_TRAILER, (HashMap<RayTracePart, List<MatrixTransformation>>)fertilizerParts, (List<MatrixTransformation>)fertilizerTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.registerEntityStatic(EntityFertilizerTrailer.class, fertilizerParts);
        ArrayList trailerFluidTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(trailerFluidTransformGlobal, EntityFluidTrailer.class);
        HashMap trailerFluidParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart(SpecialModels.FLUID_TRAILER, (HashMap<RayTracePart, List<MatrixTransformation>>)trailerFluidParts, (List<MatrixTransformation>)trailerFluidTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.registerEntityStatic(EntityFluidTrailer.class, trailerFluidParts);
    }

    private static void registerEntitiesDynamic() {
    }

    public static ItemStack getNamedPartStack(Item part, String name) {
        ItemStack partStack = new ItemStack(part);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a(PART_NAME, name);
        partStack.func_77982_d(nbt);
        return partStack;
    }

    public static void createBodyTransforms(List<MatrixTransformation> transforms, Class<? extends EntityVehicle> clazz) {
        VehicleProperties properties = VehicleProperties.getProperties(clazz);
        PartPosition bodyPosition = properties.getBodyPosition();
        transforms.add(MatrixTransformation.createRotation(bodyPosition.getRotX(), 1.0, 0.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(bodyPosition.getRotY(), 0.0, 1.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(bodyPosition.getRotZ(), 0.0, 0.0, 1.0));
        transforms.add(MatrixTransformation.createTranslation(bodyPosition.getX(), bodyPosition.getY(), bodyPosition.getZ()));
        transforms.add(MatrixTransformation.createScale(bodyPosition.getScale()));
        transforms.add(MatrixTransformation.createTranslation(0.0, 0.5, 0.0));
        transforms.add(MatrixTransformation.createTranslation(0.0, (double)properties.getAxleOffset() * 0.0625, 0.0));
        transforms.add(MatrixTransformation.createTranslation(0.0, (double)properties.getWheelOffset() * 0.0625, 0.0));
    }

    public static void createPartTransforms(Item part, PartPosition partPosition, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        ArrayList transforms = Lists.newArrayList();
        transforms.addAll(transformsGlobal);
        transforms.add(MatrixTransformation.createTranslation(partPosition.getX() * 0.0625, partPosition.getY() * 0.0625, partPosition.getZ() * 0.0625));
        transforms.add(MatrixTransformation.createTranslation(0.0, -0.5, 0.0));
        transforms.add(MatrixTransformation.createScale(partPosition.getScale()));
        transforms.add(MatrixTransformation.createTranslation(0.0, 0.5, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotX(), 1.0, 0.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotY(), 0.0, 1.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotZ(), 0.0, 0.0, 1.0));
        EntityRaytracer.createTransformListForPart(new ItemStack(part), parts, (List<MatrixTransformation>)transforms, new MatrixTransformation[0]);
    }

    public static void createPartTransforms(SpecialModels model, PartPosition partPosition, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        ArrayList transforms = Lists.newArrayList();
        transforms.addAll(transformsGlobal);
        transforms.add(MatrixTransformation.createTranslation(partPosition.getX() * 0.0625, partPosition.getY() * 0.0625, partPosition.getZ() * 0.0625));
        transforms.add(MatrixTransformation.createTranslation(0.0, -0.5, 0.0));
        transforms.add(MatrixTransformation.createScale(partPosition.getScale()));
        transforms.add(MatrixTransformation.createTranslation(0.0, 0.5, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotX(), 1.0, 0.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotY(), 0.0, 1.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotZ(), 0.0, 0.0, 1.0));
        EntityRaytracer.createTransformListForPart(model, parts, (List<MatrixTransformation>)transforms, new MatrixTransformation[0]);
    }

    public static void createPartTransforms(Item part, PartPosition partPosition, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, Function<RayTraceResultRotated, EnumHand> function) {
        ArrayList transforms = Lists.newArrayList();
        transforms.addAll(transformsGlobal);
        transforms.add(MatrixTransformation.createTranslation(partPosition.getX() * 0.0625, partPosition.getY() * 0.0625, partPosition.getZ() * 0.0625));
        transforms.add(MatrixTransformation.createTranslation(0.0, -0.5, 0.0));
        transforms.add(MatrixTransformation.createScale(partPosition.getScale()));
        transforms.add(MatrixTransformation.createTranslation(0.0, 0.5, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotX(), 1.0, 0.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotY(), 0.0, 1.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotZ(), 0.0, 0.0, 1.0));
        EntityRaytracer.createTransformListForPart(new ItemStack(part), parts, (List<MatrixTransformation>)transforms, function, new MatrixTransformation[0]);
    }

    public static void createPartTransforms(SpecialModels model, PartPosition partPosition, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, Function<RayTraceResultRotated, EnumHand> function) {
        ArrayList transforms = Lists.newArrayList();
        transforms.addAll(transformsGlobal);
        transforms.add(MatrixTransformation.createTranslation(partPosition.getX() * 0.0625, partPosition.getY() * 0.0625, partPosition.getZ() * 0.0625));
        transforms.add(MatrixTransformation.createTranslation(0.0, -0.5, 0.0));
        transforms.add(MatrixTransformation.createScale(partPosition.getScale()));
        transforms.add(MatrixTransformation.createTranslation(0.0, 0.5, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotX(), 1.0, 0.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotY(), 0.0, 1.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotZ(), 0.0, 0.0, 1.0));
        EntityRaytracer.createTransformListForPart(model, parts, (List<MatrixTransformation>)transforms, function, new MatrixTransformation[0]);
    }

    public static void createPartTransforms(double xPixel, double yPixel, double zPixel, Vec3d rotation, double scale, List<MatrixTransformation> transforms) {
        transforms.add(MatrixTransformation.createTranslation(xPixel * 0.0625, yPixel * 0.0625, zPixel * 0.0625));
        transforms.add(MatrixTransformation.createTranslation(0.0, -0.5, 0.0));
        transforms.add(MatrixTransformation.createScale(scale));
        transforms.add(MatrixTransformation.createTranslation(0.0, 0.5, 0.0));
        if (rotation.field_72450_a != 0.0) {
            transforms.add(MatrixTransformation.createRotation(rotation.field_72450_a, 1.0, 0.0, 0.0));
        }
        if (rotation.field_72448_b != 0.0) {
            transforms.add(MatrixTransformation.createRotation(rotation.field_72448_b, 0.0, 1.0, 0.0));
        }
        if (rotation.field_72449_c != 0.0) {
            transforms.add(MatrixTransformation.createRotation(rotation.field_72449_c, 0.0, 0.0, 1.0));
        }
    }

    public static void createFuelablePartTransforms(Item part, double xMeters, double yMeters, double zMeters, double xPixel, double yPixel, double zPixel, Vec3d rotation, double scale, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        ArrayList partTransforms = Lists.newArrayList();
        partTransforms.add(MatrixTransformation.createTranslation(xMeters, yMeters, zMeters));
        EntityRaytracer.createPartTransforms(xPixel, yPixel, zPixel, rotation, scale, partTransforms);
        transformsGlobal.addAll(partTransforms);
        EntityRaytracer.createTransformListForPart(new ItemStack(part), parts, transformsGlobal, FUNCTION_FUELING, new MatrixTransformation[0]);
    }

    public static void createFuelablePartTransforms(Item part, Class<? extends EntityVehicle> clazz, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        PartPosition fuelPortPosition = VehicleProperties.getProperties(clazz).getFuelPortPosition();
        EntityRaytracer.createPartTransforms(part, fuelPortPosition, parts, transformsGlobal, FUNCTION_FUELING);
    }

    public static void createFuelablePartTransforms(SpecialModels model, Class<? extends EntityVehicle> clazz, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        PartPosition fuelPortPosition = VehicleProperties.getProperties(clazz).getFuelPortPosition();
        EntityRaytracer.createPartTransforms(model, fuelPortPosition, parts, transformsGlobal, FUNCTION_FUELING);
    }

    public static void createFuelablePartTransforms(Item part, double xMeters, double yMeters, double zMeters, double xPixel, double yPixel, double zPixel, double rotation, double scale, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        ArrayList partTransforms = Lists.newArrayList();
        partTransforms.add(MatrixTransformation.createTranslation(xMeters, yMeters, zMeters));
        EntityRaytracer.createPartTransforms(xPixel, yPixel, zPixel, new Vec3d(0.0, rotation, 0.0), scale, partTransforms);
        transformsGlobal.addAll(partTransforms);
        EntityRaytracer.createTransformListForPart(new ItemStack(part), parts, transformsGlobal, FUNCTION_FUELING, new MatrixTransformation[0]);
    }

    public static void createKeyPortTransforms(Item part, Class<? extends EntityVehicle> clazz, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        PartPosition keyPortPosition = VehicleProperties.getProperties(clazz).getKeyPortPosition();
        EntityRaytracer.createPartTransforms(part, keyPortPosition, parts, transformsGlobal);
    }

    public static void createKeyPortTransforms(SpecialModels model, Class<? extends EntityVehicle> clazz, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        PartPosition keyPortPosition = VehicleProperties.getProperties(clazz).getKeyPortPosition();
        EntityRaytracer.createPartTransforms(model, keyPortPosition, parts, transformsGlobal);
    }

    public static void createTransformListForPart(ItemStack part, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, @Nullable Function<RayTraceResultRotated, EnumHand> continuousInteraction, MatrixTransformation ... transforms) {
        ArrayList transformsAll = Lists.newArrayList();
        transformsAll.addAll(transformsGlobal);
        transformsAll.addAll(Arrays.asList(transforms));
        parts.put(new RayTracePart<EnumHand>(part, continuousInteraction), transformsAll);
    }

    public static void createTransformListForPart(ItemStack part, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, MatrixTransformation ... transforms) {
        EntityRaytracer.createTransformListForPart(part, parts, transformsGlobal, null, transforms);
    }

    public static void createTransformListForPart(Item part, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, MatrixTransformation ... transforms) {
        EntityRaytracer.createTransformListForPart(new ItemStack(part), parts, transformsGlobal, transforms);
    }

    public static void createTransformListForPart(Item part, HashMap<RayTracePart, List<MatrixTransformation>> parts, MatrixTransformation ... transforms) {
        EntityRaytracer.createTransformListForPart(part, parts, (List<MatrixTransformation>)Lists.newArrayList(), transforms);
    }

    public static void createTransformListForPart(SpecialModels model, HashMap<RayTracePart, List<MatrixTransformation>> parts, MatrixTransformation ... transforms) {
        EntityRaytracer.createTransformListForPart(model, parts, (List<MatrixTransformation>)Lists.newArrayList(), transforms);
    }

    public static void createTransformListForPart(SpecialModels model, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, @Nullable Function<RayTraceResultRotated, EnumHand> continuousInteraction, MatrixTransformation ... transforms) {
        ArrayList transformsAll = Lists.newArrayList();
        transformsAll.addAll(transformsGlobal);
        transformsAll.addAll(Arrays.asList(transforms));
        parts.put(new RayTracePart<EnumHand>(model, continuousInteraction), transformsAll);
    }

    public static void createTransformListForPart(SpecialModels model, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, MatrixTransformation ... transforms) {
        EntityRaytracer.createTransformListForPart(model, parts, transformsGlobal, null, transforms);
    }

    public static void init() {
        EntityRaytracer.clearDataForReregistration();
        EntityRaytracer.registerEntitiesDynamic();
        EntityRaytracer.registerEntitiesStatic();
        for (Class<? extends IEntityRaytraceable> raytraceClass : entityRaytraceTriangles.keySet()) {
            if (entityRaytraceSuperclass != null) {
                Class<? extends IEntityRaytraceable> nearestSuperclass = raytraceClass;
                while (!nearestSuperclass.isAssignableFrom(entityRaytraceSuperclass) && (nearestSuperclass = nearestSuperclass.getSuperclass()) != Entity.class) {
                }
                entityRaytraceSuperclass = nearestSuperclass;
            } else {
                entityRaytraceSuperclass = raytraceClass;
            }
            float min = 0.0f;
            float max = 0.0f;
            Entity entity = EntityList.func_191304_a(raytraceClass, (World)Minecraft.func_71410_x().field_71441_e);
            for (Map.Entry<RayTracePart, TriangleRayTraceList> entry : entityRaytraceTriangles.get(raytraceClass).entrySet()) {
                for (TriangleRayTrace triangle : entity == null ? entry.getValue().getTriangles() : entry.getValue().getTriangles(entry.getKey(), entity)) {
                    float[] data = triangle.getData();
                    for (int i = 0; i < data.length; i += 3) {
                        float x = data[i];
                        float y = data[i + 1];
                        float z = data[i + 2];
                        if (x < min) {
                            min = x;
                        }
                        if (y < min) {
                            min = y;
                        }
                        if (z < min) {
                            min = z;
                        }
                        if (x > max) {
                            max = x;
                        }
                        if (y > max) {
                            max = y;
                        }
                        if (!(z > max)) continue;
                        max = z;
                    }
                }
            }
            float range = max - min;
            entityCrateScalesAndOffsets.put(raytraceClass, (Pair<Float, Float>)new ImmutablePair((Object)Float.valueOf(1.0f / (range * 1.25f)), (Object)Float.valueOf(-(min + range * 0.5f))));
        }
        initialized = true;
    }

    private static void registerEntityStatic(Class<? extends IEntityRaytraceable> raytraceClass, Map<RayTracePart, List<MatrixTransformation>> transforms) {
        HashMap partTriangles = Maps.newHashMap();
        for (Map.Entry<RayTracePart, List<MatrixTransformation>> entryPart : transforms.entrySet()) {
            RayTracePart part = entryPart.getKey();
            Matrix4d matrix = new Matrix4d();
            matrix.setIdentity();
            for (MatrixTransformation tranform : entryPart.getValue()) {
                tranform.transform(matrix);
            }
            EntityRaytracer.finalizePartStackMatrix(matrix);
            partTriangles.put(part, new TriangleRayTraceList(EntityRaytracer.generateTriangles(EntityRaytracer.getModel(part), matrix)));
        }
        entityRaytraceTrianglesStatic.put(raytraceClass, partTriangles);
        HashMap<RayTracePart, TriangleRayTraceList> partTrianglesCopy = new HashMap<RayTracePart, TriangleRayTraceList>(partTriangles);
        Map<RayTracePart, TriangleRayTraceList> partTrianglesAll = entityRaytraceTriangles.get(raytraceClass);
        if (partTrianglesAll != null) {
            partTrianglesCopy.putAll(partTrianglesAll);
        }
        entityRaytraceTriangles.put(raytraceClass, partTrianglesCopy);
    }

    private static void registerEntityDynamic(Class<? extends IEntityRaytraceable> raytraceClass, Map<RayTracePart, BiFunction<RayTracePart, Entity, Matrix4d>> matrixFactories) {
        HashMap partTriangles = Maps.newHashMap();
        for (Map.Entry<RayTracePart, BiFunction<RayTracePart, Entity, Matrix4d>> entryPart : matrixFactories.entrySet()) {
            RayTracePart part = entryPart.getKey();
            partTriangles.put(part, new TriangleRayTraceList(EntityRaytracer.generateTriangles(EntityRaytracer.getModel(part), null), entryPart.getValue()));
        }
        entityRaytraceTrianglesDynamic.put(raytraceClass, partTriangles);
        entityRaytraceTriangles.put(raytraceClass, partTriangles);
    }

    public static Pair<Float, Float> getCrateScaleAndOffset(Class<? extends Entity> raytraceClass) {
        Pair<Float, Float> scaleAndOffset = entityCrateScalesAndOffsets.get(raytraceClass);
        return scaleAndOffset == null ? SCALE_AND_OFFSET_DEFAULT : scaleAndOffset;
    }

    private static IBakedModel getModel(RayTracePart part) {
        if (part.model != null) {
            return part.model.getModel();
        }
        return Minecraft.func_71410_x().func_175599_af().func_184393_a(part.partStack, null, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
    }

    private static List<TriangleRayTrace> generateTriangles(IBakedModel model, @Nullable Matrix4d matrix) {
        ArrayList triangles = Lists.newArrayList();
        try {
            EntityRaytracer.generateTriangles(model.func_188616_a(null, null, 0L), matrix, triangles);
            for (EnumFacing facing : EnumFacing.values()) {
                EntityRaytracer.generateTriangles(model.func_188616_a(null, facing, 0L), matrix, triangles);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return triangles;
    }

    private static void generateTriangles(List<BakedQuad> list, @Nullable Matrix4d matrix, List<TriangleRayTrace> triangles) {
        for (BakedQuad quad : list) {
            int size = quad.getFormat().func_181719_f();
            int[] data = quad.func_178209_a();
            float[] triangle1 = new float[9];
            float[] triangle2 = new float[9];
            triangle1[0] = Float.intBitsToFloat(data[0]);
            triangle1[1] = Float.intBitsToFloat(data[1]);
            triangle1[2] = Float.intBitsToFloat(data[2]);
            triangle1[3] = triangle2[6] = Float.intBitsToFloat(data[size]);
            triangle1[4] = triangle2[7] = Float.intBitsToFloat(data[size + 1]);
            triangle1[5] = triangle2[8] = Float.intBitsToFloat(data[size + 2]);
            triangle2[0] = Float.intBitsToFloat(data[size *= 2]);
            triangle2[1] = Float.intBitsToFloat(data[size + 1]);
            triangle2[2] = Float.intBitsToFloat(data[size + 2]);
            size = (int)((double)size * 1.5);
            triangle1[6] = triangle2[3] = Float.intBitsToFloat(data[size]);
            triangle1[7] = triangle2[4] = Float.intBitsToFloat(data[size + 1]);
            triangle1[8] = triangle2[5] = Float.intBitsToFloat(data[size + 2]);
            EntityRaytracer.transformTriangleAndAdd(triangle1, matrix, triangles);
            EntityRaytracer.transformTriangleAndAdd(triangle2, matrix, triangles);
        }
    }

    private static void transformTriangleAndAdd(float[] triangle, @Nullable Matrix4d matrix, List<TriangleRayTrace> triangles) {
        triangles.add(new TriangleRayTrace(matrix != null ? EntityRaytracer.getTransformedTriangle(triangle, matrix) : triangle));
    }

    private static float[] getTransformedTriangle(float[] triangle, Matrix4d matrix) {
        float[] triangleNew = new float[9];
        for (int i = 0; i < 9; i += 3) {
            Vector4d vec = new Vector4d((double)triangle[i], (double)triangle[i + 1], (double)triangle[i + 2], 1.0);
            matrix.transform((Tuple4d)vec);
            triangleNew[i] = (float)vec.x;
            triangleNew[i + 1] = (float)vec.y;
            triangleNew[i + 2] = (float)vec.z;
        }
        return triangleNew;
    }

    public static void finalizePartStackMatrix(Matrix4d matrix) {
        MatrixTransformation.createTranslation(-0.5, -0.5, -0.5).transform(matrix);
    }

    public static void interactWithEntity(IEntityRaytraceable entity, RayTraceResult result) {
        Minecraft.func_71410_x().field_71442_b.func_187097_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (Entity)entity, EnumHand.MAIN_HAND);
        Minecraft.func_71410_x().field_71442_b.func_187102_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (Entity)entity, result, EnumHand.MAIN_HAND);
    }

    @SubscribeEvent
    public static void raytraceEntitiesContinuously(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if ((!initialized || VehicleConfig.CLIENT.debug.reloadRaytracerEachTick) && Minecraft.func_71410_x().field_71441_e != null) {
            EntityRaytracer.init();
        }
        if (continuousInteraction == null || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        RayTraceResultRotated result = EntityRaytracer.raytraceEntities(continuousInteraction.isRightClick());
        if (result == null || result.field_72308_g != EntityRaytracer.continuousInteraction.field_72308_g || result.getPartHit() != continuousInteraction.getPartHit()) {
            continuousInteraction = null;
            continuousInteractionTickCounter = 0;
            return;
        }
        continuousInteractionObject = result.performContinuousInteraction();
        if (continuousInteractionObject == null) {
            continuousInteraction = null;
            continuousInteractionTickCounter = 0;
        } else {
            ++continuousInteractionTickCounter;
        }
    }

    @SubscribeEvent
    public static void onMouseEvent(MouseEvent event) {
        boolean rightClick;
        boolean bl = rightClick = Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151463_i() + 100 == event.getButton();
        if (!((rightClick || VehicleConfig.CLIENT.interaction.enabledLeftClick && Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151463_i() + 100 == event.getButton()) && event.isButtonstate())) {
            return;
        }
        if (EntityRaytracer.performRayTrace(rightClick)) {
            event.setCanceled(true);
        }
    }

    public static boolean performRayTrace(boolean rightClick) {
        if (entityRaytraceSuperclass == null) {
            return false;
        }
        RayTraceResultRotated result = EntityRaytracer.raytraceEntities(rightClick);
        if (result != null) {
            continuousInteractionObject = result.performContinuousInteraction();
            if (continuousInteractionObject != null) {
                continuousInteraction = result;
                continuousInteractionTickCounter = 1;
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static RayTraceResultRotated raytraceEntities(boolean rightClick) {
        double eyeDistance;
        float reach = Minecraft.func_71410_x().field_71442_b.func_78757_d();
        Vec3d eyeVec = Minecraft.func_71410_x().field_71439_g.func_174824_e(1.0f);
        Vec3d forwardVec = eyeVec.func_178787_e(Minecraft.func_71410_x().field_71439_g.func_70676_i(1.0f).func_186678_a((double)reach));
        AxisAlignedBB box = new AxisAlignedBB(eyeVec, eyeVec).func_186662_g((double)reach);
        RayTraceResultRotated lookObject = null;
        double distanceShortest = Double.MAX_VALUE;
        for (Entity entity : Minecraft.func_71410_x().field_71441_e.func_72872_a(entityRaytraceSuperclass, box)) {
            double distance;
            RayTraceResultRotated lookObjectPutative;
            if (!entityRaytraceTrianglesDynamic.keySet().contains(entity.getClass()) && !entityRaytraceTrianglesStatic.keySet().contains(entity.getClass()) || (lookObjectPutative = EntityRaytracer.rayTraceEntityRotated((IEntityRaytraceable)entity, eyeVec, forwardVec, reach, rightClick)) == null || !((distance = lookObjectPutative.getDistanceToEyes()) < distanceShortest)) continue;
            lookObject = lookObjectPutative;
            distanceShortest = distance;
        }
        if (lookObject != null && (eyeDistance = lookObject.getDistanceToEyes()) <= (double)reach) {
            Vec3d hit = forwardVec;
            RayTraceResult lookObjectMC = Minecraft.func_71410_x().field_71476_x;
            boolean bypass = entityRaytraceTrianglesStatic.keySet().contains(lookObject.field_72308_g.getClass());
            if (bypass && lookObjectMC != null && lookObjectMC.field_72313_a != RayTraceResult.Type.MISS) {
                AxisAlignedBB boxMC = lookObjectMC.field_72313_a == RayTraceResult.Type.ENTITY ? lookObjectMC.field_72308_g.func_174813_aQ() : lookObject.field_72308_g.field_70170_p.func_180495_p(lookObjectMC.func_178782_a()).func_185900_c((IBlockAccess)lookObject.field_72308_g.field_70170_p, lookObjectMC.func_178782_a());
                boolean bl = bypass = boxMC != null && boxMC.func_72318_a(eyeVec);
            }
            if (!bypass && lookObjectMC != null && lookObjectMC.field_72313_a != RayTraceResult.Type.MISS) {
                if (lookObjectMC.field_72313_a == RayTraceResult.Type.ENTITY && lookObjectMC.field_72308_g == lookObject.field_72308_g) {
                    bypass = true;
                } else {
                    hit = lookObjectMC.field_72307_f;
                }
            }
            if ((bypass || eyeDistance < hit.func_72438_d(eyeVec)) && ((IEntityRaytraceable)lookObject.field_72308_g).processHit(lookObject, rightClick)) {
                return lookObject;
            }
        }
        return null;
    }

    @Nullable
    public static RayTraceResultRotated rayTraceEntityRotated(IEntityRaytraceable boxProvider, Vec3d eyeVec, Vec3d forwardVec, double reach, boolean rightClick) {
        boolean isDynamic;
        Entity entity = (Entity)boxProvider;
        Vec3d pos = entity.func_174791_d();
        double angle = Math.toRadians(-entity.field_70177_z);
        Vec3d eyeVecRotated = EntityRaytracer.rotateVecXZ(eyeVec, angle, pos);
        Vec3d forwardVecRotated = EntityRaytracer.rotateVecXZ(forwardVec, angle, pos);
        float[] eyes = new float[]{(float)eyeVecRotated.field_72450_a, (float)eyeVecRotated.field_72448_b, (float)eyeVecRotated.field_72449_c};
        Vec3d look = forwardVecRotated.func_178788_d(eyeVecRotated).func_72432_b().func_186678_a(reach);
        float[] direction = new float[]{(float)look.field_72450_a, (float)look.field_72448_b, (float)look.field_72449_c};
        RayTraceResultTriangle lookBox = null;
        RayTraceResultTriangle lookPart = null;
        double distanceShortest = Double.MAX_VALUE;
        List<RayTracePart> boxesApplicable = boxProvider.getApplicableInteractionBoxes();
        List<RayTracePart> partsNonApplicable = boxProvider.getNonApplicableParts();
        lookBox = EntityRaytracer.raytracePartTriangles(entity, pos, eyeVecRotated, lookBox, distanceShortest, eyes, direction, boxesApplicable, false, boxProvider.getDynamicInteractionBoxMap());
        distanceShortest = EntityRaytracer.updateShortestDistance(lookBox, distanceShortest);
        lookPart = EntityRaytracer.raytracePartTriangles(entity, pos, eyeVecRotated, lookPart, distanceShortest, eyes, direction, partsNonApplicable, true, entityRaytraceTrianglesDynamic.get(entity.getClass()));
        distanceShortest = EntityRaytracer.updateShortestDistance(lookPart, distanceShortest);
        boolean bl = isDynamic = lookBox != null || lookPart != null;
        if (!isDynamic) {
            lookBox = EntityRaytracer.raytracePartTriangles(entity, pos, eyeVecRotated, lookBox, distanceShortest, eyes, direction, boxesApplicable, false, boxProvider.getStaticInteractionBoxMap());
            distanceShortest = EntityRaytracer.updateShortestDistance(lookBox, distanceShortest);
            lookPart = EntityRaytracer.raytracePartTriangles(entity, pos, eyeVecRotated, lookPart, distanceShortest, eyes, direction, partsNonApplicable, true, entityRaytraceTrianglesStatic.get(entity.getClass()));
        }
        if (lookPart != null) {
            return new RayTraceResultRotated(entity, EntityRaytracer.rotateVecXZ(lookPart.getHit(), -angle, pos), lookPart.getDistance(), lookPart.getPart(), rightClick);
        }
        return lookBox == null ? null : new RayTraceResultRotated(entity, EntityRaytracer.rotateVecXZ(lookBox.getHit(), -angle, pos), lookBox.getDistance(), lookBox.getPart(), rightClick);
    }

    private static double updateShortestDistance(RayTraceResultTriangle lookObject, double distanceShortest) {
        if (lookObject != null) {
            distanceShortest = lookObject.getDistance();
        }
        return distanceShortest;
    }

    private static RayTraceResultTriangle raytracePartTriangles(Entity entity, Vec3d pos, Vec3d eyeVecRotated, RayTraceResultTriangle lookPart, double distanceShortest, float[] eyes, float[] direction, @Nullable List<RayTracePart> partsApplicable, boolean invalidateParts, Map<RayTracePart, TriangleRayTraceList> parts) {
        if (parts != null) {
            for (Map.Entry<RayTracePart, TriangleRayTraceList> entry : parts.entrySet()) {
                if (partsApplicable != null && invalidateParts == partsApplicable.contains(entry.getKey())) continue;
                RayTracePart part = entry.getKey();
                for (TriangleRayTrace triangle : entry.getValue().getTriangles(part, entity)) {
                    double distance;
                    RayTraceResultTriangle lookObjectPutative = RayTraceResultTriangle.calculateIntercept(eyes, direction, pos, triangle.getData(), part);
                    if (lookObjectPutative == null || !((distance = lookObjectPutative.calculateAndSaveDistance(eyeVecRotated)) < distanceShortest)) continue;
                    lookPart = lookObjectPutative;
                    distanceShortest = distance;
                }
            }
        }
        return lookPart;
    }

    private static Vec3d rotateVecXZ(Vec3d vec, double angle, Vec3d rotationPoint) {
        double x = rotationPoint.field_72450_a + Math.cos(angle) * (vec.field_72450_a - rotationPoint.field_72450_a) - Math.sin(angle) * (vec.field_72449_c - rotationPoint.field_72449_c);
        double z = rotationPoint.field_72449_c + Math.sin(angle) * (vec.field_72450_a - rotationPoint.field_72450_a) + Math.cos(angle) * (vec.field_72449_c - rotationPoint.field_72449_c);
        return new Vec3d(x, vec.field_72448_b, z);
    }

    public static void renderRaytraceElements(IEntityRaytraceable entity, double x, double y, double z, float yaw) {
        if (VehicleConfig.CLIENT.debug.renderOutlines) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            EntityRaytracer.renderRaytraceTriangles(entity, tessellator, buffer, entityRaytraceTrianglesStatic);
            EntityRaytracer.renderRaytraceTriangles(entity, tessellator, buffer, entityRaytraceTrianglesDynamic);
            entity.drawInteractionBoxes(tessellator, buffer);
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private static void renderRaytraceTriangles(IEntityRaytraceable entity, Tessellator tessellator, BufferBuilder buffer, Map<Class<? extends IEntityRaytraceable>, Map<RayTracePart, TriangleRayTraceList>> entityTriangles) {
        Map<RayTracePart, TriangleRayTraceList> map = entityTriangles.get(entity.getClass());
        if (map != null) {
            List<RayTracePart> partsNonApplicable = entity.getNonApplicableParts();
            for (Map.Entry<RayTracePart, TriangleRayTraceList> entry : map.entrySet()) {
                if (partsNonApplicable != null && partsNonApplicable.contains(entry.getKey())) continue;
                for (TriangleRayTrace triangle : entry.getValue().getTriangles(entry.getKey(), (Entity)entity)) {
                    triangle.draw(tessellator, buffer, 1.0f, 0.0f, 0.0f, 0.4f);
                }
            }
        }
    }

    public static TriangleRayTraceList boxToTriangles(AxisAlignedBB box, @Nullable BiFunction<RayTracePart, Entity, Matrix4d> matrixFactory) {
        ArrayList triangles = Lists.newArrayList();
        EntityRaytracer.getTranglesFromQuadAndAdd(triangles, box.field_72340_a, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72338_b, box.field_72339_c, box.field_72340_a, box.field_72338_b, box.field_72339_c);
        EntityRaytracer.getTranglesFromQuadAndAdd(triangles, box.field_72336_d, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f, box.field_72336_d, box.field_72338_b, box.field_72334_f, box.field_72336_d, box.field_72338_b, box.field_72339_c);
        EntityRaytracer.getTranglesFromQuadAndAdd(triangles, box.field_72336_d, box.field_72337_e, box.field_72334_f, box.field_72340_a, box.field_72337_e, box.field_72334_f, box.field_72340_a, box.field_72338_b, box.field_72334_f, box.field_72336_d, box.field_72338_b, box.field_72334_f);
        EntityRaytracer.getTranglesFromQuadAndAdd(triangles, box.field_72340_a, box.field_72337_e, box.field_72334_f, box.field_72340_a, box.field_72337_e, box.field_72339_c, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72340_a, box.field_72338_b, box.field_72334_f);
        EntityRaytracer.getTranglesFromQuadAndAdd(triangles, box.field_72340_a, box.field_72337_e, box.field_72334_f, box.field_72336_d, box.field_72337_e, box.field_72334_f, box.field_72336_d, box.field_72337_e, box.field_72339_c, box.field_72340_a, box.field_72337_e, box.field_72339_c);
        EntityRaytracer.getTranglesFromQuadAndAdd(triangles, box.field_72336_d, box.field_72338_b, box.field_72334_f, box.field_72340_a, box.field_72338_b, box.field_72334_f, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72338_b, box.field_72339_c);
        return new TriangleRayTraceList(triangles, matrixFactory);
    }

    public static TriangleRayTraceList boxToTriangles(AxisAlignedBB box) {
        return EntityRaytracer.boxToTriangles(box, null);
    }

    private static void getTranglesFromQuadAndAdd(List<TriangleRayTrace> triangles, double ... data) {
        int size = 3;
        float[] triangle1 = new float[9];
        float[] triangle2 = new float[9];
        triangle1[0] = (float)data[0];
        triangle1[1] = (float)data[1];
        triangle1[2] = (float)data[2];
        triangle1[3] = triangle2[6] = (float)data[size];
        triangle1[4] = triangle2[7] = (float)data[size + 1];
        triangle1[5] = triangle2[8] = (float)data[size + 2];
        triangle2[0] = (float)data[size *= 2];
        triangle2[1] = (float)data[size + 1];
        triangle2[2] = (float)data[size + 2];
        size = (int)((double)size * 1.5);
        triangle1[6] = triangle2[3] = (float)data[size];
        triangle1[7] = triangle2[4] = (float)data[size + 1];
        triangle1[8] = triangle2[5] = (float)data[size + 2];
        EntityRaytracer.transformTriangleAndAdd(triangle1, null, triangles);
        EntityRaytracer.transformTriangleAndAdd(triangle2, null, triangles);
    }

    static {
        entityRaytraceTrianglesStatic = Maps.newHashMap();
        entityRaytraceTrianglesDynamic = Maps.newHashMap();
        entityRaytraceTriangles = new HashMap<Class<? extends IEntityRaytraceable>, Map<RayTracePart, TriangleRayTraceList>>();
        entityCrateScalesAndOffsets = new HashMap<Class<? extends Entity>, Pair<Float, Float>>();
        SCALE_AND_OFFSET_DEFAULT = new ImmutablePair((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.0f));
        FUNCTION_FUELING = rayTraceResult -> {
            EntityPoweredVehicle poweredVehicle;
            Entity entity;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (((Optional)player.func_184212_Q().func_187225_a(CommonEvents.GAS_PUMP)).isPresent() && ControllerEvents.isRightClicking() && (entity = rayTraceResult.field_72308_g) instanceof EntityPoweredVehicle && (poweredVehicle = (EntityPoweredVehicle)entity).requiresFuel() && poweredVehicle.getCurrentFuel() < poweredVehicle.getFuelCapacity()) {
                if (continuousInteractionTickCounter % 2 == 0) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new MessageFuelVehicle((EntityPlayer)Minecraft.func_71410_x().field_71439_g, EnumHand.MAIN_HAND, rayTraceResult.field_72308_g));
                }
                return EnumHand.MAIN_HAND;
            }
            for (EnumHand hand : EnumHand.values()) {
                int fuel;
                EntityPoweredVehicle poweredVehicle2;
                Entity entity2;
                ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184586_b(hand);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemJerryCan) || !ControllerEvents.isRightClicking() || !((entity2 = rayTraceResult.field_72308_g) instanceof EntityPoweredVehicle) || !(poweredVehicle2 = (EntityPoweredVehicle)entity2).requiresFuel() || !(poweredVehicle2.getCurrentFuel() < poweredVehicle2.getFuelCapacity()) || (fuel = ((ItemJerryCan)stack.func_77973_b()).getCurrentFuel(stack)) <= 0) continue;
                if (continuousInteractionTickCounter % 2 == 0) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new MessageFuelVehicle((EntityPlayer)Minecraft.func_71410_x().field_71439_g, hand, entity2));
                }
                return hand;
            }
            return null;
        };
    }

    public static interface IEntityRaytraceable {
        @SideOnly(value=Side.CLIENT)
        default public boolean processHit(RayTraceResultRotated result, boolean rightClick) {
            boolean isContinuous;
            SpecialModels model = result.getPartHit().model;
            if (model == SpecialModels.KEY_HOLE) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageInteractKey((Entity)this));
                return true;
            }
            boolean bl = isContinuous = result.partHit.getContinuousInteraction() != null;
            if (isContinuous || Minecraft.func_71410_x().field_71476_x == null || Minecraft.func_71410_x().field_71476_x.field_72308_g != this) {
                boolean notRiding;
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                boolean bl2 = notRiding = player.func_184187_bx() != this;
                if (!rightClick && notRiding) {
                    Minecraft.func_71410_x().field_71442_b.func_78764_a((EntityPlayer)player, (Entity)this);
                    return true;
                }
                ItemStack stack = result.getPartHit().getStack();
                if (!stack.func_190926_b() || result.getPartHit().model != null) {
                    if (notRiding) {
                        if (player.func_70093_af() && !player.func_175149_v()) {
                            PacketHandler.INSTANCE.sendToServer((IMessage)new MessagePickupVehicle((Entity)this));
                            return true;
                        }
                        if (!isContinuous) {
                            EntityRaytracer.interactWithEntity(this, result);
                        }
                    }
                    return notRiding;
                }
            }
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        default public Map<RayTracePart, TriangleRayTraceList> getStaticInteractionBoxMap() {
            return Maps.newHashMap();
        }

        @SideOnly(value=Side.CLIENT)
        default public Map<RayTracePart, TriangleRayTraceList> getDynamicInteractionBoxMap() {
            return Maps.newHashMap();
        }

        @Nullable
        @SideOnly(value=Side.CLIENT)
        default public List<RayTracePart> getApplicableInteractionBoxes() {
            return null;
        }

        @Nullable
        @SideOnly(value=Side.CLIENT)
        default public List<RayTracePart> getNonApplicableParts() {
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        default public void drawInteractionBoxes(Tessellator tessellator, BufferBuilder buffer) {
        }
    }

    public static class RayTraceResultRotated
    extends RayTraceResult {
        private final RayTracePart partHit;
        private final double distanceToEyes;
        private final boolean rightClick;

        private RayTraceResultRotated(Entity entityHit, Vec3d hitVec, double distanceToEyes, RayTracePart partHit, boolean rightClick) {
            super(entityHit, hitVec);
            this.distanceToEyes = distanceToEyes;
            this.partHit = partHit;
            this.rightClick = rightClick;
        }

        public RayTracePart getPartHit() {
            return this.partHit;
        }

        public double getDistanceToEyes() {
            return this.distanceToEyes;
        }

        public boolean isRightClick() {
            return this.rightClick;
        }

        public Object performContinuousInteraction() {
            return this.partHit.getContinuousInteraction() == null ? null : this.partHit.getContinuousInteraction().apply(this);
        }

        public <R> boolean equalsContinuousInteraction(Function<RayTraceResultRotated, R> function) {
            return function.equals(this.partHit.getContinuousInteraction());
        }
    }

    public static class RayTracePart<R> {
        private final ItemStack partStack;
        private final AxisAlignedBB partBox;
        private final SpecialModels model;
        private final Function<RayTraceResultRotated, R> continuousInteraction;

        public RayTracePart(ItemStack partStack, @Nullable Function<RayTraceResultRotated, R> continuousInteraction) {
            this(partStack, null, null, continuousInteraction);
        }

        public RayTracePart(AxisAlignedBB partBox, @Nullable Function<RayTraceResultRotated, R> continuousInteraction) {
            this(ItemStack.field_190927_a, partBox, null, continuousInteraction);
        }

        public RayTracePart(SpecialModels model, @Nullable Function<RayTraceResultRotated, R> continuousInteraction) {
            this(ItemStack.field_190927_a, null, model, continuousInteraction);
        }

        public RayTracePart(AxisAlignedBB partBox) {
            this(ItemStack.field_190927_a, partBox, null, null);
        }

        private RayTracePart(ItemStack partStack, @Nullable AxisAlignedBB partBox, @Nullable SpecialModels model, @Nullable Function<RayTraceResultRotated, R> continuousInteraction) {
            this.partStack = partStack;
            this.partBox = partBox;
            this.model = model;
            this.continuousInteraction = continuousInteraction;
        }

        public ItemStack getStack() {
            return this.partStack;
        }

        @Nullable
        public AxisAlignedBB getBox() {
            return this.partBox;
        }

        @Nullable
        public SpecialModels getModel() {
            return this.model;
        }

        public Function<RayTraceResultRotated, R> getContinuousInteraction() {
            return this.continuousInteraction;
        }
    }

    private static class RayTraceResultTriangle {
        private static final float EPSILON = 1.0E-6f;
        private final float x;
        private final float y;
        private final float z;
        private final RayTracePart part;
        private double distance;

        public RayTraceResultTriangle(RayTracePart part, float x, float y, float z) {
            this.part = part;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vec3d getHit() {
            return new Vec3d((double)this.x, (double)this.y, (double)this.z);
        }

        public RayTracePart getPart() {
            return this.part;
        }

        public double calculateAndSaveDistance(Vec3d eyeVec) {
            this.distance = eyeVec.func_72438_d(this.getHit());
            return this.distance;
        }

        public double getDistance() {
            return this.distance;
        }

        public static RayTraceResultTriangle calculateIntercept(float[] eyes, float[] direction, Vec3d posEntity, float[] data, RayTracePart part) {
            float[] vec0 = new float[]{data[0] + (float)posEntity.field_72450_a, data[1] + (float)posEntity.field_72448_b, data[2] + (float)posEntity.field_72449_c};
            float[] vec1 = new float[]{data[3] + (float)posEntity.field_72450_a, data[4] + (float)posEntity.field_72448_b, data[5] + (float)posEntity.field_72449_c};
            float[] vec2 = new float[]{data[6] + (float)posEntity.field_72450_a, data[7] + (float)posEntity.field_72448_b, data[8] + (float)posEntity.field_72449_c};
            float[] edge1 = new float[3];
            float[] edge2 = new float[3];
            float[] tvec = new float[3];
            float[] pvec = new float[3];
            float[] qvec = new float[3];
            RayTraceResultTriangle.subtract(edge1, vec1, vec0);
            RayTraceResultTriangle.subtract(edge2, vec2, vec0);
            RayTraceResultTriangle.crossProduct(pvec, direction, edge2);
            float det = RayTraceResultTriangle.dotProduct(edge1, pvec);
            if (det <= -1.0E-6f || det >= 1.0E-6f) {
                float inv_det = 1.0f / det;
                RayTraceResultTriangle.subtract(tvec, eyes, vec0);
                float u = RayTraceResultTriangle.dotProduct(tvec, pvec) * inv_det;
                if (u >= 0.0f && u <= 1.0f) {
                    RayTraceResultTriangle.crossProduct(qvec, tvec, edge1);
                    float v = RayTraceResultTriangle.dotProduct(direction, qvec) * inv_det;
                    if (v >= 0.0f && u + v <= 1.0f && inv_det * RayTraceResultTriangle.dotProduct(edge2, qvec) > 1.0E-6f) {
                        return new RayTraceResultTriangle(part, edge1[0] * u + edge2[0] * v + vec0[0], edge1[1] * u + edge2[1] * v + vec0[1], edge1[2] * u + edge2[2] * v + vec0[2]);
                    }
                }
            }
            return null;
        }

        private static void crossProduct(float[] result, float[] v1, float[] v2) {
            result[0] = v1[1] * v2[2] - v1[2] * v2[1];
            result[1] = v1[2] * v2[0] - v1[0] * v2[2];
            result[2] = v1[0] * v2[1] - v1[1] * v2[0];
        }

        private static float dotProduct(float[] v1, float[] v2) {
            return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
        }

        private static void subtract(float[] result, float[] v1, float[] v2) {
            result[0] = v1[0] - v2[0];
            result[1] = v1[1] - v2[1];
            result[2] = v1[2] - v2[2];
        }
    }

    public static class TriangleRayTraceList {
        private final List<TriangleRayTrace> triangles;
        private final BiFunction<RayTracePart, Entity, Matrix4d> matrixFactory;

        public TriangleRayTraceList(List<TriangleRayTrace> triangles) {
            this(triangles, null);
        }

        public TriangleRayTraceList(List<TriangleRayTrace> triangles, @Nullable BiFunction<RayTracePart, Entity, Matrix4d> matrixFactory) {
            this.triangles = triangles;
            this.matrixFactory = matrixFactory;
        }

        public List<TriangleRayTrace> getTriangles(RayTracePart part, Entity entity) {
            if (this.matrixFactory != null) {
                ArrayList triangles = Lists.newArrayList();
                Matrix4d matrix = this.matrixFactory.apply(part, entity);
                for (TriangleRayTrace triangle : this.triangles) {
                    triangles.add(new TriangleRayTrace(EntityRaytracer.getTransformedTriangle(triangle.getData(), matrix)));
                }
                return triangles;
            }
            return this.triangles;
        }

        public List<TriangleRayTrace> getTriangles() {
            return this.triangles;
        }
    }

    public static class TriangleRayTrace {
        private final float[] data;

        public TriangleRayTrace(float[] data) {
            this.data = data;
        }

        public float[] getData() {
            return this.data;
        }

        public void draw(Tessellator tessellator, BufferBuilder buffer, float red, float green, float blue, float alpha) {
            buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b((double)this.data[6], (double)this.data[7], (double)this.data[8]).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b((double)this.data[0], (double)this.data[1], (double)this.data[2]).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b((double)this.data[3], (double)this.data[4], (double)this.data[5]).func_181666_a(red, green, blue, alpha).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    public static class MatrixTransformation {
        private final MatrixTransformationType type;
        private double x;
        private double y;
        private double z;
        private double angle;

        public MatrixTransformation(MatrixTransformationType type, double x, double y, double z) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public MatrixTransformation(MatrixTransformationType type, double x, double y, double z, double angle) {
            this(type, x, y, z);
            this.angle = angle;
        }

        public static MatrixTransformation createTranslation(double x, double y, double z) {
            return new MatrixTransformation(MatrixTransformationType.TRANSLATION, x, y, z);
        }

        public static MatrixTransformation createRotation(double angle, double x, double y, double z) {
            return new MatrixTransformation(MatrixTransformationType.ROTATION, x, y, z, angle);
        }

        public static MatrixTransformation createScale(double x, double y, double z) {
            return new MatrixTransformation(MatrixTransformationType.SCALE, x, y, z);
        }

        public static MatrixTransformation createScale(double xyz) {
            return new MatrixTransformation(MatrixTransformationType.SCALE, xyz, xyz, xyz);
        }

        public void transform(Matrix4d matrix) {
            Matrix4d temp = new Matrix4d();
            switch (this.type) {
                case ROTATION: {
                    temp.set(new AxisAngle4d(this.x, this.y, this.z, (double)((float)Math.toRadians(this.angle))));
                    break;
                }
                case TRANSLATION: {
                    temp.set(new Vector3d(this.x, this.y, this.z));
                    break;
                }
                case SCALE: {
                    Vector3d scaleVec = new Vector3d(this.x, this.y, this.z);
                    temp.setIdentity();
                    temp.m00 = scaleVec.x;
                    temp.m11 = scaleVec.y;
                    temp.m22 = scaleVec.z;
                }
            }
            matrix.mul(temp);
        }

        private static enum MatrixTransformationType {
            TRANSLATION,
            ROTATION,
            SCALE;

        }
    }
}

