/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.util.RenderUtil;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;

public class RenderVehicleWrapper<T extends EntityVehicle, R extends AbstractRenderVehicle<T>> {
    protected final R renderVehicle;

    public RenderVehicleWrapper(R renderVehicle) {
        this.renderVehicle = renderVehicle;
    }

    public R getRenderVehicle() {
        return this.renderVehicle;
    }

    public void render(T entity, float partialTicks) {
        if (((EntityVehicle)((Object)entity)).field_70128_L) {
            return;
        }
        GlStateManager.func_179094_E();
        VehicleProperties properties = ((EntityVehicle)((Object)entity)).getProperties();
        PartPosition bodyPosition = properties.getBodyPosition();
        GlStateManager.func_179114_b((float)((float)bodyPosition.getRotX()), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)bodyPosition.getRotY()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)bodyPosition.getRotZ()), (float)0.0f, (float)0.0f, (float)1.0f);
        if (((EntityVehicle)((Object)entity)).canTowTrailer()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Vec3d towBarOffset = properties.getTowBarPosition();
            GlStateManager.func_179137_b((double)(towBarOffset.field_72450_a * 0.0625), (double)(towBarOffset.field_72448_b * 0.0625 + 0.5), (double)(-towBarOffset.field_72449_c * 0.0625));
            RenderUtil.renderModel(SpecialModels.TOW_BAR.getModel(), ItemCameraTransforms.TransformType.NONE);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179137_b((double)bodyPosition.getX(), (double)bodyPosition.getY(), (double)bodyPosition.getZ());
        GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
        GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
        GlStateManager.func_179139_a((double)bodyPosition.getScale(), (double)bodyPosition.getScale(), (double)bodyPosition.getScale());
        GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
        GlStateManager.func_179109_b((float)0.0f, (float)(properties.getAxleOffset() * 0.0625f), (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(properties.getWheelOffset() * 0.0625f), (float)0.0f);
        ((AbstractRenderVehicle)this.renderVehicle).render(entity, partialTicks);
        GlStateManager.func_179121_F();
    }

    public void applyPreRotations(T entity, float partialTicks) {
    }

    protected void renderPart(@Nullable PartPosition position, @Nullable IBakedModel model, int color) {
        if (position == null || model == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(position.getX() * 0.0625), (double)(position.getY() * 0.0625), (double)(position.getZ() * 0.0625));
        GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
        GlStateManager.func_179139_a((double)position.getScale(), (double)position.getScale(), (double)position.getScale());
        GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
        GlStateManager.func_179114_b((float)((float)position.getRotX()), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)position.getRotY()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)position.getRotZ()), (float)0.0f, (float)0.0f, (float)1.0f);
        RenderUtil.renderColoredModel(model, ItemCameraTransforms.TransformType.NONE, color);
        GlStateManager.func_179121_F();
    }

    protected void renderKey(@Nullable PartPosition position, ItemStack part) {
        if (position == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(position.getX() * 0.0625), (double)(position.getY() * 0.0625), (double)(position.getZ() * 0.0625));
        GlStateManager.func_179137_b((double)0.0, (double)-0.25, (double)0.0);
        GlStateManager.func_179139_a((double)position.getScale(), (double)position.getScale(), (double)position.getScale());
        GlStateManager.func_179114_b((float)((float)position.getRotX()), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)position.getRotY()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)position.getRotZ()), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.05);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(part, ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    protected void renderEngine(EntityPoweredVehicle entity, @Nullable PartPosition position) {
        IBakedModel model;
        GlStateManager.func_179094_E();
        if (entity.isFueled() && entity.func_184179_bs() != null) {
            GlStateManager.func_179114_b((float)(0.5f * (float)(entity.field_70173_aa % 2)), (float)1.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(-0.5f * (float)(entity.field_70173_aa % 2)), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if ((model = RenderUtil.getEngineModel(entity)) != null) {
            this.renderPart(position, model, -1);
        }
        GlStateManager.func_179121_F();
    }

    protected void renderFuelPort(EntityPoweredVehicle entity, @Nullable PartPosition position) {
        if (entity.shouldRenderFuelPort() && entity.requiresFuel()) {
            Color color = new Color(entity.getColor());
            int brightness = (int)Math.sqrt((double)(color.getRed() * color.getRed()) * 0.241 + (double)(color.getGreen() * color.getGreen()) * 0.691 + (double)(color.getBlue() * color.getBlue()) * 0.068);
            int colorInt = (brightness > 127 ? color.darker() : color.brighter()).getRGB();
            EntityRaytracer.RayTraceResultRotated result = EntityRaytracer.getContinuousInteraction();
            if (result != null && result.field_72308_g == entity && result.equalsContinuousInteraction(EntityRaytracer.FUNCTION_FUELING)) {
                this.renderPart(position, entity.getFuelPort().getBody().getModel(), colorInt);
                if (((AbstractRenderVehicle)this.renderVehicle).shouldRenderFuelLid()) {
                    this.renderPart(position, entity.getFuelPort().getLid().getModel(), colorInt);
                }
                entity.playFuelPortOpenSound();
            } else {
                SpecialModels model = entity.getFuelPort().getClosed();
                if (model != null) {
                    this.renderPart(position, model.getModel(), colorInt);
                }
                entity.playFuelPortCloseSound();
            }
        }
    }

    protected void renderKeyPort(EntityPoweredVehicle entity) {
        if (entity.isKeyNeeded()) {
            Color color = new Color(entity.getColor());
            int brightness = (int)Math.sqrt((double)(color.getRed() * color.getRed()) * 0.241 + (double)(color.getGreen() * color.getGreen()) * 0.691 + (double)(color.getBlue() * color.getBlue()) * 0.068);
            int colorInt = (brightness > 127 ? color.darker() : color.brighter()).getRGB();
            VehicleProperties properties = entity.getProperties();
            this.renderPart(properties.getKeyPortPosition(), SpecialModels.KEY_HOLE.getModel(), colorInt);
            if (!entity.getKeyStack().func_190926_b()) {
                this.renderKey(properties.getKeyPosition(), entity.getKeyStack());
            }
        }
    }
}

