/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.tileentity;

import com.google.common.collect.Lists;
import com.mrcrayfish.vehicle.block.BlockGasPump;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.util.HermiteInterpolator;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.tileentity.TileEntityGasPump;
import com.mrcrayfish.vehicle.util.CollisionHelper;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class GasPumpRenderer
extends TileEntitySpecialRenderer<TileEntityGasPump> {
    public void render(TileEntityGasPump te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        HermiteInterpolator.Point destPoint;
        BlockPos blockPos = te.func_174877_v();
        IBlockState state = te.func_145831_w().func_180495_p(blockPos);
        if (state.func_177230_c() != ModBlocks.GAS_PUMP) {
            return;
        }
        boolean top = (Boolean)state.func_177229_b((IProperty)BlockGasPump.TOP);
        if (!top) {
            return;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockGasPump.FACING);
        double[] pos = CollisionHelper.fixRotation(facing, 0.640625, 1.078125, 0.640625, 1.078125);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (te.getFuelingEntity() != null) {
            String skinType;
            EntityPlayer entity = te.getFuelingEntity();
            double side = entity.func_184591_cq() == EnumHandSide.RIGHT ? 1.0 : -1.0;
            double playerX = (double)blockPos.func_177958_n() - (entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks);
            double playerY = (double)blockPos.func_177956_o() - (entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks);
            double playerZ = (double)blockPos.func_177952_p() - (entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks);
            float renderYawOffset = entity.field_70760_ar + (entity.field_70761_aq - entity.field_70760_ar) * partialTicks;
            Vec3d lookVec = Vec3d.func_189986_a((float)-20.0f, (float)renderYawOffset);
            Vec3d hoseVec = new Vec3d(-0.35 * side, 0.01, 0.0625);
            if (entity instanceof AbstractClientPlayer && (skinType = ((AbstractClientPlayer)entity).func_175154_l()).equals("slim")) {
                hoseVec = hoseVec.func_72441_c(0.03 * side, -0.03, 0.0);
            }
            hoseVec = hoseVec.func_178785_b(-renderYawOffset * ((float)Math.PI / 180));
            if (entity.equals((Object)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                lookVec = Vec3d.func_189986_a((float)0.0f, (float)entity.field_70177_z);
                hoseVec = new Vec3d(-0.25, 0.5, -0.25).func_178785_b(-entity.field_70177_z * ((float)Math.PI / 180));
            }
            destPoint = new HermiteInterpolator.Point(new Vec3d(-playerX + hoseVec.field_72450_a, -playerY + 0.8 + hoseVec.field_72448_b, -playerZ + hoseVec.field_72449_c), new Vec3d(lookVec.field_72450_a * 3.0, lookVec.field_72448_b * 3.0, lookVec.field_72449_c * 3.0));
        } else {
            double[] destPos = CollisionHelper.fixRotation(facing, 0.345, 1.06, 0.345, 1.06);
            destPoint = new HermiteInterpolator.Point(new Vec3d(destPos[0], 0.0625, destPos[1]), new Vec3d(0.0, 3.0, 0.0));
        }
        HermiteInterpolator spline = new HermiteInterpolator(Lists.newArrayList((Object[])new HermiteInterpolator.Point[]{new HermiteInterpolator.Point(new Vec3d(pos[0], 0.5625, pos[1]), new Vec3d(0.0, -5.0, 0.0)), destPoint}));
        ItemStack stack = new ItemStack(Blocks.field_192443_dR, 1, 15);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        GlStateManager.func_179094_E();
        int steps = 100;
        for (int i = 0; i < spline.getSize() - 1; ++i) {
            for (int j = 0; j <= steps; ++j) {
                float percent = (float)j / (float)steps;
                HermiteInterpolator.Result r = spline.get(i, percent);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)r.getPoint().field_72450_a, (double)r.getPoint().field_72448_b, (double)r.getPoint().field_72449_c);
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(Math.atan2(r.getDir().field_72450_a, r.getDir().field_72449_c))), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(Math.asin(-r.getDir().func_72432_b().field_72448_b))), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179139_a((double)0.075, (double)0.075, (double)0.075);
                RenderUtil.renderItemModel(stack, model, ItemCameraTransforms.TransformType.NONE);
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179121_F();
        if (te.getFuelingEntity() == null) {
            GlStateManager.func_179094_E();
            double[] destPos = CollisionHelper.fixRotation(facing, 0.29, 1.06, 0.29, 1.06);
            GlStateManager.func_179137_b((double)destPos[0], (double)0.5, (double)destPos[1]);
            GlStateManager.func_179114_b((float)((float)facing.func_176736_b() * -90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
            RenderUtil.renderItemModel(new ItemStack(ModItems.MODELS), SpecialModels.NOZZLE.getModel(), ItemCameraTransforms.TransformType.NONE);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
        GlStateManager.func_179114_b((float)((float)facing.func_176736_b() * -90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
        GlStateManager.func_179137_b((double)0.5, (double)0.6875, (double)0.1875);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.01f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.015f, (float)-0.015f, (float)0.015f);
        GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)-0.010416667f);
        GlStateManager.func_179132_a((boolean)false);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        if (te.getTank() != null) {
            int amount = (int)Math.ceil(100.0 * ((double)te.getTank().getFluidAmount() / (double)te.getTank().getCapacity()));
            String percent = String.format("%d%%", amount);
            int width = fontRenderer.func_78256_a(percent);
            fontRenderer.func_78276_b(percent, -width / 2, 10, 0xFFFFFF);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0625, (double)0.0);
        GlStateManager.func_179152_a((float)0.01f, (float)-0.01f, (float)0.01f);
        GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)-0.010416667f);
        GlStateManager.func_179132_a((boolean)false);
        fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int width = fontRenderer.func_78256_a("Fuelium");
        fontRenderer.func_78276_b("Fuelium", -width / 2, 10, 9761325);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }
}

