/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.common;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.mrcrayfish.vehicle.VehicleConfig;
import com.mrcrayfish.vehicle.common.entity.HeldVehicleDataHandler;
import com.mrcrayfish.vehicle.entity.EntityJack;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.entity.EntityTrailer;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageThrowVehicle;
import com.mrcrayfish.vehicle.tileentity.TileEntityJack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;

public class CommonEvents {
    public static final DataParameter<Boolean> PUSHING_CART = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<NBTTagCompound> HELD_VEHICLE = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_192734_n);
    public static final DataParameter<Integer> TRAILER = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Optional<BlockPos>> GAS_PUMP = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187201_k);
    private static final List<String> IGNORE_ITEMS;
    private static final List<String> IGNORE_SOUNDS;
    private static final List<String> IGNORE_ENTITIES;

    @SubscribeEvent
    public void onMissingItem(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            if (!missing.key.func_110624_b().equals("vehicle") || !IGNORE_ITEMS.contains(missing.key.func_110623_a())) continue;
            missing.ignore();
        }
    }

    @SubscribeEvent
    public void onMissingSound(RegistryEvent.MissingMappings<SoundEvent> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            if (!missing.key.func_110624_b().equals("vehicle") || !IGNORE_SOUNDS.contains(missing.key.func_110623_a())) continue;
            missing.ignore();
        }
    }

    @SubscribeEvent
    public void onMissingEntity(RegistryEvent.MissingMappings<EntityEntry> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            if (!missing.key.func_110624_b().equals("vehicle") || !IGNORE_ENTITIES.contains(missing.key.func_110623_a())) continue;
            missing.ignore();
        }
    }

    @SubscribeEvent
    public void onEntityInit(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityPlayer) {
            event.getEntity().func_184212_Q().func_187214_a(PUSHING_CART, (Object)false);
            event.getEntity().func_184212_Q().func_187214_a(HELD_VEHICLE, (Object)new NBTTagCompound());
            event.getEntity().func_184212_Q().func_187214_a(TRAILER, (Object)-1);
            event.getEntity().func_184212_Q().func_187214_a(GAS_PUMP, (Object)Optional.absent());
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        if (CommonEvents.pickUpVehicle(event.getWorld(), event.getEntityPlayer(), event.getHand(), event.getTarget())) {
            event.setCanceled(true);
        }
    }

    public static boolean pickUpVehicle(World world, EntityPlayer player, EnumHand hand, Entity targetEntity) {
        if (hand == EnumHand.MAIN_HAND && !world.field_72995_K && player.func_70093_af() && !player.func_175149_v() && VehicleConfig.SERVER.pickUpVehicles) {
            NBTTagCompound tagCompound;
            Entity vehicle;
            if (((NBTTagCompound)player.func_184212_Q().func_187225_a(HELD_VEHICLE)).func_82582_d()) {
                if (targetEntity instanceof EntityVehicle && !targetEntity.func_184207_aI() && !targetEntity.field_70128_L) {
                    NBTTagCompound tagCompound2 = new NBTTagCompound();
                    String id = CommonEvents.getEntityString(targetEntity);
                    if (id != null) {
                        ((EntityVehicle)targetEntity).setTrailer(null);
                        tagCompound2.func_74778_a("id", id);
                        targetEntity.func_189511_e(tagCompound2);
                        player.func_184212_Q().func_187227_b(HELD_VEHICLE, (Object)tagCompound2);
                        HeldVehicleDataHandler.IHeldVehicle heldVehicle = HeldVehicleDataHandler.getHandler(player);
                        if (heldVehicle != null) {
                            heldVehicle.setVehicleTag(tagCompound2);
                        }
                        world.func_72900_e(targetEntity);
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.PICK_UP_VEHICLE, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        return true;
                    }
                }
            } else if (targetEntity instanceof EntityTrailer && !targetEntity.func_184207_aI() && !targetEntity.field_70128_L && (vehicle = EntityList.func_75615_a((NBTTagCompound)(tagCompound = (NBTTagCompound)player.func_184212_Q().func_187225_a(HELD_VEHICLE)), (World)world)) != null && vehicle instanceof EntityVehicle && ((EntityVehicle)vehicle).canMountTrailer()) {
                vehicle.func_70080_a(targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v, targetEntity.field_70177_z, targetEntity.field_70125_A);
                NBTTagCompound tag = new NBTTagCompound();
                player.func_184212_Q().func_187227_b(HELD_VEHICLE, (Object)tag);
                HeldVehicleDataHandler.IHeldVehicle heldVehicle = HeldVehicleDataHandler.getHandler(player);
                if (heldVehicle != null) {
                    heldVehicle.setVehicleTag(tag);
                }
                world.func_72838_d(vehicle);
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 1.0f, 1.0f);
                vehicle.func_184220_m(targetEntity);
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() == EnumHand.OFF_HAND) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        if (!world.field_72995_K) {
            if (event.getFace() == EnumFacing.UP && !((NBTTagCompound)player.func_184212_Q().func_187225_a(HELD_VEHICLE)).func_82582_d()) {
                BlockPos pos = event.getPos();
                TileEntity tileEntity = event.getWorld().func_175625_s(pos);
                if (tileEntity instanceof TileEntityJack) {
                    NBTTagCompound tagCompound;
                    Entity entity;
                    TileEntityJack jack = (TileEntityJack)tileEntity;
                    if (jack.getJack() == null && (entity = EntityList.func_75615_a((NBTTagCompound)(tagCompound = (NBTTagCompound)player.func_184212_Q().func_187225_a(HELD_VEHICLE)), (World)world)) instanceof EntityVehicle) {
                        NBTTagCompound tag = new NBTTagCompound();
                        player.func_184212_Q().func_187227_b(HELD_VEHICLE, (Object)tag);
                        HeldVehicleDataHandler.IHeldVehicle heldVehicle = HeldVehicleDataHandler.getHandler(player);
                        if (heldVehicle != null) {
                            heldVehicle.setVehicleTag(tag);
                        }
                        entity.field_70143_R = 0.0f;
                        entity.field_70177_z = (player.func_70079_am() + 90.0f) % 360.0f;
                        jack.setVehicle((EntityVehicle)entity);
                        if (jack.getJack() != null) {
                            EntityJack entityJack = jack.getJack();
                            entityJack.func_70098_U();
                            entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                        }
                        world.func_72838_d(entity);
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                    event.setCanceled(true);
                    return;
                }
            }
            if (player.func_70093_af() && !((NBTTagCompound)player.func_184212_Q().func_187225_a(HELD_VEHICLE)).func_82582_d()) {
                MinecraftServer server;
                Vec3d clickedVec = event.getHitVec();
                if (clickedVec == null || event.getFace() != EnumFacing.UP) {
                    event.setCanceled(true);
                    return;
                }
                NBTTagCompound tagCompound = (NBTTagCompound)player.func_184212_Q().func_187225_a(HELD_VEHICLE);
                Entity entity = EntityList.func_75615_a((NBTTagCompound)tagCompound, (World)world);
                if (entity instanceof EntityVehicle && (server = world.func_73046_m()) != null && server.func_175576_a(entity.func_110124_au()) == null) {
                    server.func_152344_a(() -> {
                        NBTTagCompound tag = new NBTTagCompound();
                        player.func_184212_Q().func_187227_b(HELD_VEHICLE, (Object)tag);
                        HeldVehicleDataHandler.IHeldVehicle heldVehicle = HeldVehicleDataHandler.getHandler(player);
                        if (heldVehicle != null) {
                            heldVehicle.setVehicleTag(tag);
                        }
                        float rotation = (player.func_70079_am() + 90.0f) % 360.0f;
                        Vec3d heldOffset = ((EntityVehicle)entity).getProperties().getHeldOffset().func_178785_b((float)Math.toRadians(-player.func_70079_am()));
                        entity.func_70080_a(clickedVec.field_72450_a + heldOffset.field_72450_a * 0.0625, clickedVec.field_72448_b, clickedVec.field_72449_c + heldOffset.field_72449_c * 0.0625, rotation, 0.0f);
                        entity.field_70143_R = 0.0f;
                        world.func_72838_d(entity);
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    });
                    event.setCanceled(true);
                }
            }
        } else if (!((NBTTagCompound)player.func_184212_Q().func_187225_a(HELD_VEHICLE)).func_82582_d()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        EntityPlayer player;
        if (event.getHand() == EnumHand.OFF_HAND) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K && (event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickItem) && !((NBTTagCompound)(player = event.getEntityPlayer()).func_184212_Q().func_187225_a(HELD_VEHICLE)).func_82582_d()) {
            if (player.func_70093_af()) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageThrowVehicle());
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @Nullable
    private static String getEntityString(Entity entity) {
        ResourceLocation resourcelocation = EntityList.func_191301_a((Entity)entity);
        return resourcelocation == null ? null : resourcelocation.toString();
    }

    @SubscribeEvent
    public void onPlayerLoadData(PlayerEvent.LoadFromFile event) {
        EntityPlayer player = event.getEntityPlayer();
        HeldVehicleDataHandler.IHeldVehicle heldVehicle = HeldVehicleDataHandler.getHandler(player);
        if (heldVehicle != null) {
            player.func_184212_Q().func_187227_b(HELD_VEHICLE, (Object)heldVehicle.getVehicleTag());
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            this.dropVehicle(player);
        }
    }

    private void dropVehicle(EntityPlayer player) {
        NBTTagCompound tagCompound = (NBTTagCompound)player.func_184212_Q().func_187225_a(HELD_VEHICLE);
        if (!tagCompound.func_82582_d()) {
            NBTTagCompound blankTag = new NBTTagCompound();
            HeldVehicleDataHandler.IHeldVehicle heldVehicle = HeldVehicleDataHandler.getHandler(player);
            if (heldVehicle != null) {
                heldVehicle.setVehicleTag(blankTag);
            }
            player.func_184212_Q().func_187227_b(HELD_VEHICLE, (Object)blankTag);
            Entity vehicle = EntityList.func_75615_a((NBTTagCompound)tagCompound, (World)player.field_70170_p);
            if (vehicle != null && vehicle instanceof EntityPoweredVehicle) {
                float rotation = (player.func_70079_am() + 90.0f) % 360.0f;
                Vec3d heldOffset = ((EntityPoweredVehicle)vehicle).getProperties().getHeldOffset().func_178785_b((float)Math.toRadians(-player.func_70079_am()));
                vehicle.func_70080_a(player.field_70165_t + heldOffset.field_72450_a * 0.0625, player.field_70163_u + (double)player.func_70047_e() + heldOffset.field_72448_b * 0.0625, player.field_70161_v + heldOffset.field_72449_c * 0.0625, rotation, 0.0f);
                player.field_70170_p.func_72838_d(vehicle);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            int trailerId;
            EntityPlayer player = event.player;
            World world = player.field_70170_p;
            if (player.func_70093_af() && (trailerId = ((Integer)player.func_184212_Q().func_187225_a(TRAILER)).intValue()) != -1) {
                Entity entity = world.func_73045_a(trailerId);
                if (entity instanceof EntityTrailer) {
                    ((EntityTrailer)entity).setPullingEntity(null);
                }
                player.func_184212_Q().func_187227_b(TRAILER, (Object)-1);
            }
            if (!world.field_72995_K && player.func_175149_v()) {
                this.dropVehicle(player);
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        if (((Optional)event.getEntityPlayer().func_184212_Q().func_187225_a(GAS_PUMP)).isPresent()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        if (state.func_177230_c() != ModBlocks.GAS_PUMP && ((Optional)event.getEntityPlayer().func_184212_Q().func_187225_a(GAS_PUMP)).isPresent()) {
            event.setCanceled(true);
        }
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)"body");
        builder.add((Object)"atv");
        builder.add((Object)"go_kart");
        IGNORE_ITEMS = builder.build();
        builder = ImmutableList.builder();
        builder.add((Object)"idle");
        builder.add((Object)"driving");
        IGNORE_SOUNDS = builder.build();
        builder = ImmutableList.builder();
        builder.add((Object)"vehicle_atv");
        builder.add((Object)"couch");
        builder.add((Object)"bath");
        IGNORE_ENTITIES = builder.build();
    }
}

