/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.common;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageSyncPlayerSeat;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SeatTracker {
    private final int maxSeatSize;
    private HashBiMap<UUID, Integer> playerSeatMap = HashBiMap.create();
    private WeakReference<EntityVehicle> vehicleRef;

    public SeatTracker(EntityVehicle entity) {
        this.maxSeatSize = entity.getProperties().getSeats().size();
        this.vehicleRef = new WeakReference<EntityVehicle>(entity);
    }

    public ImmutableMap<UUID, Integer> getPlayerSeatMap() {
        return ImmutableMap.copyOf(this.playerSeatMap);
    }

    public int getSeatIndex(UUID uuid) {
        if (this.playerSeatMap.containsKey((Object)uuid)) {
            return (Integer)this.playerSeatMap.getOrDefault((Object)uuid, (Object)-1);
        }
        return -1;
    }

    public void setSeatIndex(int index, UUID uuid) {
        if (index < 0 || index >= this.maxSeatSize) {
            return;
        }
        this.playerSeatMap.forcePut((Object)uuid, (Object)index);
        EntityVehicle vehicle = (EntityVehicle)((Object)this.vehicleRef.get());
        if (vehicle != null && !vehicle.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageSyncPlayerSeat(vehicle.func_145782_y(), index, uuid), (Entity)vehicle);
        }
    }

    public boolean isSeatAvailable(int index) {
        if (index < 0 || index >= this.maxSeatSize) {
            return false;
        }
        if (!this.playerSeatMap.inverse().containsKey((Object)index)) {
            return true;
        }
        EntityVehicle vehicle = (EntityVehicle)((Object)this.vehicleRef.get());
        if (vehicle != null) {
            UUID uuid = (UUID)this.playerSeatMap.inverse().get((Object)index);
            return vehicle.func_184188_bt().stream().noneMatch(entity -> entity.func_110124_au().equals(uuid));
        }
        return false;
    }

    public void remove(UUID uuid) {
        this.playerSeatMap.remove((Object)uuid);
    }

    public int getNextAvailableSeat() {
        EntityVehicle vehicle = (EntityVehicle)((Object)this.vehicleRef.get());
        if (vehicle != null && !vehicle.field_70170_p.field_72995_K) {
            VehicleProperties properties = vehicle.getProperties();
            List<Seat> seats = properties.getSeats();
            for (int i = 0; i < seats.size(); ++i) {
                if (!this.playerSeatMap.values().contains(i)) {
                    return i;
                }
                UUID uuid = (UUID)this.playerSeatMap.inverse().get((Object)i);
                if (!vehicle.func_184188_bt().stream().noneMatch(entity -> entity.func_110124_au().equals(uuid))) continue;
                this.playerSeatMap.remove((Object)uuid);
                return i;
            }
        }
        return -1;
    }

    public int getClosestAvailableSeatToPlayer(EntityPlayer player) {
        EntityVehicle vehicle = (EntityVehicle)((Object)this.vehicleRef.get());
        if (vehicle != null && !vehicle.field_70170_p.field_72995_K) {
            VehicleProperties properties = vehicle.getProperties();
            List<Seat> seats = properties.getSeats();
            if (vehicle.func_184188_bt().size() == seats.size()) {
                return -1;
            }
            int closestSeatIndex = -1;
            double closestDistance = 0.0;
            for (int i = 0; i < seats.size(); ++i) {
                if (!this.isSeatAvailable(i)) continue;
                Seat seat = seats.get(i);
                Vec3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale()).func_186678_a(0.0625);
                seatVec = new Vec3d(-seatVec.field_72450_a, seatVec.field_72448_b, seatVec.field_72449_c);
                seatVec = seatVec.func_178785_b(-vehicle.getModifiedRotationYaw() * ((float)Math.PI / 180));
                seatVec = seatVec.func_178787_e(vehicle.func_174791_d());
                double distance = player.func_70092_e(seatVec.field_72450_a, seatVec.field_72448_b - (double)(player.field_70131_O / 2.0f), seatVec.field_72449_c);
                if (closestSeatIndex != -1 && !(distance < closestDistance)) continue;
                closestSeatIndex = i;
                closestDistance = distance;
            }
            return closestSeatIndex;
        }
        return -1;
    }

    public NBTTagCompound write() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        this.playerSeatMap.forEach((uuid, seatIndex) -> {
            NBTTagCompound seatTag = new NBTTagCompound();
            seatTag.func_186854_a("UUID", uuid);
            seatTag.func_74768_a("SeatIndex", seatIndex.intValue());
            list.func_74742_a((NBTBase)seatTag);
        });
        compound.func_74782_a("PlayerSeatMap", (NBTBase)list);
        return compound;
    }

    public void read(NBTTagCompound compound) {
        if (compound.func_150297_b("PlayerSeatMap", 9)) {
            this.playerSeatMap.clear();
            NBTTagList list = compound.func_150295_c("PlayerSeatMap", 10);
            list.forEach(nbt -> {
                NBTTagCompound seatTag = (NBTTagCompound)nbt;
                UUID uuid = seatTag.func_186857_a("UUID");
                int seatIndex = seatTag.func_74762_e("SeatIndex");
                this.playerSeatMap.put((Object)uuid, (Object)seatIndex);
            });
        }
    }

    public void write(ByteBuf buffer) {
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.playerSeatMap.size(), (int)3);
        this.playerSeatMap.forEach((uuid, seatIndex) -> {
            buffer.writeLong(uuid.getMostSignificantBits());
            buffer.writeLong(uuid.getLeastSignificantBits());
            ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)seatIndex, (int)3);
        });
    }

    public void read(ByteBuf buffer) {
        this.playerSeatMap.clear();
        int size = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)3);
        for (int i = 0; i < size; ++i) {
            UUID uuid = new UUID(buffer.readLong(), buffer.readLong());
            int seatIndex = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)3);
            this.playerSeatMap.put((Object)uuid, (Object)seatIndex);
        }
    }
}

