/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity.trailer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mrcrayfish.vehicle.VehicleConfig;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.common.inventory.IStorage;
import com.mrcrayfish.vehicle.common.inventory.StorageInventory;
import com.mrcrayfish.vehicle.entity.EntityTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityStorageTrailer;
import com.mrcrayfish.vehicle.item.ItemSprayCan;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAttachTrailer;
import com.mrcrayfish.vehicle.network.message.MessageSyncInventory;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFertilizerTrailer
extends EntityTrailer
implements EntityRaytracer.IEntityRaytraceable,
IStorage {
    private static final EntityRaytracer.RayTracePart CONNECTION_BOX = new EntityRaytracer.RayTracePart(EntityFertilizerTrailer.createScaledBoundingBox(-0.4375, 0.3875, 0.375, 0.4375, 0.525, 1.125, 1.1));
    private static final Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> interactionBoxMapStatic = Maps.newHashMap();
    private int inventoryTimer;
    private StorageInventory inventory;
    private BlockPos[] lastPos = new BlockPos[3];

    public EntityFertilizerTrailer(World worldIn) {
        super(worldIn);
        this.initInventory();
        this.func_70105_a(1.5f, 1.5f);
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    protected boolean func_184219_q(Entity passenger) {
        return false;
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if ((heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof ItemSprayCan)) && player instanceof EntityPlayerMP) {
            this.inventory.openGui((EntityPlayerMP)player, this);
        }
        return super.func_184230_a(player, hand);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K && VehicleConfig.SERVER.trailerInventorySyncCooldown > 0 && this.inventoryTimer++ == VehicleConfig.SERVER.trailerInventorySyncCooldown) {
            this.inventoryTimer = 0;
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageSyncInventory(this.func_145782_y(), this.inventory), (Entity)this);
        }
    }

    @Override
    public void onUpdateVehicle() {
        super.onUpdateVehicle();
        ItemStack fertilizer = this.getFertilizer();
        if (fertilizer.func_190926_b() && this.getPullingEntity() instanceof EntityStorageTrailer) {
            fertilizer = this.getFertilizerFromStorage((EntityStorageTrailer)this.getPullingEntity());
        }
        if (!fertilizer.func_190926_b()) {
            Vec3d lookVec = this.func_70040_Z();
            boolean applied = this.applyFertilizer(lookVec.func_178785_b((float)Math.toRadians(90.0)), 0);
            applied |= this.applyFertilizer(Vec3d.field_186680_a, 1);
            if (applied |= this.applyFertilizer(lookVec.func_178785_b((float)Math.toRadians(-90.0)), 2)) {
                fertilizer.func_190918_g(1);
            }
        }
    }

    private boolean applyFertilizer(Vec3d vec, int index) {
        IGrowable growable;
        Vec3d prevPosVec = new Vec3d(this.field_70169_q, this.field_70167_r + 0.25, this.field_70166_s);
        prevPosVec = prevPosVec.func_178787_e(new Vec3d(0.0, 0.0, -1.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180)));
        BlockPos pos = new BlockPos(prevPosVec.field_72450_a + vec.field_72450_a, prevPosVec.field_72448_b, prevPosVec.field_72449_c + vec.field_72449_c);
        if (this.lastPos[index] != null && this.lastPos[index].equals((Object)pos)) {
            return false;
        }
        this.lastPos[index] = pos;
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        if (state.func_177230_c() instanceof IGrowable && (growable = (IGrowable)state.func_177230_c()).func_176473_a(this.field_70170_p, pos, state, false) && growable.func_180670_a(this.field_70170_p, this.field_70146_Z, pos, state)) {
            growable.func_176474_b(this.field_70170_p, this.field_70146_Z, pos, state);
            this.field_70170_p.func_175718_b(2005, pos, 0);
            return true;
        }
        return false;
    }

    private ItemStack getFertilizer() {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            EnumDyeColor dyeColor;
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemDye) || (dyeColor = EnumDyeColor.func_176766_a((int)stack.func_77960_j())) != EnumDyeColor.WHITE) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getFertilizerFromStorage(EntityStorageTrailer storageTrailer) {
        if (storageTrailer == null) {
            return ItemStack.field_190927_a;
        }
        if (storageTrailer.getInventory() != null) {
            StorageInventory storage = storageTrailer.getInventory();
            for (int i = 0; i < storage.func_70302_i_(); ++i) {
                EnumDyeColor dyeColor;
                ItemStack stack = storage.func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemDye) || (dyeColor = EnumDyeColor.func_176766_a((int)stack.func_77960_j())) != EnumDyeColor.WHITE) continue;
                return stack;
            }
            if (storageTrailer.getPullingEntity() instanceof EntityStorageTrailer) {
                return this.getFertilizerFromStorage((EntityStorageTrailer)storageTrailer.getPullingEntity());
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("inventory", 9)) {
            this.initInventory();
            InventoryUtil.readInventoryToNBT(compound, "inventory", this.inventory);
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.inventory != null) {
            InventoryUtil.writeInventoryToNBT(compound, "inventory", (IInventory)this.inventory);
        }
    }

    private void initInventory() {
        StorageInventory original = this.inventory;
        this.inventory = new StorageInventory(this.func_70005_c_(), false, 27, this);
        if (original != null) {
            for (int i = 0; i < original.func_70302_i_(); ++i) {
                ItemStack stack = original.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                this.inventory.func_70299_a(i, stack.func_77946_l());
            }
        }
    }

    @Override
    protected void onVehicleDestroyed(EntityLivingBase entity) {
        super.onVehicleDestroyed(entity);
        if (this.inventory != null) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this.inventory);
        }
    }

    @Override
    public StorageInventory getInventory() {
        return this.inventory;
    }

    @Override
    public double getHitchOffset() {
        return -18.700000000000003;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> getStaticInteractionBoxMap() {
        return interactionBoxMapStatic;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<EntityRaytracer.RayTracePart> getApplicableInteractionBoxes() {
        return ImmutableList.of((Object)CONNECTION_BOX);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInteractionBoxes(Tessellator tessellator, BufferBuilder buffer) {
        RenderGlobal.func_189697_a((AxisAlignedBB)CONNECTION_BOX.getBox(), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.4f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean processHit(EntityRaytracer.RayTraceResultRotated result, boolean rightClick) {
        if (rightClick && result.getPartHit() == CONNECTION_BOX) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageAttachTrailer(this.func_145782_y(), Minecraft.func_71410_x().field_71439_g.func_145782_y()));
            return true;
        }
        return EntityRaytracer.IEntityRaytraceable.super.processHit(result, rightClick);
    }

    @Override
    public boolean isStorageItem(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemDye) {
            EnumDyeColor dyeColor = EnumDyeColor.func_176766_a((int)stack.func_77960_j());
            return dyeColor == EnumDyeColor.WHITE;
        }
        return false;
    }

    static {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            interactionBoxMapStatic.put(CONNECTION_BOX, EntityRaytracer.boxToTriangles(CONNECTION_BOX.getBox(), null));
        }
    }
}

