/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity.trailer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mrcrayfish.vehicle.VehicleConfig;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.common.inventory.IStorage;
import com.mrcrayfish.vehicle.common.inventory.StorageInventory;
import com.mrcrayfish.vehicle.entity.EntityTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityStorageTrailer;
import com.mrcrayfish.vehicle.item.ItemSprayCan;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAttachTrailer;
import com.mrcrayfish.vehicle.network.message.MessageSyncInventory;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFarmland;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySeederTrailer
extends EntityTrailer
implements EntityRaytracer.IEntityRaytraceable,
IStorage {
    private static final EntityRaytracer.RayTracePart CONNECTION_BOX = new EntityRaytracer.RayTracePart(EntitySeederTrailer.createScaledBoundingBox(-0.4375, 0.3875, 0.375, 0.4375, 0.525, 1.0625, 1.1));
    private static final Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> interactionBoxMapStatic = Maps.newHashMap();
    private int inventoryTimer;
    private StorageInventory inventory;

    public EntitySeederTrailer(World worldIn) {
        super(worldIn);
        this.initInventory();
        this.func_70105_a(1.5f, 1.5f);
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    protected boolean func_184219_q(Entity passenger) {
        return false;
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if ((heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof ItemSprayCan)) && player instanceof EntityPlayerMP) {
            this.inventory.openGui((EntityPlayerMP)player, this);
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K && VehicleConfig.SERVER.trailerInventorySyncCooldown > 0 && this.inventoryTimer++ == VehicleConfig.SERVER.trailerInventorySyncCooldown) {
            this.inventoryTimer = 0;
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageSyncInventory(this.func_145782_y(), this.inventory), (Entity)this);
        }
    }

    @Override
    public void onUpdateVehicle() {
        super.onUpdateVehicle();
        Vec3d lookVec = this.func_70040_Z();
        this.plantSeed(lookVec.func_178785_b((float)Math.toRadians(90.0)).func_186678_a(0.85));
        this.plantSeed(Vec3d.field_186680_a);
        this.plantSeed(lookVec.func_178785_b((float)Math.toRadians(-90.0)).func_186678_a(0.85));
    }

    private void plantSeed(Vec3d vec) {
        BlockPos pos = new BlockPos(this.field_70169_q + vec.field_72450_a, this.field_70167_r + 0.25, this.field_70166_s + vec.field_72449_c);
        if (this.field_70170_p.func_175623_d(pos) && this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockFarmland) {
            ItemStack seed = this.getSeed();
            if (seed.func_190926_b() && this.getPullingEntity() instanceof EntityStorageTrailer) {
                seed = this.getSeedFromStorage((EntityStorageTrailer)this.getPullingEntity());
            }
            if (!seed.func_190926_b() && seed.func_77973_b() instanceof IPlantable) {
                IPlantable plantable = (IPlantable)seed.func_77973_b();
                this.field_70170_p.func_175656_a(pos, plantable.getPlant((IBlockAccess)this.field_70170_p, pos));
                seed.func_190918_g(1);
            }
        }
    }

    private ItemStack getSeed() {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IPlantable)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getSeedFromStorage(EntityStorageTrailer storageTrailer) {
        if (storageTrailer == null) {
            return ItemStack.field_190927_a;
        }
        if (storageTrailer.getInventory() != null) {
            StorageInventory storage = storageTrailer.getInventory();
            for (int i = 0; i < storage.func_70302_i_(); ++i) {
                ItemStack stack = storage.func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IPlantable)) continue;
                return stack;
            }
            if (storageTrailer.getPullingEntity() instanceof EntityStorageTrailer) {
                return this.getSeedFromStorage((EntityStorageTrailer)storageTrailer.getPullingEntity());
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("inventory", 9)) {
            this.initInventory();
            InventoryUtil.readInventoryToNBT(compound, "inventory", this.inventory);
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.inventory != null) {
            InventoryUtil.writeInventoryToNBT(compound, "inventory", (IInventory)this.inventory);
        }
    }

    private void initInventory() {
        StorageInventory original = this.inventory;
        this.inventory = new StorageInventory(this.func_70005_c_(), false, 27, this);
        if (original != null) {
            for (int i = 0; i < original.func_70302_i_(); ++i) {
                ItemStack stack = original.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                this.inventory.func_70299_a(i, stack.func_77946_l());
            }
        }
    }

    @Override
    protected void onVehicleDestroyed(EntityLivingBase entity) {
        super.onVehicleDestroyed(entity);
        if (this.inventory != null) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this.inventory);
        }
    }

    @Override
    public StorageInventory getInventory() {
        return this.inventory;
    }

    @Override
    public double getHitchOffset() {
        return -17.6;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> getStaticInteractionBoxMap() {
        return interactionBoxMapStatic;
    }

    @Override
    @Nullable
    public List<EntityRaytracer.RayTracePart> getApplicableInteractionBoxes() {
        return ImmutableList.of((Object)CONNECTION_BOX);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInteractionBoxes(Tessellator tessellator, BufferBuilder buffer) {
        RenderGlobal.func_189697_a((AxisAlignedBB)CONNECTION_BOX.getBox(), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.4f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean processHit(EntityRaytracer.RayTraceResultRotated result, boolean rightClick) {
        if (rightClick && result.getPartHit() == CONNECTION_BOX) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageAttachTrailer(this.func_145782_y(), Minecraft.func_71410_x().field_71439_g.func_145782_y()));
            return true;
        }
        return EntityRaytracer.IEntityRaytraceable.super.processHit(result, rightClick);
    }

    @Override
    public boolean isStorageItem(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IPlantable;
    }

    static {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            interactionBoxMapStatic.put(CONNECTION_BOX, EntityRaytracer.boxToTriangles(CONNECTION_BOX.getBox(), null));
        }
    }
}

