/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity.trailer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.common.inventory.IStorage;
import com.mrcrayfish.vehicle.common.inventory.StorageInventory;
import com.mrcrayfish.vehicle.entity.EntityTrailer;
import com.mrcrayfish.vehicle.item.ItemSprayCan;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAttachTrailer;
import com.mrcrayfish.vehicle.network.message.MessageOpenStorage;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityStorageTrailer
extends EntityTrailer
implements EntityRaytracer.IEntityRaytraceable,
IStorage {
    private static final EntityRaytracer.RayTracePart CONNECTION_BOX = new EntityRaytracer.RayTracePart(EntityStorageTrailer.createScaledBoundingBox(-0.375, 0.2625, 0.5625, 0.375, 0.51875, 1.0625, 1.1));
    private static final EntityRaytracer.RayTracePart CHEST_BOX = new EntityRaytracer.RayTracePart(new AxisAlignedBB(-0.4375, 0.475, -0.4375, 0.4375, 1.34, 0.4375));
    private static final Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> interactionBoxMapStatic = Maps.newHashMap();
    private StorageInventory inventory;

    public EntityStorageTrailer(World worldIn) {
        super(worldIn);
        this.initInventory();
    }

    @Override
    public double getHitchOffset() {
        return -17.6;
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    protected boolean func_184219_q(Entity passenger) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> getStaticInteractionBoxMap() {
        return interactionBoxMapStatic;
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if ((heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof ItemSprayCan)) && player instanceof EntityPlayerMP) {
            this.inventory.openGui((EntityPlayerMP)player, this);
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public List<EntityRaytracer.RayTracePart> getApplicableInteractionBoxes() {
        return ImmutableList.of((Object)CONNECTION_BOX, (Object)CHEST_BOX);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInteractionBoxes(Tessellator tessellator, BufferBuilder buffer) {
        RenderGlobal.func_189697_a((AxisAlignedBB)CONNECTION_BOX.getBox(), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.4f);
        RenderGlobal.func_189697_a((AxisAlignedBB)CHEST_BOX.getBox(), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.4f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean processHit(EntityRaytracer.RayTraceResultRotated result, boolean rightClick) {
        if (rightClick) {
            if (result.getPartHit() == CONNECTION_BOX) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageAttachTrailer(this.func_145782_y(), Minecraft.func_71410_x().field_71439_g.func_145782_y()));
                return true;
            }
            if (result.getPartHit() == CHEST_BOX) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageOpenStorage(this.func_145782_y()));
                Minecraft.func_71410_x().field_71439_g.func_184609_a(EnumHand.MAIN_HAND);
                return true;
            }
        }
        return EntityRaytracer.IEntityRaytraceable.super.processHit(result, rightClick);
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("inventory", 9)) {
            this.initInventory();
            InventoryUtil.readInventoryToNBT(compound, "inventory", this.inventory);
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.inventory != null) {
            InventoryUtil.writeInventoryToNBT(compound, "inventory", (IInventory)this.inventory);
        }
    }

    private void initInventory() {
        StorageInventory original = this.inventory;
        this.inventory = new StorageInventory(this.func_70005_c_(), false, 27, this);
        if (original != null) {
            for (int i = 0; i < original.func_70302_i_(); ++i) {
                ItemStack stack = original.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                this.inventory.func_70299_a(i, stack.func_77946_l());
            }
        }
    }

    @Override
    protected void onVehicleDestroyed(EntityLivingBase entity) {
        super.onVehicleDestroyed(entity);
        if (this.inventory != null) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this.inventory);
        }
    }

    @Override
    public StorageInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean canTowTrailer() {
        return true;
    }

    static {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            interactionBoxMapStatic.put(CONNECTION_BOX, EntityRaytracer.boxToTriangles(CONNECTION_BOX.getBox(), null));
            interactionBoxMapStatic.put(CHEST_BOX, EntityRaytracer.boxToTriangles(CHEST_BOX.getBox(), null));
        }
    }
}

