/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.block.BlockVehicleCrate;
import com.mrcrayfish.vehicle.common.container.ContainerWorkstation;
import com.mrcrayfish.vehicle.crafting.VehicleRecipes;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.entity.WheelType;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.item.ItemEngine;
import com.mrcrayfish.vehicle.tileentity.TileEntityWorkstation;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MessageCraftVehicle
implements IMessage,
IMessageHandler<MessageCraftVehicle, IMessage> {
    private String vehicleId;
    private BlockPos pos;

    public MessageCraftVehicle() {
    }

    public MessageCraftVehicle(String vehicleId, BlockPos pos) {
        this.vehicleId = vehicleId;
        this.pos = pos;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.vehicleId);
        buf.writeLong(this.pos.func_177986_g());
    }

    public void fromBytes(ByteBuf buf) {
        this.vehicleId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public IMessage onMessage(MessageCraftVehicle message, MessageContext ctx) {
        FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
            Class clazz;
            VehicleRecipes.VehicleRecipe recipe;
            EntityEntry entry;
            ResourceLocation entityId;
            ContainerWorkstation workstation;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            if (player.field_71070_bA instanceof ContainerWorkstation && (workstation = (ContainerWorkstation)player.field_71070_bA).getPos().equals((Object)message.pos) && (entityId = new ResourceLocation(message.vehicleId)).func_110624_b().equals("vehicle") && (entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(message.vehicleId))) != null && (recipe = VehicleRecipes.getRecipe(clazz = entry.getEntityClass())) != null) {
                ItemStack engine;
                ItemStack dyeStack;
                ItemStack wheel;
                for (ItemStack stack : recipe.getMaterials()) {
                    if (InventoryUtil.hasItemStack((EntityPlayer)player, stack)) continue;
                    return;
                }
                EntityVehicle vehicle = null;
                EngineType engineType = EngineType.NONE;
                try {
                    Constructor constructor = clazz.getDeclaredConstructor(World.class);
                    Entity entity = (Entity)constructor.newInstance(world);
                    if (entity instanceof EntityVehicle) {
                        vehicle = (EntityVehicle)entity;
                    }
                    if (entity instanceof EntityPoweredVehicle) {
                        EntityPoweredVehicle entityPoweredVehicle = (EntityPoweredVehicle)entity;
                        engineType = entityPoweredVehicle.getEngineType();
                        TileEntityWorkstation tileEntityWorkstation = workstation.getTileEntity();
                        ItemStack engine2 = tileEntityWorkstation.func_70301_a(1);
                        if (!engine2.func_190926_b() && engine2.func_77973_b() instanceof ItemEngine) {
                            EngineType engineType2 = ((ItemEngine)engine2.func_77973_b()).getEngineType();
                            if (entityPoweredVehicle.getEngineType() != EngineType.NONE && entityPoweredVehicle.getEngineType() != engineType2) {
                                return;
                            }
                        } else {
                            return;
                        }
                        if (entityPoweredVehicle.canChangeWheels() && (wheel = (ItemStack)tileEntityWorkstation.getInventory().get(2)).func_77973_b() != ModItems.WHEEL) {
                            return;
                        }
                    }
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                    return;
                }
                if (vehicle == null) {
                    return;
                }
                for (ItemStack stack : recipe.getMaterials()) {
                    InventoryUtil.removeItemStack((EntityPlayer)player, stack);
                }
                TileEntityWorkstation tileEntityWorkstation = workstation.getTileEntity();
                int color = EntityVehicle.DYE_TO_COLOR[0];
                if (vehicle.canBeColored() && (dyeStack = (ItemStack)tileEntityWorkstation.getInventory().get(0)).func_77973_b() instanceof ItemDye) {
                    color = EntityVehicle.DYE_TO_COLOR[15 - dyeStack.func_77960_j()];
                    tileEntityWorkstation.getInventory().set(0, (Object)ItemStack.field_190927_a);
                }
                EngineTier engineTier = EngineTier.WOOD;
                if (engineType != EngineType.NONE && (engine = (ItemStack)tileEntityWorkstation.getInventory().get(1)).func_77973_b() instanceof ItemEngine) {
                    engineTier = EngineTier.getType(engine.func_77960_j());
                    tileEntityWorkstation.getInventory().set(1, (Object)ItemStack.field_190927_a);
                }
                int wheelColor = -1;
                WheelType wheelType = null;
                wheel = (ItemStack)tileEntityWorkstation.getInventory().get(2);
                if (vehicle instanceof EntityPoweredVehicle && ((EntityPoweredVehicle)vehicle).canChangeWheels() && wheel.func_77973_b() == ModItems.WHEEL) {
                    NBTTagCompound tagCompound;
                    wheelType = WheelType.values()[wheel.func_77960_j()];
                    if (wheel.func_77978_p() != null && (tagCompound = wheel.func_77978_p()).func_150297_b("color", 3)) {
                        wheelColor = tagCompound.func_74762_e("color");
                    }
                    tileEntityWorkstation.getInventory().set(2, (Object)ItemStack.field_190927_a);
                }
                ItemStack stack = BlockVehicleCrate.create(entityId, color, engineTier, wheelType, wheelColor);
                world.func_72838_d((Entity)new EntityItem(world, (double)message.pos.func_177958_n() + 0.5, (double)message.pos.func_177956_o() + 1.125, (double)message.pos.func_177952_p() + 0.5, stack));
            }
        });
        return null;
    }
}

