/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.util;

import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.init.ModItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    public static void drawTexturedModalRect(double x, double y, int textureX, int textureY, double width, double height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)((double)textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_187315_a((double)((float)((double)textureX + width) * 0.00390625f), (double)((float)((double)textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_187315_a((double)((float)((double)textureX + width) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b(x + 0.0, y, 0.0).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawGradientRectHorizontal(int left, int top, int right, int bottom, int leftColor, int rightColor, double zLevel) {
        float f = (float)(leftColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(leftColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(leftColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(leftColor & 0xFF) / 255.0f;
        float f4 = (float)(rightColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(rightColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(rightColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(rightColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void renderItemModel(ItemStack stack, IBakedModel model, ItemCameraTransforms.TransformType transform) {
        if (!stack.func_190926_b()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179091_B();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179094_E();
            model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)transform, (boolean)false);
            Minecraft.func_71410_x().func_175599_af().func_180454_a(stack, model);
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
            GlStateManager.func_179121_F();
            GlStateManager.func_179101_C();
            GlStateManager.func_179084_k();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        }
    }

    public static void renderColoredModel(IBakedModel model, ItemCameraTransforms.TransformType transformType, int color) {
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)transformType, (boolean)false);
        if (!model.func_188618_c()) {
            RenderUtil.renderModel(model, color);
        }
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179121_F();
    }

    public static void renderModel(IBakedModel model, ItemCameraTransforms.TransformType transformType) {
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)transformType, (boolean)false);
        if (!model.func_188618_c()) {
            RenderUtil.renderModel(model, -1);
        }
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179121_F();
    }

    public static void renderModel(IBakedModel model, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (!model.func_188618_c()) {
            RenderUtil.renderModel(model, color, ItemStack.field_190927_a);
        }
        GlStateManager.func_179121_F();
    }

    private static void renderModel(IBakedModel model, int color, ItemStack stack) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing face : EnumFacing.values()) {
            RenderUtil.renderQuads(buffer, model.func_188616_a(null, face, 0L), color, stack);
        }
        RenderUtil.renderQuads(buffer, model.func_188616_a(null, null, 0L), color, stack);
        tessellator.func_78381_a();
    }

    private static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack) {
        boolean useItemColor = color == -1 && !stack.func_190926_b();
        for (BakedQuad quad : quads) {
            int tintColor = -1;
            if (quad.func_178212_b()) {
                tintColor = useItemColor ? Minecraft.func_71410_x().getItemColors().func_186728_a(stack, quad.func_178211_c()) : color;
                if (EntityRenderer.field_78517_a) {
                    tintColor = TextureUtil.func_177054_c((int)tintColor);
                }
                tintColor |= 0xFF000000;
            }
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)quad, (int)tintColor);
        }
    }

    public static void scissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution resolution = new ScaledResolution(mc);
        int scale = resolution.func_78325_e();
        GL11.glScissor((int)(x * scale), (int)(mc.field_71440_d - y * scale - height * scale), (int)Math.max(0, width * scale), (int)Math.max(0, height * scale));
    }

    public static ModelManager getModelManager() {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b();
    }

    public static IBakedModel getModel(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
    }

    @Nullable
    public static IBakedModel getWheelModel(EntityPoweredVehicle entity) {
        ItemStack stack;
        if (entity.hasWheels() && !(stack = new ItemStack(ModItems.WHEEL, 1, entity.getWheelType().ordinal())).func_190926_b()) {
            return RenderUtil.getModel(stack);
        }
        return null;
    }

    @Nullable
    public static IBakedModel getEngineModel(EntityPoweredVehicle entity) {
        if (entity.hasEngine()) {
            ItemStack stack = ItemStack.field_190927_a;
            switch (entity.getEngineType()) {
                case SMALL_MOTOR: {
                    stack = new ItemStack(ModItems.SMALL_ENGINE, 1, entity.getEngineTier().ordinal());
                    break;
                }
                case LARGE_MOTOR: {
                    stack = new ItemStack(ModItems.LARGE_ENGINE, 1, entity.getEngineTier().ordinal());
                    break;
                }
                case ELECTRIC_MOTOR: {
                    stack = new ItemStack(ModItems.ELECTRIC_ENGINE, 1, entity.getEngineTier().ordinal());
                }
            }
            if (!stack.func_190926_b()) {
                return RenderUtil.getModel(stack);
            }
        }
        return null;
    }
}

