/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import com.buuz135.industrial.tile.CustomSidedTileEntity;
import com.buuz135.industrial.utils.CraftingUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.LockedInventoryTogglePiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.FluidTankType;
import net.ndrei.teslacorelib.inventory.LockableItemHandler;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;
import org.jetbrains.annotations.NotNull;

public class FluidCrafterTile
extends CustomSidedTileEntity {
    private IFluidTank tank;
    private LockableItemHandler crafting;
    private ItemStackHandler output;
    private int tick;

    public FluidCrafterTile() {
        super(FluidCrafterTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.tank = this.addSimpleFluidTank(8000, "tank", EnumDyeColor.BLUE, 18, 25, FluidTankType.BOTH, fluidStack -> true, fluidStack -> true);
        this.crafting = (LockableItemHandler)this.addSimpleInventory(9, "crafting", EnumDyeColor.GREEN, "crafting", new BoundingRectangle(58, 25, 54, 54), (stack, integer) -> true, (stack, integer) -> false, true, null);
        this.output = (ItemStackHandler)this.addSimpleInventory(1, "output", EnumDyeColor.ORANGE, "output", new BoundingRectangle(148, 43, 18, 18), (stack, integer) -> false, (stack, integer) -> true, false, null);
        this.tick = 0;
    }

    protected void innerUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.tick;
        if (this.tick >= 40) {
            this.tick = 0;
        }
        if (this.crafting.getLocked() && this.tick == 0 && this.hasOnlyOneFluid()) {
            Fluid fluid = this.getRecipeFluid();
            if (fluid == null) {
                return;
            }
            int bucketAmount = this.getFluidAmount(fluid);
            FluidStack stack = this.tank.drain(bucketAmount * 1000, false);
            if (stack != null && stack.getFluid().equals(fluid) && stack.amount == bucketAmount * 1000) {
                IRecipe recipe = CraftingUtils.findRecipe(this.field_145850_b, this.simulateRecipeEntries(fluid));
                if (recipe == null || recipe.func_77571_b().func_190926_b()) {
                    return;
                }
                if (ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)recipe.func_77571_b().func_77946_l(), (boolean)true).func_190926_b() && this.areAllSolidsPresent(fluid)) {
                    NonNullList remaining = recipe.func_179532_b(CraftingUtils.genCraftingInventory(this.field_145850_b, this.simulateRecipeEntries(fluid)));
                    for (int i = 0; i < this.crafting.getSlots(); ++i) {
                        if (this.isStackCurrentFluid(fluid, this.crafting.getFilterStack(i))) continue;
                        if (((ItemStack)remaining.get(i)).func_190926_b()) {
                            this.crafting.getStackInSlot(i).func_190918_g(1);
                            continue;
                        }
                        this.crafting.setStackInSlot(i, ((ItemStack)remaining.get(i)).func_77946_l());
                    }
                    this.tank.drain(bucketAmount * 1000, true);
                    ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)recipe.func_77571_b().func_77946_l(), (boolean)false);
                }
            }
        }
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        this.tick = compound.func_74762_e("Tick");
        super.func_145839_a(compound);
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        NBTTagCompound compound1 = super.func_189515_b(compound);
        compound1.func_74768_a("Tick", this.tick);
        return compound1;
    }

    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer<?> container) {
        List pieces = super.getGuiContainerPieces(container);
        pieces.add(new BasicRenderedGuiPiece(118, 45, 25, 18, new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 24, 5));
        pieces.add(new LockedInventoryTogglePiece(116, 64, (SidedTileEntity)this, EnumDyeColor.GREEN));
        return pieces;
    }

    public Fluid getRecipeFluid() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().getFluid();
        }
        for (ItemStack stack : this.crafting.getFilter()) {
            IFluidHandlerItem fluidHandlerItem;
            if (stack.func_190926_b() || !stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || (fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) == null || fluidHandlerItem.drain(Integer.MAX_VALUE, false) == null) continue;
            return fluidHandlerItem.drain(Integer.MAX_VALUE, false).getFluid();
        }
        return null;
    }

    public int getFluidAmount(Fluid fluid) {
        int i = 0;
        for (ItemStack stack : this.crafting.getFilter()) {
            if (stack.func_190926_b() || !this.isStackCurrentFluid(fluid, stack)) continue;
            ++i;
        }
        return i;
    }

    public boolean areAllSolidsPresent(Fluid fluid) {
        for (int i = 0; i < this.crafting.getSlots(); ++i) {
            if (this.isStackCurrentFluid(fluid, this.crafting.getFilter()[i]) || this.crafting.getFilter()[i].func_190926_b() || !this.crafting.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private boolean isStackCurrentFluid(Fluid fluid, ItemStack stack) {
        if (!stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return false;
        }
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        return fluidHandlerItem != null && fluidHandlerItem.drain(Integer.MAX_VALUE, false) != null && fluidHandlerItem.drain(Integer.MAX_VALUE, false).getFluid().equals(fluid);
    }

    protected boolean supportsAddons() {
        return false;
    }

    public boolean hasOnlyOneFluid() {
        Fluid tankFluid = this.tank.getFluid() != null ? this.tank.getFluid().getFluid() : null;
        ArrayList<Fluid> fluids = new ArrayList<Fluid>();
        for (ItemStack stack : this.crafting.getFilter()) {
            IFluidHandlerItem fluidHandlerItem;
            FluidStack fluid;
            if (stack.func_190926_b() || !stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || (fluid = (fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(Integer.MAX_VALUE, false)) == null || fluids.contains(fluid.getFluid())) continue;
            fluids.add(fluid.getFluid());
        }
        if (tankFluid != null) {
            fluids.remove(tankFluid);
        }
        return fluids.size() <= 1;
    }

    public ItemStack[] simulateRecipeEntries(Fluid fluid) {
        ItemStack[] itemStacks = new ItemStack[9];
        for (int i = 0; i < this.crafting.getSlots(); ++i) {
            itemStacks[i] = this.crafting.getFilter()[i].func_190926_b() ? ItemStack.field_190927_a : (this.isStackCurrentFluid(fluid, this.crafting.getFilterStack(i)) ? this.crafting.getFilter()[i].func_77946_l() : this.crafting.getStackInSlot(i));
        }
        return itemStacks;
    }
}

