/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thut.api.TickHandler;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.maths.Matrix3;

public class BlockEntityUpdater {
    public static boolean autoBlacklist = false;
    final IBlockEntity blockEntity;
    final Entity theEntity;
    List<AxisAlignedBB> blockBoxes = Lists.newArrayList();
    Set<TileEntity> erroredSet = Sets.newHashSet();

    public static boolean isWhitelisted(TileEntity tile) {
        ResourceLocation id = TileEntity.func_190559_a(tile.getClass());
        return id == null ? true : !IBlockEntity.TEBLACKLIST.contains(id.toString());
    }

    public BlockEntityUpdater(IBlockEntity rocket) {
        this.blockEntity = rocket;
        this.theEntity = (Entity)rocket;
    }

    public void onSetPosition() {
        double xMin = this.theEntity.field_70165_t + (double)this.blockEntity.getMin().func_177958_n() - 0.5;
        double yMin = this.theEntity.field_70163_u + (double)this.blockEntity.getMin().func_177956_o();
        double zMin = this.theEntity.field_70161_v + (double)this.blockEntity.getMin().func_177952_p() - 0.5;
        double xMax = this.theEntity.field_70165_t + (double)this.blockEntity.getMax().func_177958_n() + 0.5;
        double yMax = this.theEntity.field_70163_u + (double)this.blockEntity.getMax().func_177956_o() + 1.0;
        double zMax = this.theEntity.field_70161_v + (double)this.blockEntity.getMax().func_177952_p() + 0.5;
        this.theEntity.func_174826_a(new AxisAlignedBB(xMin, yMin, zMin, xMax, yMax, zMax));
    }

    public void onUpdate() {
        if (this.blockEntity.getBlocks() == null) {
            return;
        }
        if (World.MAX_ENTITY_RADIUS < (double)this.blockEntity.getBlocks().length) {
            World.MAX_ENTITY_RADIUS = this.blockEntity.getBlocks().length;
        }
        if (World.MAX_ENTITY_RADIUS < (double)this.blockEntity.getBlocks()[0].length) {
            World.MAX_ENTITY_RADIUS = this.blockEntity.getBlocks()[0].length;
        }
        if (World.MAX_ENTITY_RADIUS < (double)this.blockEntity.getBlocks()[0][0].length) {
            World.MAX_ENTITY_RADIUS = this.blockEntity.getBlocks()[0][0].length;
        }
        this.theEntity.field_70131_O = this.blockEntity.getMax().func_177956_o();
        this.theEntity.field_70130_N = 1 + this.blockEntity.getMax().func_177958_n() - this.blockEntity.getMin().func_177958_n();
        if (this.theEntity.field_70181_x == 0.0) {
            this.theEntity.func_70107_b(this.theEntity.field_70165_t, (double)Math.round(this.theEntity.field_70163_u), this.theEntity.field_70161_v);
        }
        this.blockEntity.getFakeWorld().func_72912_H().func_82572_b(this.theEntity.func_130014_f_().func_82737_E());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int xMin = this.blockEntity.getMin().func_177958_n();
        int zMin = this.blockEntity.getMin().func_177952_p();
        int yMin = this.blockEntity.getMin().func_177956_o();
        int sizeX = this.blockEntity.getTiles().length;
        int sizeY = this.blockEntity.getTiles()[0].length;
        int sizeZ = this.blockEntity.getTiles()[0][0].length;
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    pos.func_189532_c((double)(i + xMin) + this.theEntity.field_70165_t, (double)(j + yMin) + this.theEntity.field_70163_u, (double)(k + zMin) + this.theEntity.field_70161_v);
                    TileEntity tile = this.blockEntity.getTiles()[i][j][k];
                    if (tile != null) {
                        tile.func_174878_a(pos.func_185334_h());
                        tile.func_145834_a((World)this.blockEntity.getFakeWorld());
                    }
                    if (!(tile instanceof ITickable) || this.erroredSet.contains(tile) || !BlockEntityUpdater.isWhitelisted(tile)) continue;
                    try {
                        ((ITickable)tile).func_73660_a();
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        System.err.println("Error with Tile Entity " + tile);
                        this.erroredSet.add(tile);
                        if (!autoBlacklist || TileEntity.func_190559_a(tile.getClass()) == null) continue;
                        IBlockEntity.TEBLACKLIST.add(TileEntity.func_190559_a(tile.getClass()).toString());
                    }
                }
            }
        }
    }

    public void applyEntityCollision(Entity entity) {
        if ((this.theEntity.field_70177_z + 360.0f) % 90.0f > 5.0f || this.theEntity.func_184196_w(entity)) {
            return;
        }
        this.blockBoxes.clear();
        int sizeX = this.blockEntity.getBlocks().length;
        int sizeY = this.blockEntity.getBlocks()[0].length;
        int sizeZ = this.blockEntity.getBlocks()[0][0].length;
        HashSet topY = Sets.newHashSet();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int xMin = this.blockEntity.getMin().func_177958_n();
        int yMin = this.blockEntity.getMin().func_177956_o();
        int zMin = this.blockEntity.getMin().func_177952_p();
        BlockPos origin = this.theEntity.func_180425_c();
        double minX = entity.func_174813_aQ().field_72340_a;
        double minY = entity.func_174813_aQ().field_72338_b;
        double minZ = entity.func_174813_aQ().field_72339_c;
        double maxX = entity.func_174813_aQ().field_72336_d;
        double maxY = entity.func_174813_aQ().field_72337_e;
        double maxZ = entity.func_174813_aQ().field_72334_f;
        Vector3f diffs = new Vector3f((float)(this.theEntity.field_70159_w - entity.field_70159_w), (float)(this.theEntity.field_70181_x - entity.field_70181_x), (float)(this.theEntity.field_70179_y - entity.field_70179_y));
        AxisAlignedBB boundingBox = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        AxisAlignedBB testBox = boundingBox.func_72321_a((double)(-diffs.x), (double)(-diffs.y), (double)(-diffs.z));
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    ArrayList toAdd = Lists.newArrayList();
                    pos.func_181079_c(i + xMin + origin.func_177958_n(), j + yMin + origin.func_177956_o(), k + zMin + origin.func_177952_p());
                    IBlockState state = this.blockEntity.getFakeWorld().func_180495_p((BlockPos)pos);
                    state = state.func_185899_b((IBlockAccess)this.blockEntity.getFakeWorld(), (BlockPos)pos);
                    try {
                        state.func_185908_a((World)this.blockEntity.getFakeWorld(), (BlockPos)pos, TileEntity.INFINITE_EXTENT_AABB, (List)toAdd, entity, false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (AxisAlignedBB blockBox : toAdd) {
                        float dz2;
                        float dy2;
                        float dx2;
                        AxisAlignedBB box;
                        if (blockBox == null || !(box = blockBox.func_72317_d((double)(dx2 = (float)(this.theEntity.field_70165_t - (double)origin.func_177958_n()) - 0.5f), (double)(dy2 = (float)(this.theEntity.field_70163_u - (double)origin.func_177956_o())), (double)(dz2 = (float)(this.theEntity.field_70161_v - (double)origin.func_177952_p()) - 0.5f))).func_72326_a(testBox)) continue;
                        this.blockBoxes.add(box);
                        topY.add(box.field_72337_e);
                    }
                }
            }
        }
        if (this.blockBoxes.isEmpty()) {
            return;
        }
        pos.func_189533_g((Vec3i)this.theEntity.func_180425_c());
        Vector3f temp1 = new Vector3f();
        boolean merge = true;
        if (merge) {
            Matrix3.mergeAABBs(this.blockBoxes, 0.0, 0.0, 0.0);
        }
        double lastTickMinY = minY + (double)diffs.y;
        double nextTickMinY = minY - (double)diffs.y;
        double lastTickMaxY = maxY + (double)diffs.y;
        double nextTickMaxY = maxY - (double)diffs.y;
        double lastTickMinX = minX + (double)diffs.x;
        double nextTickMinX = minX - (double)diffs.x;
        double lastTickMaxX = maxX + (double)diffs.x;
        double nextTickMaxX = maxX - (double)diffs.x;
        double lastTickMinZ = minZ + (double)diffs.z;
        double nextTickMinZ = minZ - (double)diffs.z;
        double lastTickMaxZ = maxZ + (double)diffs.z;
        double nextTickMaxZ = maxZ - (double)diffs.z;
        for (AxisAlignedBB aabb : this.blockBoxes) {
            double r;
            double dx = 10000.0;
            double dz = 10000.0;
            double dy = 10000.0;
            boolean fromAbove = lastTickMinY >= aabb.field_72337_e && nextTickMinY <= aabb.field_72337_e;
            boolean fromBelow = nextTickMaxY >= aabb.field_72338_b && lastTickMaxY <= aabb.field_72338_b;
            boolean yPos = minY <= aabb.field_72337_e && minY >= aabb.field_72338_b;
            boolean yNeg = maxY <= aabb.field_72337_e && maxY >= aabb.field_72338_b;
            boolean fromXPos = lastTickMinX >= aabb.field_72336_d && nextTickMinX <= aabb.field_72336_d;
            boolean fromXNeg = nextTickMaxX >= aabb.field_72340_a && lastTickMaxX <= aabb.field_72340_a;
            boolean xPos = minX <= aabb.field_72336_d && minX >= aabb.field_72340_a;
            boolean xNeg = maxX <= aabb.field_72336_d && maxX >= aabb.field_72340_a;
            boolean fromZPos = lastTickMinZ >= aabb.field_72334_f && nextTickMinZ <= aabb.field_72334_f;
            boolean fromZNeg = nextTickMaxZ >= aabb.field_72339_c && lastTickMaxZ <= aabb.field_72339_c;
            boolean zPos = minZ <= aabb.field_72334_f && minZ >= aabb.field_72339_c;
            boolean zNeg = maxZ <= aabb.field_72334_f && maxZ >= aabb.field_72339_c;
            boolean collidesXPos = xPos && zPos && zNeg;
            boolean collidesXNeg = xNeg && zPos && zNeg;
            boolean collidesZPos = zPos && xPos && xNeg;
            boolean collidesZNeg = zNeg && xPos && xNeg;
            boolean collidesYNeg = yNeg && (xPos || xNeg || zPos || zNeg);
            boolean collidesYPos = yPos && (xPos || xNeg || zPos || zNeg);
            boolean collided = false;
            if (!collided && fromAbove) {
                temp1.y = (float)Math.max(aabb.field_72337_e - (double)diffs.y - nextTickMinY, (double)temp1.y);
                collided = true;
            }
            if (!collided && fromBelow) {
                temp1.y = (float)Math.min(aabb.field_72338_b - (double)diffs.y - nextTickMaxY, (double)temp1.y);
                collided = true;
            }
            if (!collided && (fromXPos || collidesXPos)) {
                r = Math.max(aabb.field_72336_d - boundingBox.field_72340_a, (double)temp1.x);
                dx = Math.min(dx, r);
                collided = true;
            }
            if (!collided && (fromXNeg || collidesXNeg)) {
                r = Math.min(aabb.field_72340_a - boundingBox.field_72336_d, (double)temp1.x);
                dx = Math.min(dx, r);
                collided = true;
            }
            if (!collided && (fromZPos || collidesZPos)) {
                r = Math.max(aabb.field_72334_f - boundingBox.field_72339_c, (double)temp1.z);
                dz = Math.min(dz, r);
                collided = true;
            }
            if (!collided && (fromZNeg || collidesZNeg)) {
                r = Math.min(aabb.field_72339_c - boundingBox.field_72334_f, (double)temp1.z);
                dz = Math.min(dz, r);
                collided = true;
            }
            if (!collided && xPos && zPos) {
                r = Math.max(aabb.field_72334_f - boundingBox.field_72339_c, (double)temp1.z);
                dz = Math.min(dz, r);
                r = Math.max(aabb.field_72336_d - boundingBox.field_72340_a, (double)temp1.x);
                dx = Math.min(dx, r);
                collided = true;
            }
            if (!collided && xPos && zNeg) {
                r = Math.min(aabb.field_72339_c - boundingBox.field_72334_f, (double)temp1.z);
                dz = Math.min(dz, r);
                r = Math.max(aabb.field_72336_d - boundingBox.field_72340_a, (double)temp1.x);
                dx = Math.min(dx, r);
                collided = true;
            }
            if (!collided && xNeg && zNeg) {
                r = Math.min(aabb.field_72339_c - boundingBox.field_72334_f, (double)temp1.z);
                dz = Math.min(dz, r);
                r = Math.min(aabb.field_72340_a - boundingBox.field_72336_d, (double)temp1.x);
                dx = Math.min(dx, r);
                collided = true;
            }
            if (!collided && xNeg && zPos) {
                r = Math.max(aabb.field_72334_f - boundingBox.field_72339_c, (double)temp1.z);
                dz = Math.min(dz, r);
                r = Math.min(aabb.field_72340_a - boundingBox.field_72336_d, (double)temp1.x);
                dx = Math.min(dx, r);
                collided = true;
            }
            if (collidesYNeg) {
                r = (float)Math.min(aabb.field_72338_b - (double)diffs.y - nextTickMaxY, (double)temp1.y);
                dy = Math.min(r, dy);
            } else if (collidesYPos) {
                r = (float)Math.max(aabb.field_72337_e - (double)diffs.y - nextTickMinY, (double)temp1.y);
                dy = Math.min(r, dy);
            }
            double dy1 = Math.abs(dy);
            double dz1 = Math.abs(dz);
            double dx1 = Math.abs(dx);
            if (dy1 < dx1 && dy1 < dz1) {
                temp1.y = (float)dy;
                continue;
            }
            if (dx1 < dy1 && dx1 < dz1) {
                temp1.x = (float)dx;
                continue;
            }
            if (!(dz < 1000.0)) continue;
            temp1.z = (float)dz;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.func_130014_f_().field_72995_K && (Minecraft.func_71410_x().field_71474_y.field_74336_f || TickHandler.playerTickTracker.containsKey(player.func_110124_au()))) {
                TickHandler.playerTickTracker.put(player.func_110124_au(), (int)(System.currentTimeMillis() % 2000L));
                Minecraft.func_71410_x().field_71474_y.field_74336_f = false;
            }
            if (player.func_130014_f_().field_72995_K) {
                player.getEntityData().func_74768_a("lastStandTick", player.field_70173_aa);
            }
            if (!player.field_71075_bZ.field_75100_b) {
                entity.field_70122_E = true;
                entity.func_180430_e(entity.field_70143_R, 0.0f);
                entity.field_70143_R = 0.0f;
            }
            if (!player.field_71075_bZ.field_75098_d && !player.func_130014_f_().field_72995_K) {
                EntityPlayerMP entityplayer = (EntityPlayerMP)player;
                entityplayer.field_71135_a.field_147365_f = 0;
            }
        }
        if (temp1.lengthSquared() > 0.0f) {
            if (temp1.y >= 0.0f) {
                entity.field_70122_E = true;
                entity.func_180430_e(entity.field_70143_R, 0.0f);
                entity.field_70143_R = 0.0f;
            }
            if (temp1.x != 0.0f) {
                entity.field_70159_w = this.theEntity.field_70159_w;
            }
            if (temp1.y != 0.0f) {
                entity.field_70181_x = this.theEntity.field_70181_x;
            }
            if (temp1.z != 0.0f) {
                entity.field_70179_y = this.theEntity.field_70179_y;
            }
            if (!(entity instanceof EntityPlayerMP)) {
                entity.func_70091_d(MoverType.SELF, (double)temp1.x, (double)temp1.y, (double)temp1.z);
            }
            entity.field_70169_q = entity.field_70165_t;
            entity.field_70167_r = entity.field_70163_u;
            entity.field_70166_s = entity.field_70161_v;
            entity.field_70127_C = entity.field_70125_A;
            entity.field_70126_B = entity.field_70177_z;
        }
    }
}

