/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thut.api.entity.blockentity.IBlockEntity;

public class BlockEntityWorld
extends World {
    final World world;
    final IBlockEntity blockEntity;
    final Entity entity;
    public boolean creating;
    private Map<BlockPos, Chunk> chunks = Maps.newHashMap();
    private BlockPos lastOrigin = null;

    public BlockEntityWorld(IBlockEntity lift, World world) {
        super(world.func_72860_G(), world.func_72912_H(), world.field_73011_w, world.field_72984_F, world.field_72995_K);
        this.world = world;
        this.blockEntity = lift;
        this.entity = (Entity)lift;
        int xMin = this.blockEntity.getMin().func_177958_n();
        int zMin = this.blockEntity.getMin().func_177952_p();
        int yMin = this.blockEntity.getMin().func_177956_o();
        if (this.blockEntity.getBlocks() == null) {
            this.entity.func_70106_y();
            return;
        }
        int sizeX = this.blockEntity.getBlocks().length;
        int sizeY = this.blockEntity.getBlocks()[0].length;
        int sizeZ = this.blockEntity.getBlocks()[0][0].length;
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    if (this.blockEntity.getTiles()[i][j][k] == null) continue;
                    BlockPos pos = new BlockPos((double)(i + xMin) + this.entity.field_70165_t, (double)(j + yMin) + this.entity.field_70163_u, (double)(k + zMin) + this.entity.field_70161_v);
                    this.blockEntity.getTiles()[i][j][k].func_145834_a(world);
                    this.blockEntity.getTiles()[i][j][k].func_174878_a(pos);
                    this.blockEntity.getTiles()[i][j][k].func_145829_t();
                }
            }
        }
    }

    @Nullable
    public EntityPlayer func_184137_a(double posX, double posY, double posZ, double distance, boolean spectator) {
        return this.world.func_184137_a(posX, posY, posZ, distance, spectator);
    }

    @Nullable
    public EntityPlayer func_184150_a(double posX, double posY, double posZ, double maxXZDistance, double maxYDistance, @Nullable Function<EntityPlayer, Double> playerToDouble, @Nullable Predicate<EntityPlayer> p_184150_12_) {
        return this.world.func_184150_a(posX, posY, posZ, maxXZDistance, maxYDistance, playerToDouble, p_184150_12_);
    }

    public TileEntity func_175625_s(BlockPos pos) {
        if (this.blockEntity.getTiles() == null) {
            return this.world.func_175625_s(pos);
        }
        int i = pos.func_177958_n() - MathHelper.func_76128_c((double)(this.entity.field_70165_t + (double)this.blockEntity.getMin().func_177958_n()));
        int j = (int)((long)pos.func_177956_o() - Math.round(this.entity.field_70163_u + (double)this.blockEntity.getMin().func_177956_o()));
        int k = pos.func_177952_p() - MathHelper.func_76128_c((double)(this.entity.field_70161_v + (double)this.blockEntity.getMin().func_177952_p()));
        if (!this.inBounds(pos)) {
            return this.world.func_175625_s(pos);
        }
        TileEntity tile = this.blockEntity.getTiles()[i][j][k];
        if (tile != null) {
            tile.func_145834_a((World)this);
            boolean invalid = tile.func_145837_r();
            if (!invalid) {
                tile.func_145843_s();
            }
            tile.func_174878_a(pos.func_185334_h());
            tile.func_145829_t();
        }
        return tile;
    }

    public void func_175690_a(BlockPos pos, @Nullable TileEntity tileEntityIn) {
        if (this.blockEntity.getTiles() == null) {
            return;
        }
        int i = pos.func_177958_n() - MathHelper.func_76128_c((double)(this.entity.field_70165_t + (double)this.blockEntity.getMin().func_177958_n()));
        int j = (int)((long)pos.func_177956_o() - Math.round(this.entity.field_70163_u + (double)this.blockEntity.getMin().func_177956_o()));
        int k = pos.func_177952_p() - MathHelper.func_76128_c((double)(this.entity.field_70161_v + (double)this.blockEntity.getMin().func_177952_p()));
        if (!this.inBounds(pos)) {
            return;
        }
        this.blockEntity.getTiles()[i][j][k] = tileEntityIn;
        tileEntityIn.func_145834_a((World)this);
        tileEntityIn.func_174878_a(pos.func_185334_h());
    }

    @SideOnly(value=Side.CLIENT)
    public int func_175626_b(BlockPos pos, int lightValue) {
        return 0xF000F0;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        if (this.blockEntity.getBlocks() == null) {
            return this.world.func_180495_p(pos);
        }
        int i = pos.func_177958_n() - MathHelper.func_76128_c((double)(this.entity.field_70165_t + (double)this.blockEntity.getMin().func_177958_n()));
        int j = (int)((long)pos.func_177956_o() - Math.round(this.entity.field_70163_u + (double)this.blockEntity.getMin().func_177956_o()));
        int k = pos.func_177952_p() - MathHelper.func_76128_c((double)(this.entity.field_70161_v + (double)this.blockEntity.getMin().func_177952_p()));
        if (!this.inBounds(pos)) {
            return this.world.func_180495_p(pos);
        }
        IBlockState state = this.blockEntity.getBlocks()[i][j][k];
        if (state == null) {
            return this.world.func_180495_p(pos);
        }
        return state;
    }

    private boolean inBounds(BlockPos pos) {
        int i = pos.func_177958_n() - MathHelper.func_76128_c((double)(this.entity.field_70165_t + (double)this.blockEntity.getMin().func_177958_n()));
        int j = (int)((long)pos.func_177956_o() - Math.round(this.entity.field_70163_u + (double)this.blockEntity.getMin().func_177956_o()));
        int k = pos.func_177952_p() - MathHelper.func_76128_c((double)(this.entity.field_70161_v + (double)this.blockEntity.getMin().func_177952_p()));
        return i < this.blockEntity.getBlocks().length && j < this.blockEntity.getBlocks()[0].length && k < this.blockEntity.getBlocks()[0][0].length && i >= 0 && j >= 0 && k >= 0;
    }

    private boolean intersects(AxisAlignedBB other) {
        BlockPos pos = this.entity.func_180425_c();
        AxisAlignedBB thisBox = new AxisAlignedBB(this.blockEntity.getMin().func_177971_a((Vec3i)pos).func_177982_a(-1, -1, -1), this.blockEntity.getMax().func_177971_a((Vec3i)pos).func_177982_a(1, 1, 1));
        return thisBox.func_72326_a(other);
    }

    public boolean func_175623_d(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.world.func_180494_b(pos);
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.world.func_175627_a(pos, direction);
    }

    public WorldType func_175624_G() {
        return this.world.func_175624_G();
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
    }

    protected IChunkProvider func_72970_h() {
        return null;
    }

    public Chunk func_72964_e(int chunkX, int chunkZ) {
        AxisAlignedBB chunkBox = new AxisAlignedBB((double)(chunkX * 16), 0.0, (double)(chunkZ * 16), (double)(chunkX * 16 + 15), (double)this.world.func_72800_K(), (double)(chunkZ * 16 + 15));
        if (!this.intersects(chunkBox)) {
            return this.world.func_72964_e(chunkX, chunkZ);
        }
        if (this.lastOrigin == null || !this.lastOrigin.equals((Object)this.entity.func_180425_c())) {
            this.lastOrigin = this.entity.func_180425_c();
            this.chunks.clear();
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        pos.func_181079_c(chunkX, 0, chunkZ);
        BlockPos immut = pos.func_185334_h();
        if (this.chunks.containsKey(immut)) {
            return this.chunks.get(immut);
        }
        Chunk ret = new Chunk((World)this, chunkX, chunkZ);
        this.chunks.put(immut, ret);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int k = 0; k < 16; ++k) {
                    int x = chunkX * 16 + i;
                    int y = j;
                    int z = chunkZ * 16 + k;
                    pos.func_181079_c(x, y, z);
                    IBlockState state = this.func_180495_p((BlockPos)pos);
                    if (state.func_177230_c() == Blocks.field_150350_a) continue;
                    ExtendedBlockStorage storage = ret.func_76587_i()[j >> 4];
                    if (storage == null) {
                        ret.func_76587_i()[j >> 4] = storage = new ExtendedBlockStorage(j >> 4 << 4, this.world.field_73011_w.func_191066_m());
                    }
                    storage.func_177484_a(i & 0xF, j & 0xF, k & 0xF, state);
                    TileEntity tile = this.func_175625_s((BlockPos)pos);
                    if (tile == null) continue;
                    ret.func_150813_a(tile);
                }
            }
        }
        return ret;
    }

    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return false;
    }

    public boolean func_180501_a(BlockPos pos, IBlockState newState, int flags) {
        int i = pos.func_177958_n() - MathHelper.func_76128_c((double)(this.entity.field_70165_t + (double)this.blockEntity.getMin().func_177958_n()));
        int j = (int)((long)pos.func_177956_o() - Math.round(this.entity.field_70163_u + (double)this.blockEntity.getMin().func_177956_o()));
        int k = pos.func_177952_p() - MathHelper.func_76128_c((double)(this.entity.field_70161_v + (double)this.blockEntity.getMin().func_177952_p()));
        if (this.blockEntity.getBlocks() == null) {
            return false;
        }
        if (!this.inBounds(pos)) {
            return false;
        }
        this.blockEntity.getBlocks()[i][j][k] = newState;
        return true;
    }

    public World getWorld() {
        return this.world;
    }

    public IBlockEntity getEntity() {
        return this.blockEntity;
    }
}

