/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thut.api.entity.blockentity.BlockEntityUpdater;
import thut.api.entity.blockentity.BlockEntityWorld;

public interface IBlockEntity {
    public static final Set<ResourceLocation> BLOCKBLACKLIST = Sets.newHashSet();
    public static final Set<String> TEBLACKLIST = Sets.newHashSet();
    public static final BiMap<Class<?>, ITileRemover> CUSTOMREMOVERS = HashBiMap.create();
    public static final List<ITileRemover> SORTEDREMOVERS = Lists.newArrayList();
    public static final ITileRemover DEFAULTREMOVER = new ITileRemover(){

        @Override
        public void preBlockRemoval(TileEntity tileIn) {
            tileIn.func_145843_s();
        }

        @Override
        public void postBlockRemoval(TileEntity tileIn) {
        }
    };

    public static void addRemover(ITileRemover remover, Class<?> clas) {
        CUSTOMREMOVERS.put(clas, (Object)remover);
        SORTEDREMOVERS.add(remover);
        Collections.sort(SORTEDREMOVERS, new Comparator<ITileRemover>(){

            @Override
            public int compare(ITileRemover o1, ITileRemover o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
    }

    public static ITileRemover getRemover(TileEntity tile) {
        ITileRemover ret = (ITileRemover)CUSTOMREMOVERS.get(tile.getClass());
        if (ret != null) {
            return ret;
        }
        for (ITileRemover temp : SORTEDREMOVERS) {
            Class key = (Class)CUSTOMREMOVERS.inverse().get((Object)temp);
            if (!key.isInstance(tile)) continue;
            return temp;
        }
        return DEFAULTREMOVER;
    }

    public void setBlocks(IBlockState[][][] var1);

    public IBlockState[][][] getBlocks();

    public void setTiles(TileEntity[][][] var1);

    public TileEntity[][][] getTiles();

    public BlockPos getMin();

    public BlockPos getMax();

    public void setMin(BlockPos var1);

    public void setMax(BlockPos var1);

    public BlockEntityWorld getFakeWorld();

    public void setFakeWorld(BlockEntityWorld var1);

    default public boolean shouldHide(BlockPos pos) {
        TileEntity tile = this.getFakeWorld().func_175625_s(pos);
        return tile != null && !BlockEntityUpdater.isWhitelisted(tile);
    }

    public static class BlockEntityFormer {
        private static final Logger LOGGER = LogManager.getLogger();

        public static RayTraceResult rayTraceInternal(Vec3d start, Vec3d end, IBlockEntity toTrace) {
            return toTrace.getFakeWorld().func_147447_a(start, end, false, true, false);
        }

        public static void removeBlocks(World world, BlockPos min, BlockPos max, BlockPos pos) {
            ITileRemover tileHandler;
            TileEntity tile;
            int k;
            int j;
            int i;
            int xMin = min.func_177958_n();
            int zMin = min.func_177952_p();
            int xMax = max.func_177958_n();
            int zMax = max.func_177952_p();
            int yMin = min.func_177956_o();
            int yMax = max.func_177956_o();
            BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos();
            for (i = xMin; i <= xMax; ++i) {
                for (j = yMin; j <= yMax; ++j) {
                    for (k = zMin; k <= zMax; ++k) {
                        temp.func_181079_c(pos.func_177958_n() + i, pos.func_177956_o() + j, pos.func_177952_p() + k);
                        tile = world.func_175625_s((BlockPos)temp);
                        tileHandler = null;
                        if (tile == null) continue;
                        tileHandler = IBlockEntity.getRemover(tile);
                        tileHandler.preBlockRemoval(tile);
                    }
                }
            }
            for (i = xMin; i <= xMax; ++i) {
                for (j = yMin; j <= yMax; ++j) {
                    for (k = zMin; k <= zMax; ++k) {
                        temp.func_181079_c(pos.func_177958_n() + i, pos.func_177956_o() + j, pos.func_177952_p() + k);
                        tile = world.func_175625_s((BlockPos)temp);
                        tileHandler = null;
                        if (tile != null) {
                            tileHandler = IBlockEntity.getRemover(tile);
                            System.out.println(tile.func_145837_r() + " " + tile + " " + tile.func_145831_w());
                        }
                        world.func_180501_a((BlockPos)temp, Blocks.field_150350_a.func_176223_P(), 2);
                        if (tileHandler == null) continue;
                        tileHandler.postBlockRemoval(tile);
                    }
                }
            }
            for (i = xMin; i <= xMax; ++i) {
                for (j = yMin; j <= yMax; ++j) {
                    for (k = zMin; k <= zMax; ++k) {
                        temp.func_181079_c(pos.func_177958_n() + i, pos.func_177956_o() + j, pos.func_177952_p() + k);
                        world.func_180501_a((BlockPos)temp, Blocks.field_150350_a.func_176223_P(), 3);
                    }
                }
            }
        }

        public static IBlockState[][][] checkBlocks(World world, BlockPos min, BlockPos max, BlockPos pos) {
            int xMin = min.func_177958_n();
            int zMin = min.func_177952_p();
            int xMax = max.func_177958_n();
            int zMax = max.func_177952_p();
            int yMin = min.func_177956_o();
            int yMax = max.func_177956_o();
            IBlockState[][][] ret = new IBlockState[xMax - xMin + 1][yMax - yMin + 1][zMax - zMin + 1];
            boolean valid = false;
            for (int i = xMin; i <= xMax; ++i) {
                for (int j = yMin; j <= yMax; ++j) {
                    for (int k = zMin; k <= zMax; ++k) {
                        BlockPos temp = pos.func_177982_a(i, j, k);
                        IBlockState state = world.func_180495_p(temp);
                        if (BLOCKBLACKLIST.contains(state.func_177230_c().getRegistryName())) {
                            return null;
                        }
                        valid = valid || !state.func_177230_c().isAir(state, (IBlockAccess)world, pos);
                        ret[i - xMin][j - yMin][k - zMin] = state;
                    }
                }
            }
            return valid ? ret : (IBlockState[][][])null;
        }

        public static void RevertEntity(IBlockEntity toRevert) {
            int xMin = toRevert.getMin().func_177958_n();
            int zMin = toRevert.getMin().func_177952_p();
            int yMin = toRevert.getMin().func_177956_o();
            if (toRevert.getBlocks() == null) {
                return;
            }
            int sizeX = toRevert.getBlocks().length;
            int sizeY = toRevert.getBlocks()[0].length;
            int sizeZ = toRevert.getBlocks()[0][0].length;
            Entity entity = (Entity)toRevert;
            for (int i = 0; i < sizeX; ++i) {
                for (int j = 0; j < sizeY; ++j) {
                    for (int k = 0; k < sizeZ; ++k) {
                        TileEntity newTile;
                        BlockPos pos = new BlockPos((double)(i + xMin) + entity.field_70165_t, (double)(j + yMin) + entity.field_70163_u, (double)(k + zMin) + entity.field_70161_v);
                        IBlockState state = toRevert.getFakeWorld().func_180495_p(pos);
                        TileEntity tile = toRevert.getFakeWorld().func_175625_s(pos);
                        if (state == null) continue;
                        entity.func_130014_f_().func_175656_a(pos, state);
                        if (tile == null || (newTile = entity.func_130014_f_().func_175625_s(pos)) == null) continue;
                        newTile.func_145839_a(tile.func_189515_b(new NBTTagCompound()));
                    }
                }
            }
            List possibleInside = entity.func_130014_f_().func_72839_b(entity, entity.func_174813_aQ());
            for (Entity e : possibleInside) {
                e.func_70107_b(e.field_70165_t, e.field_70163_u + 0.25, e.field_70161_v);
            }
        }

        public static TileEntity[][][] checkTiles(World world, BlockPos min, BlockPos max, BlockPos pos) {
            int xMin = min.func_177958_n();
            int zMin = min.func_177952_p();
            int xMax = max.func_177958_n();
            int zMax = max.func_177952_p();
            int yMin = min.func_177956_o();
            int yMax = max.func_177956_o();
            TileEntity[][][] ret = new TileEntity[xMax - xMin + 1][yMax - yMin + 1][zMax - zMin + 1];
            for (int i = xMin; i <= xMax; ++i) {
                for (int j = yMin; j <= yMax; ++j) {
                    for (int k = zMin; k <= zMax; ++k) {
                        BlockPos temp = pos.func_177982_a(i, j, k);
                        TileEntity old = world.func_175625_s(temp);
                        if (old == null) continue;
                        NBTTagCompound tag = new NBTTagCompound();
                        tag = old.func_189515_b(tag);
                        ret[i - xMin][j - yMin][k - zMin] = BlockEntityFormer.makeTile(tag);
                    }
                }
            }
            return ret;
        }

        public static TileEntity makeTile(NBTTagCompound compound) {
            TileEntity tileentity = null;
            String s = compound.func_74779_i("id");
            Class oclass = null;
            try {
                Field F = TileEntity.class.getDeclaredFields()[1];
                F.setAccessible(true);
                RegistryNamespaced registry = (RegistryNamespaced)F.get(null);
                oclass = (Class)registry.func_82594_a((Object)new ResourceLocation(s));
                if (oclass != null) {
                    tileentity = (TileEntity)oclass.newInstance();
                }
            }
            catch (Throwable throwable1) {
                LOGGER.error("Failed to create block entity " + s, throwable1);
                FMLLog.log((Level)Level.ERROR, (Throwable)throwable1, (String)"A TileEntity %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", (Object[])new Object[]{s, oclass.getName()});
            }
            if (tileentity != null) {
                try {
                    tileentity.func_145839_a(compound);
                }
                catch (Throwable throwable) {
                    LOGGER.error("Failed to load data for block entity " + s, throwable);
                    FMLLog.log((Level)Level.ERROR, (Throwable)throwable, (String)"A TileEntity %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", (Object[])new Object[]{s, oclass.getName()});
                    tileentity = null;
                }
            } else {
                LOGGER.warn("Skipping BlockEntity with id " + s);
            }
            return tileentity;
        }

        public static <T extends Entity> T makeBlockEntity(World world, BlockPos min, BlockPos max, BlockPos pos, Class<T> clas) {
            Entity ret = null;
            try {
                ret = (Entity)clas.getConstructor(World.class).newInstance(world);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
            if (!(ret instanceof IBlockEntity)) {
                throw new ClassCastException("Cannot cast " + clas + " to IBlockEntity");
            }
            AxisAlignedBB box = new AxisAlignedBB(min, max);
            min = new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c);
            max = new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f);
            IBlockEntity entity = (IBlockEntity)ret;
            ret.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            IBlockState[][][] blocks = BlockEntityFormer.checkBlocks(world, min, max, pos);
            if (blocks == null) {
                return null;
            }
            entity.setBlocks(blocks);
            entity.setTiles(BlockEntityFormer.checkTiles(world, min, max, pos));
            entity.setMin(min);
            entity.setMax(max);
            BlockEntityFormer.removeBlocks(world, min, max, pos);
            world.func_72838_d(ret);
            return (T)ret;
        }
    }

    public static interface ITileRemover {
        public void preBlockRemoval(TileEntity var1);

        public void postBlockRemoval(TileEntity var1);

        default public int getPriority() {
            return 0;
        }
    }
}

