/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import thut.api.terrain.BiomeType;
import thut.api.terrain.TerrainSegment;

public class CapabilityTerrain {
    @CapabilityInject(value=ITerrainProvider.class)
    public static final Capability<ITerrainProvider> TERRAIN_CAP = null;

    public static class Storage
    implements Capability.IStorage<ITerrainProvider> {
        public NBTBase writeNBT(Capability<ITerrainProvider> capability, ITerrainProvider instance, EnumFacing side) {
            if (instance instanceof DefaultProvider) {
                return ((DefaultProvider)instance).serializeNBT();
            }
            return null;
        }

        public void readNBT(Capability<ITerrainProvider> capability, ITerrainProvider instance, EnumFacing side, NBTBase base) {
            if (instance instanceof DefaultProvider && base instanceof NBTTagCompound) {
                ((DefaultProvider)instance).deserializeNBT((NBTTagCompound)base);
            }
        }
    }

    public static class DefaultProvider
    implements ITerrainProvider,
    ICapabilityProvider,
    INBTSerializable<NBTTagCompound> {
        private BlockPos pos;
        private final Chunk chunk;
        private TerrainSegment[] segments = new TerrainSegment[16];

        public DefaultProvider() {
            this.chunk = null;
        }

        public DefaultProvider(Chunk chunk) {
            this.chunk = chunk;
        }

        @Override
        public TerrainSegment getTerrainSegement(BlockPos blockLocation) {
            int chunkY = blockLocation.func_177956_o() / 16 & 0xF;
            TerrainSegment segment = this.getTerrainSegment(chunkY);
            segment.getCentre().addTo(0.0, 256 * (blockLocation.func_177956_o() / 256), 0.0);
            return segment;
        }

        @Override
        public void setTerrainSegment(TerrainSegment segment, int chunkY) {
            this.segments[chunkY &= 0xF] = segment;
        }

        @Override
        public TerrainSegment getTerrainSegment(int chunkY) {
            TerrainSegment ret = this.segments[chunkY &= 0xF];
            if (ret == null) {
                ret = this.segments[chunkY] = new TerrainSegment(this.getChunkPos().func_177958_n(), chunkY, this.getChunkPos().func_177952_p());
                ret.chunk = this.chunk;
            }
            return ret;
        }

        @Override
        public BlockPos getChunkPos() {
            if (this.pos == null) {
                this.pos = new BlockPos(this.chunk.field_76635_g, 0, this.chunk.field_76647_h);
            }
            return this.pos;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == TERRAIN_CAP;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)this;
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            for (int i = 0; i < 16; ++i) {
                TerrainSegment t = this.getTerrainSegment(i);
                if (t == null) continue;
                t.checkToSave();
                if (!t.toSave) continue;
                NBTTagCompound terrainTag = new NBTTagCompound();
                t.saveToNBT(terrainTag);
                nbt.func_74782_a("" + i, (NBTBase)terrainTag);
            }
            NBTTagList biomeList = new NBTTagList();
            for (BiomeType t : BiomeType.values()) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("name", t.name);
                tag.func_74768_a("id", t.getType());
                biomeList.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("ids", (NBTBase)biomeList);
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            BlockPos pos = this.getChunkPos();
            int x = pos.func_177958_n();
            int z = pos.func_177952_p();
            HashMap idReplacements = Maps.newHashMap();
            NBTTagList tags = (NBTTagList)nbt.func_74781_a("ids");
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                NBTTagCompound tag = tags.func_150305_b(i);
                String name = tag.func_74779_i("name");
                int id = tag.func_74762_e("id");
                BiomeType type = BiomeType.getBiome(name, false);
                if (type.getType() == id) continue;
                idReplacements.put(id, type.getType());
            }
            boolean hasReplacements = !idReplacements.isEmpty();
            for (int i = 0; i < 16; ++i) {
                NBTTagCompound terrainTag = null;
                try {
                    terrainTag = nbt.func_74775_l(i + "");
                }
                catch (Exception id) {
                    // empty catch block
                }
                TerrainSegment t = null;
                if (terrainTag != null && !terrainTag.func_82582_d() && !TerrainSegment.noLoad) {
                    t = new TerrainSegment(x, i, z);
                    if (hasReplacements) {
                        t.idReplacements = idReplacements;
                    }
                    TerrainSegment.readFromNBT(t, terrainTag);
                    this.setTerrainSegment(t, i);
                    t.idReplacements = null;
                }
                if (t != null) continue;
                t = new TerrainSegment(x, i, z);
                this.setTerrainSegment(t, i);
            }
        }
    }

    public static interface ITerrainProvider {
        public TerrainSegment getTerrainSegement(BlockPos var1);

        public void setTerrainSegment(TerrainSegment var1, int var2);

        public TerrainSegment getTerrainSegment(int var1);

        public BlockPos getChunkPos();
    }
}

