/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model;

import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import thut.core.client.render.model.Vector6f;

public class VectorMath {
    static final Vector3f X_AXIS = new Vector3f(1.0f, 0.0f, 0.0f);
    static final Vector3f Y_AXIS = new Vector3f(0.0f, 1.0f, 0.0f);
    static final Vector3f Z_AXIS = new Vector3f(0.0f, 0.0f, 1.0f);

    public static void cleanSmall(Matrix4f matrix) {
        if ((double)Math.abs(matrix.m00) < 1.0E-6) {
            matrix.m00 = 0.0f;
        }
        if ((double)Math.abs(matrix.m01) < 1.0E-6) {
            matrix.m01 = 0.0f;
        }
        if ((double)Math.abs(matrix.m02) < 1.0E-6) {
            matrix.m02 = 0.0f;
        }
        if ((double)Math.abs(matrix.m03) < 1.0E-6) {
            matrix.m03 = 0.0f;
        }
        if ((double)Math.abs(matrix.m10) < 1.0E-6) {
            matrix.m10 = 0.0f;
        }
        if ((double)Math.abs(matrix.m11) < 1.0E-6) {
            matrix.m11 = 0.0f;
        }
        if ((double)Math.abs(matrix.m12) < 1.0E-6) {
            matrix.m12 = 0.0f;
        }
        if ((double)Math.abs(matrix.m13) < 1.0E-6) {
            matrix.m13 = 0.0f;
        }
        if ((double)Math.abs(matrix.m20) < 1.0E-6) {
            matrix.m20 = 0.0f;
        }
        if ((double)Math.abs(matrix.m21) < 1.0E-6) {
            matrix.m21 = 0.0f;
        }
        if ((double)Math.abs(matrix.m22) < 1.0E-6) {
            matrix.m22 = 0.0f;
        }
        if ((double)Math.abs(matrix.m23) < 1.0E-6) {
            matrix.m23 = 0.0f;
        }
        if ((double)Math.abs(matrix.m30) < 1.0E-6) {
            matrix.m30 = 0.0f;
        }
        if ((double)Math.abs(matrix.m31) < 1.0E-6) {
            matrix.m31 = 0.0f;
        }
        if ((double)Math.abs(matrix.m32) < 1.0E-6) {
            matrix.m32 = 0.0f;
        }
        if ((double)Math.abs(matrix.m33) < 1.0E-6) {
            matrix.m33 = 0.0f;
        }
    }

    public static Matrix4f fromFloat(float val) {
        return VectorMath.fromVector6f(val, val, val, val, val, val);
    }

    public static Matrix4f fromFloatArray(float[] vals) {
        return VectorMath.fromVector6f(vals[0], vals[1], vals[2], vals[3], vals[4], vals[5]);
    }

    public static Matrix4f fromVector6f(float xl, float yl, float zl, float xr, float yr, float zr) {
        Vector3f loc = new Vector3f(xl, yl, zl);
        Matrix4f ret = new Matrix4f();
        ret.translate(loc);
        ret.rotate(zr, Z_AXIS);
        ret.rotate(yr, Y_AXIS);
        ret.rotate(xr, X_AXIS);
        VectorMath.cleanSmall(ret);
        return ret;
    }

    public static Matrix4f fromVector6f(Vector6f vector) {
        Matrix4f ret = new Matrix4f();
        ret.translate(vector.vector1);
        ret.rotate(vector.vector2.z, Z_AXIS);
        ret.rotate(vector.vector2.y, Y_AXIS);
        ret.rotate(vector.vector2.x, X_AXIS);
        VectorMath.cleanSmall(ret);
        return ret;
    }
}

