/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.commands;

import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class CommandTools {
    public static boolean isOp(ICommandSender sender, String permission) {
        if (sender instanceof EntityPlayerMP) {
            if (!PermissionAPI.getPermissionHandler().getRegisteredNodes().contains(permission)) {
                String message = "Autogenerated node, this is a bug and should be pre-registered.";
                PermissionAPI.getPermissionHandler().registerNode(permission, DefaultPermissionLevel.OP, message);
                System.err.println(message + ": " + permission);
            }
            return PermissionAPI.hasPermission((EntityPlayer)((EntityPlayerMP)sender), (String)permission);
        }
        return true;
    }

    public static ITextComponent makeError(String text) {
        return CommandTools.makeTranslatedMessage(text, "red:italic", new Object[0]);
    }

    public static ITextComponent makeTranslatedMessage(String key, String formatting, Object ... args) {
        if (formatting == null) {
            formatting = "";
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof String) {
                args[i] = new TextComponentTranslation((String)args[i], new Object[0]);
            }
            if (formatting.isEmpty() || !(args[i] instanceof ITextComponent)) continue;
            ITextComponent component = (ITextComponent)args[i];
            String[] args2 = formatting.split(":");
            String colour = args2[0].toUpperCase(Locale.ENGLISH);
            component.func_150256_b().func_150238_a(TextFormatting.func_96300_b((String)colour));
            if (args2.length <= 1) continue;
            for (int i1 = 1; i1 < args2.length; ++i1) {
                String arg = args2[i1];
                if (arg.equalsIgnoreCase("italic")) {
                    component.func_150256_b().func_150217_b(Boolean.valueOf(true));
                }
                if (arg.equalsIgnoreCase("bold")) {
                    component.func_150256_b().func_150227_a(Boolean.valueOf(true));
                }
                if (arg.equalsIgnoreCase("underlined")) {
                    component.func_150256_b().func_150228_d(Boolean.valueOf(true));
                }
                if (arg.equalsIgnoreCase("strikethrough")) {
                    component.func_150256_b().func_150225_c(Boolean.valueOf(true));
                }
                if (!arg.equalsIgnoreCase("obfuscated")) continue;
                component.func_150256_b().func_150237_e(Boolean.valueOf(true));
            }
        }
        TextComponentTranslation translated = new TextComponentTranslation(key, args);
        return translated;
    }

    public static void sendBadArgumentsMissingArg(ICommandSender sender) {
        sender.func_145747_a(CommandTools.makeError("pokecube.command.invalidmissing"));
    }

    public static void sendBadArgumentsTryTab(ICommandSender sender) {
        sender.func_145747_a(CommandTools.makeError("pokecube.command.invalidtab"));
    }

    public static void sendError(ICommandSender sender, String text) {
        sender.func_145747_a(CommandTools.makeError(text));
    }

    public static void sendMessage(ICommandSender sender, String text) {
        ITextComponent message = CommandTools.makeTranslatedMessage(text, null, new Object[0]);
        sender.func_145747_a(message);
    }

    public static void sendNoPermissions(ICommandSender sender) {
        sender.func_145747_a(CommandTools.makeError("pokecube.command.noperms"));
    }
}

