/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.compat;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import thut.core.common.ThutCore;
import thut.lib.CompatClass;
import thut.lib.CompatParser;

@Mod(modid="thutcore_compat", name="ThutCore Compat", version="1.0", acceptedMinecraftVersions="*", acceptableRemoteVersions="*")
public class Compat {
    @Mod.Instance(value="thutcore_compat")
    public static Compat instance;
    Map<CompatClass.Phase, Set<Method>> initMethods = Maps.newHashMap();

    public Compat() {
        for (CompatClass.Phase phase : CompatClass.Phase.values()) {
            this.initMethods.put(phase, new HashSet());
        }
        CompatParser.findClasses(this.getClass().getPackage().getName(), this.initMethods);
        this.doPhase(CompatClass.Phase.CONSTRUCT, null);
    }

    private void doMetastuff() {
        ModMetadata meta = FMLCommonHandler.instance().findContainerFor((Object)this).getMetadata();
        meta.parent = "thutcore";
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.doPhase(CompatClass.Phase.INIT, evt);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        this.doPhase(CompatClass.Phase.POST, evt);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.doMetastuff();
        this.doPhase(CompatClass.Phase.PRE, evt);
    }

    private void doPhase(CompatClass.Phase pre, Object event) {
        for (Method m : this.initMethods.get((Object)pre)) {
            try {
                CompatClass comp = m.getAnnotation(CompatClass.class);
                if (comp.takesEvent()) {
                    m.invoke(null, event);
                    continue;
                }
                m.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                ThutCore.logger.log(Level.SEVERE, "Error with ", e);
            }
        }
    }
}

