/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.terrain;

import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thut.api.terrain.TerrainEffectEvent;
import thut.api.terrain.TerrainManager;
import thut.api.terrain.TerrainSegment;

public class CapabilityTerrainAffected {
    private static final ResourceLocation TERRAINEFFECTCAP = new ResourceLocation("thutcore", "terrainEffects");
    @CapabilityInject(value=ITerrainAffected.class)
    public static final Capability<ITerrainAffected> TERRAIN_CAP = null;

    public CapabilityTerrainAffected() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEntityCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityLivingBase) || event.getCapabilities().containsKey(TERRAINEFFECTCAP)) {
            return;
        }
        DefaultAffected effects = new DefaultAffected();
        effects.attach((EntityLivingBase)event.getObject());
        event.addCapability(TERRAINEFFECTCAP, (ICapabilityProvider)effects);
    }

    @SubscribeEvent
    public void EntityUpdate(LivingEvent.LivingUpdateEvent evt) {
        ITerrainAffected effects = (ITerrainAffected)evt.getEntityLiving().getCapability(TERRAIN_CAP, null);
        if (effects != null) {
            effects.onTerrainTick();
        }
    }

    public static class DefaultAffected
    implements ITerrainAffected,
    ICapabilityProvider {
        private EntityLivingBase theMob;
        private TerrainSegment terrain;
        private Collection<TerrainSegment.ITerrainEffect> effects;

        public void onTerrainEntry(TerrainSegment entered) {
            if (entered == this.terrain || this.theMob == null) {
                return;
            }
            this.terrain = entered;
            this.effects = this.terrain.getEffects();
            for (TerrainSegment.ITerrainEffect effect : this.effects) {
                TerrainEffectEvent event = new TerrainEffectEvent(this.theMob, effect.getIdenitifer(), true);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) continue;
                effect.doEffect(this.theMob, true);
            }
        }

        @Override
        public void onTerrainTick() {
            if (this.theMob == null) {
                return;
            }
            TerrainSegment current = TerrainManager.getInstance().getTerrainForEntity((Entity)this.theMob);
            if (current != this.terrain) {
                this.onTerrainEntry(current);
                return;
            }
            if (this.effects == null) {
                return;
            }
            for (TerrainSegment.ITerrainEffect effect : this.effects) {
                TerrainEffectEvent event = new TerrainEffectEvent(this.theMob, effect.getIdenitifer(), false);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) continue;
                effect.doEffect(this.theMob, false);
            }
        }

        @Override
        public EntityLivingBase getAttached() {
            return this.theMob;
        }

        @Override
        public void attach(EntityLivingBase mob) {
            this.theMob = mob;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == TERRAIN_CAP;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? TERRAIN_CAP.cast((Object)this) : null);
        }
    }

    public static interface ITerrainAffected {
        public void onTerrainTick();

        public EntityLivingBase getAttached();

        public void attach(EntityLivingBase var1);
    }
}

