/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.world.mobs.data;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thut.api.network.PacketHandler;
import thut.api.world.mobs.data.Data;
import thut.api.world.mobs.data.DataSync;
import thut.core.common.ThutCore;
import thut.core.common.world.mobs.data.DataSync_Impl;
import thut.core.common.world.mobs.data.SyncHandler;

public class PacketDataSync
implements IMessage,
IMessageHandler<PacketDataSync, IMessage> {
    public int id;
    public List<Data<?>> data = Lists.newArrayList();

    public static void sync(EntityPlayerMP syncTo, DataSync data, int entity_id, boolean all) {
        List<Data<?>> list;
        List<Data<?>> list2 = list = all ? data.getAll() : data.getDirty();
        if (list == null) {
            return;
        }
        PacketDataSync packet = new PacketDataSync();
        packet.data = list;
        packet.id = entity_id;
        PacketHandler.packetPipeline.sendTo((IMessage)packet, syncTo);
    }

    public IMessage onMessage(PacketDataSync message, MessageContext ctx) {
        EntityPlayer player = ThutCore.proxy.getPlayer();
        int id = message.id;
        World world = player.func_130014_f_();
        Entity mob = world.func_73045_a(id);
        if (mob == null) {
            return null;
        }
        DataSync sync = SyncHandler.getData(mob);
        if (sync == null) {
            return null;
        }
        sync.update(message.data);
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        int num = buf.readByte();
        if (num > 0) {
            for (int i = 0; i < num; ++i) {
                int uid = buf.readInt();
                try {
                    Data val = (Data)DataSync_Impl.makeData(uid);
                    val.read(buf);
                    this.data.add(val);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        int num = this.data.size();
        buf.writeByte(num);
        for (int i = 0; i < num; ++i) {
            Data<?> val = this.data.get(i);
            buf.writeInt(val.getUID());
            val.write(buf);
        }
    }
}

